/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.engine.impl.formhandler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.content.api.ContentItem;
import org.flowable.content.api.ContentItemQuery;
import org.flowable.content.api.ContentService;
import org.flowable.engine.impl.util.CommandContextUtil;
import org.flowable.form.api.FormFieldHandler;
import org.flowable.form.api.FormInfo;
import org.flowable.form.model.FormField;
import org.flowable.form.model.SimpleFormModel;

public class DefaultFormFieldHandler
implements FormFieldHandler {
    public void handleFormFieldsOnSubmit(FormInfo formInfo, String taskId, String processInstanceId, String scopeId, String scopeType, Map<String, Object> variables, String tenantId) {
        ContentService contentService = CommandContextUtil.getContentService();
        if (contentService == null || formInfo == null) {
            return;
        }
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        if (formModel != null && formModel.getFields() != null) {
            for (FormField formField : formModel.getFields()) {
                String variableValue;
                String variableName;
                if (!"upload".equals(formField.getType()) || !variables.containsKey(variableName = formField.getId()) || !StringUtils.isNotEmpty((CharSequence)(variableValue = (String)variables.get(variableName)))) continue;
                String[] contentItemIds = StringUtils.split((String)variableValue, (String)",");
                HashSet contentItemIdSet = new HashSet();
                Collections.addAll(contentItemIdSet, contentItemIds);
                List contentItems = ((ContentItemQuery)contentService.createContentItemQuery().ids(contentItemIdSet)).list();
                for (ContentItem contentItem : contentItems) {
                    contentItem.setTaskId(taskId);
                    contentItem.setProcessInstanceId(processInstanceId);
                    contentItem.setScopeId(scopeId);
                    contentItem.setScopeType(scopeType);
                    contentItem.setField(formField.getId());
                    contentItem.setTenantId(tenantId);
                    contentService.saveContentItem(contentItem);
                }
            }
        }
    }

    public void enrichFormFields(FormInfo formInfo) {
        ContentService contentService = CommandContextUtil.getContentService();
        if (contentService == null) {
            return;
        }
        SimpleFormModel formModel = (SimpleFormModel)formInfo.getFormModel();
        if (formModel.getFields() != null) {
            for (FormField formField : formModel.getFields()) {
                if (!"upload".equals(formField.getType())) continue;
                ArrayList contentItemIds = null;
                if (formField.getValue() instanceof List) {
                    contentItemIds = (ArrayList)formField.getValue();
                } else if (formField.getValue() instanceof String) {
                    String[] splittedString = ((String)formField.getValue()).split(",");
                    contentItemIds = new ArrayList();
                    Collections.addAll(contentItemIds, splittedString);
                }
                if (contentItemIds == null) continue;
                HashSet contentItemIdSet = new HashSet(contentItemIds);
                List contentItems = ((ContentItemQuery)contentService.createContentItemQuery().ids(contentItemIdSet)).list();
                formField.setValue((Object)contentItems);
            }
        }
    }
}

