/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.to.Item;
import org.apache.syncope.common.lib.to.Mapping;
import org.apache.syncope.common.lib.to.Provision;
import org.apache.syncope.common.lib.types.MappingPurpose;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.data.ItemTransformer;
import org.apache.syncope.core.provisioning.api.data.JEXLItemTransformer;
import org.apache.syncope.core.provisioning.java.data.JEXLItemTransformerImpl;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MappingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MappingUtils.class);
    private static final Map<String, ItemTransformer> PER_CONTEXT_ITEM_TRANSFORMERS = new ConcurrentHashMap<String, ItemTransformer>();

    public static Optional<Item> getConnObjectKeyItem(Provision provision) {
        Mapping mapping = null;
        if (provision != null) {
            mapping = provision.getMapping();
        }
        return mapping == null ? Optional.empty() : mapping.getConnObjectKeyItem();
    }

    public static Stream<Item> getPropagationItems(Stream<Item> items) {
        return items.filter(item -> item.getPurpose() == MappingPurpose.PROPAGATION || item.getPurpose() == MappingPurpose.BOTH);
    }

    public static Stream<Item> getPullItems(Stream<Item> items) {
        return items.filter(item -> item.getPurpose() == MappingPurpose.PULL || item.getPurpose() == MappingPurpose.BOTH);
    }

    public static List<ItemTransformer> getItemTransformers(Item item, List<Implementation> transformers) {
        ArrayList<ItemTransformer> result = new ArrayList<ItemTransformer>();
        if (StringUtils.isNotBlank((CharSequence)item.getPropagationJEXLTransformer()) || StringUtils.isNotBlank((CharSequence)item.getPullJEXLTransformer())) {
            JEXLItemTransformer jexlTransformer = (JEXLItemTransformer)ApplicationContextProvider.getBeanFactory().createBean(JEXLItemTransformerImpl.class, 1, false);
            jexlTransformer.setPropagationJEXL(item.getPropagationJEXLTransformer());
            jexlTransformer.setPullJEXL(item.getPullJEXLTransformer());
            result.add((ItemTransformer)jexlTransformer);
        }
        transformers.forEach(impl -> {
            try {
                result.add((ItemTransformer)ImplementationManager.build((Implementation)impl, () -> PER_CONTEXT_ITEM_TRANSFORMERS.get(impl.getKey()), instance -> PER_CONTEXT_ITEM_TRANSFORMERS.put(impl.getKey(), (ItemTransformer)instance)));
            }
            catch (Exception e) {
                LOG.error("While building {}", impl, (Object)e);
            }
        });
        return result;
    }

    public static OperationOptions buildOperationOptions(Stream<Item> items, String ... moreAttrsToGet) {
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        HashSet<String> attrsToGet = new HashSet<String>();
        attrsToGet.add(Name.NAME);
        attrsToGet.add(Uid.NAME);
        attrsToGet.add(OperationalAttributes.ENABLE_NAME);
        if (!ArrayUtils.isEmpty((Object[])moreAttrsToGet)) {
            attrsToGet.addAll(List.of(moreAttrsToGet));
        }
        items.filter(item -> item.getPurpose() != MappingPurpose.NONE).forEach(item -> attrsToGet.add(item.getExtAttrName()));
        builder.setAttributesToGet(attrsToGet);
        return builder.build();
    }

    private MappingUtils() {
    }
}

