/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job.notification;

import java.time.OffsetDateTime;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.syncope.common.lib.types.AuditElements;
import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.common.lib.types.TraceLevel;
import org.apache.syncope.core.persistence.api.dao.TaskDAO;
import org.apache.syncope.core.persistence.api.entity.task.NotificationTask;
import org.apache.syncope.core.persistence.api.entity.task.Task;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.api.entity.task.TaskUtilsFactory;
import org.apache.syncope.core.provisioning.api.AuditManager;
import org.apache.syncope.core.provisioning.api.event.JobStatusEvent;
import org.apache.syncope.core.provisioning.api.job.JobManager;
import org.apache.syncope.core.provisioning.api.notification.NotificationJobDelegate;
import org.apache.syncope.core.provisioning.api.notification.NotificationManager;
import org.apache.syncope.core.provisioning.api.utils.ExceptionUtils2;
import org.apache.syncope.core.provisioning.java.job.notification.NotificationJob;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractNotificationJobDelegate
implements NotificationJobDelegate {
    protected static final Logger LOG = LoggerFactory.getLogger(NotificationJobDelegate.class);
    protected final TaskDAO taskDAO;
    protected final TaskUtilsFactory taskUtilsFactory;
    protected final AuditManager auditManager;
    protected final NotificationManager notificationManager;
    protected final ApplicationEventPublisher publisher;
    protected boolean interrupt;
    protected boolean interrupted;

    protected AbstractNotificationJobDelegate(TaskDAO taskDAO, TaskUtilsFactory taskUtilsFactory, AuditManager auditManager, NotificationManager notificationManager, ApplicationEventPublisher publisher) {
        this.taskDAO = taskDAO;
        this.taskUtilsFactory = taskUtilsFactory;
        this.auditManager = auditManager;
        this.notificationManager = notificationManager;
        this.publisher = publisher;
    }

    protected void setStatus(String status) {
        this.publisher.publishEvent((ApplicationEvent)new JobStatusEvent((Object)this, JobManager.NOTIFICATION_JOB.getName(), status));
    }

    public void interrupt() {
        this.interrupt = true;
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    protected abstract void notify(String var1, NotificationTask var2, TaskExec<NotificationTask> var3) throws Exception;

    @Transactional
    public TaskExec<NotificationTask> executeSingle(NotificationTask task, String executor) {
        TaskExec execution = this.taskUtilsFactory.getInstance(TaskType.NOTIFICATION).newTaskExec();
        execution.setTask((Task)task);
        execution.setStart(OffsetDateTime.now());
        execution.setExecutor(executor);
        boolean retryPossible = true;
        if (StringUtils.isBlank((CharSequence)task.getSubject()) || task.getRecipients().isEmpty() || StringUtils.isBlank((CharSequence)task.getHtmlBody()) || StringUtils.isBlank((CharSequence)task.getTextBody())) {
            String message = "Could not fetch all required information for sending out notifications:\nFrom: " + task.getSender() + "\nTo: " + String.valueOf(task.getRecipients()) + "\nSubject: " + task.getSubject() + "\nHTML body:\n" + task.getHtmlBody() + "\nText body:\n" + task.getTextBody() + "\n";
            LOG.error(message);
            execution.setStatus(NotificationJob.Status.NOT_SENT.name());
            retryPossible = false;
            if (task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                execution.setMessage(message);
            }
        } else {
            LOG.debug("About to send notifications:\nFrom: {}\nTo: {}\nSubject: {}\nHTML body:\n{}\nText body:\n{}\n", new Object[]{task.getSender(), task.getRecipients(), task.getSubject(), task.getHtmlBody(), task.getTextBody()});
            this.setStatus("Sending notifications to " + String.valueOf(task.getRecipients()));
            for (String to : task.getRecipients()) {
                try {
                    this.notify(to, task, (TaskExec<NotificationTask>)execution);
                    this.notificationManager.createTasks(AuthContextUtils.getWho(), AuditElements.EventCategoryType.TASK, "notification", null, "send", AuditElements.Result.SUCCESS, null, null, new Object[]{task, "Successfully sent notification to " + to});
                }
                catch (Exception e) {
                    LOG.error("Could not send out notification", (Throwable)e);
                    execution.setStatus(NotificationJob.Status.NOT_SENT.name());
                    if (task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal()) {
                        execution.setMessage(ExceptionUtils2.getFullStackTrace((Throwable)e));
                    }
                    this.notificationManager.createTasks(AuthContextUtils.getWho(), AuditElements.EventCategoryType.TASK, "notification", null, "send", AuditElements.Result.FAILURE, null, null, new Object[]{task, "Could not send notification to " + to, e});
                }
                execution.setEnd(OffsetDateTime.now());
            }
        }
        if (AbstractNotificationJobDelegate.hasToBeRegistered((TaskExec<NotificationTask>)execution)) {
            execution = this.notificationManager.storeExec(execution);
            if (retryPossible && NotificationJob.Status.valueOf(execution.getStatus()) == NotificationJob.Status.NOT_SENT) {
                this.handleRetries((TaskExec<NotificationTask>)execution);
            }
        } else {
            this.notificationManager.setTaskExecuted(((NotificationTask)execution.getTask()).getKey(), true);
        }
        return execution;
    }

    @Transactional
    public void execute(String executor) throws JobExecutionException {
        List tasks = this.taskDAO.findToExec(TaskType.NOTIFICATION);
        this.setStatus("Sending out " + tasks.size() + " notifications");
        for (int i = 0; i < tasks.size() && !this.interrupt; ++i) {
            LOG.debug("Found notification task {} to be executed: starting...", tasks.get(i));
            this.executeSingle((NotificationTask)tasks.get(i), executor);
            LOG.debug("Notification task {} executed", tasks.get(i));
        }
        if (this.interrupt) {
            LOG.debug("Notification job interrupted");
            this.interrupted = true;
        }
        this.setStatus(null);
    }

    protected static boolean hasToBeRegistered(TaskExec<NotificationTask> execution) {
        NotificationTask task = (NotificationTask)execution.getTask();
        return NotificationJob.Status.valueOf(execution.getStatus()) == NotificationJob.Status.NOT_SENT && task.getTraceLevel().ordinal() >= TraceLevel.FAILURES.ordinal() || task.getTraceLevel() == TraceLevel.ALL;
    }

    protected void handleRetries(TaskExec<NotificationTask> execution) {
        if (this.notificationManager.getMaxRetries() <= 0L) {
            return;
        }
        long failedExecutionsCount = this.notificationManager.countExecutionsWithStatus(((NotificationTask)execution.getTask()).getKey(), NotificationJob.Status.NOT_SENT.name());
        if (failedExecutionsCount <= this.notificationManager.getMaxRetries()) {
            LOG.debug("Execution of notification task {} will be retried [{}/{}]", new Object[]{execution.getTask(), failedExecutionsCount, this.notificationManager.getMaxRetries()});
            this.notificationManager.setTaskExecuted(((NotificationTask)execution.getTask()).getKey(), false);
            this.auditManager.audit(AuthContextUtils.getWho(), AuditElements.EventCategoryType.TASK, "notification", null, "retry", AuditElements.Result.SUCCESS, null, null, new Object[]{execution, "Notification task " + ((NotificationTask)execution.getTask()).getKey() + " will be retried"});
        } else {
            LOG.error("Maximum number of retries reached for task {} - giving up", (Object)execution.getTask());
            this.auditManager.audit(AuthContextUtils.getWho(), AuditElements.EventCategoryType.TASK, "notification", null, "retry", AuditElements.Result.FAILURE, null, null, new Object[]{execution, "Giving up retries on notification task " + ((NotificationTask)execution.getTask()).getKey()});
        }
    }
}

