/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import org.apache.syncope.common.lib.to.ConnInstanceTO;
import org.apache.syncope.common.lib.to.ConnPoolConfTO;
import org.apache.syncope.common.lib.types.ConnConfProperty;
import org.apache.syncope.common.lib.types.ConnectorCapability;
import org.apache.syncope.core.persistence.api.dao.ExternalResourceDAO;
import org.apache.syncope.core.persistence.api.dao.RealmDAO;
import org.apache.syncope.core.persistence.api.entity.ConnInstance;
import org.apache.syncope.core.persistence.api.entity.ConnPoolConf;
import org.apache.syncope.core.persistence.api.entity.EntityFactory;
import org.apache.syncope.core.persistence.api.entity.ExternalResource;
import org.apache.syncope.core.provisioning.api.ConnIdBundleManager;
import org.apache.syncope.core.provisioning.api.Connector;
import org.apache.syncope.core.provisioning.api.ConnectorManager;
import org.apache.syncope.core.provisioning.api.data.ConnInstanceDataBinder;
import org.apache.syncope.core.provisioning.api.utils.ConnPoolConfUtils;
import org.apache.syncope.core.provisioning.java.AsyncConnectorFacade;
import org.apache.syncope.core.provisioning.java.ConnectorFacadeProxy;
import org.apache.syncope.core.spring.ApplicationContextProvider;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.identityconnectors.common.l10n.CurrentLocale;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public class DefaultConnectorManager
implements ConnectorManager {
    protected static final Logger LOG = LoggerFactory.getLogger(ConnectorManager.class);
    protected final ConnIdBundleManager connIdBundleManager;
    protected final RealmDAO realmDAO;
    protected final ExternalResourceDAO resourceDAO;
    protected final ConnInstanceDataBinder connInstanceDataBinder;
    protected final AsyncConnectorFacade asyncFacade;
    protected final EntityFactory entityFactory;

    protected static String getBeanName(ExternalResource resource) {
        return String.format("connInstance-%s-%S-%s", AuthContextUtils.getDomain(), resource.getConnector().getKey(), resource.getKey());
    }

    public DefaultConnectorManager(ConnIdBundleManager connIdBundleManager, RealmDAO realmDAO, ExternalResourceDAO resourceDAO, ConnInstanceDataBinder connInstanceDataBinder, AsyncConnectorFacade asyncFacade, EntityFactory entityFactory) {
        this.connIdBundleManager = connIdBundleManager;
        this.realmDAO = realmDAO;
        this.resourceDAO = resourceDAO;
        this.connInstanceDataBinder = connInstanceDataBinder;
        this.asyncFacade = asyncFacade;
        this.entityFactory = entityFactory;
    }

    public Optional<Connector> readConnector(ExternalResource resource) {
        return Optional.ofNullable((Connector)ApplicationContextProvider.getBeanFactory().getSingleton(DefaultConnectorManager.getBeanName(resource)));
    }

    public Connector getConnector(ExternalResource resource) {
        return this.readConnector(resource).orElseGet(() -> {
            this.registerConnector(resource);
            return (Connector)ApplicationContextProvider.getBeanFactory().getSingleton(DefaultConnectorManager.getBeanName(resource));
        });
    }

    public ConnInstance buildConnInstanceOverride(ConnInstanceTO connInstance, Collection<ConnConfProperty> confOverride, Optional<Collection<ConnectorCapability>> capabilitiesOverride) {
        ConnInstance override = (ConnInstance)this.entityFactory.newEntity(ConnInstance.class);
        override.setAdminRealm(this.realmDAO.findByFullPath(connInstance.getAdminRealm()));
        override.setConnectorName(connInstance.getConnectorName());
        override.setDisplayName(connInstance.getDisplayName());
        override.setBundleName(connInstance.getBundleName());
        override.setVersion(connInstance.getVersion());
        override.setLocation(connInstance.getLocation());
        override.setConf((Collection)connInstance.getConf());
        override.getCapabilities().addAll(connInstance.getCapabilities());
        override.setConnRequestTimeout(connInstance.getConnRequestTimeout());
        HashMap overridable = new HashMap();
        HashSet conf = new HashSet();
        override.getConf().forEach(prop -> {
            if (prop.isOverridable()) {
                overridable.put(prop.getSchema().getName(), prop);
            } else {
                conf.add(prop);
            }
        });
        confOverride.stream().filter(prop -> overridable.containsKey(prop.getSchema().getName()) && !prop.getValues().isEmpty()).forEach(prop -> {
            conf.add(prop);
            overridable.remove(prop.getSchema().getName());
        });
        conf.addAll(overridable.values());
        override.setConf(conf);
        capabilitiesOverride.ifPresent(capabilities -> {
            override.getCapabilities().clear();
            override.getCapabilities().addAll(capabilities);
        });
        if (connInstance.getPoolConf() != null) {
            override.setPoolConf(ConnPoolConfUtils.getConnPoolConf((ConnPoolConfTO)connInstance.getPoolConf(), (ConnPoolConf)this.entityFactory.newConnPoolConf()));
        }
        return override;
    }

    public Connector createConnector(ConnInstance connInstance) {
        return new ConnectorFacadeProxy(connInstance, this.asyncFacade);
    }

    public void registerConnector(ExternalResource resource) {
        String beanName = DefaultConnectorManager.getBeanName(resource);
        if (ApplicationContextProvider.getBeanFactory().containsSingleton(beanName)) {
            this.unregisterConnector(beanName);
        }
        ConnInstance connInstance = this.buildConnInstanceOverride(this.connInstanceDataBinder.getConnInstanceTO(resource.getConnector()), resource.getConfOverride(), resource.isOverrideCapabilities() ? Optional.of(resource.getCapabilitiesOverride()) : Optional.empty());
        Connector connector = this.createConnector(connInstance);
        LOG.debug("Connector to be registered: {}", (Object)connector);
        ApplicationContextProvider.getBeanFactory().registerSingleton(beanName, (Object)connector);
        LOG.debug("Successfully registered bean {}", (Object)beanName);
    }

    protected void unregisterConnector(String id) {
        ApplicationContextProvider.getBeanFactory().destroySingleton(id);
    }

    public void unregisterConnector(ExternalResource resource) {
        String beanName = DefaultConnectorManager.getBeanName(resource);
        if (ApplicationContextProvider.getBeanFactory().containsSingleton(beanName)) {
            this.unregisterConnector(beanName);
        }
    }

    @Transactional(readOnly=true)
    public void load() {
        CurrentLocale.set((Locale)Locale.ENGLISH);
        this.connIdBundleManager.getConnManagers();
        int connectors = 0;
        for (ExternalResource resource : this.resourceDAO.findAll()) {
            LOG.info("Registering resource-connector pair {}-{}", (Object)resource, (Object)resource.getConnector());
            try {
                this.registerConnector(resource);
                ++connectors;
            }
            catch (Exception e) {
                LOG.error("While registering resource-connector pair {}-{}", new Object[]{resource, resource.getConnector(), e});
            }
        }
        LOG.info("Done loading {} connectors", (Object)connectors);
    }

    @Transactional(readOnly=true)
    public void unload() {
        int connectors = 0;
        for (ExternalResource resource : this.resourceDAO.findAll()) {
            String beanName = DefaultConnectorManager.getBeanName(resource);
            if (!ApplicationContextProvider.getBeanFactory().containsSingleton(beanName)) continue;
            LOG.info("Unegistering resource-connector pair {}-{}", (Object)resource, (Object)resource.getConnector());
            this.getConnector(resource).dispose();
            this.unregisterConnector(beanName);
            ++connectors;
        }
        LOG.info("Done unloading {} connectors", (Object)connectors);
        ConnectorFacadeFactory.getInstance().dispose();
        this.connIdBundleManager.resetConnManagers();
        LOG.info("All connector resources disposed");
    }
}

