/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.opencsv.bean;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.ResourceBundle;
import liquibase.repackaged.com.opencsv.CSVReader;
import liquibase.repackaged.com.opencsv.bean.AbstractMappingStrategy;
import liquibase.repackaged.com.opencsv.bean.BeanField;
import liquibase.repackaged.com.opencsv.bean.BeanFieldSingleValue;
import liquibase.repackaged.com.opencsv.bean.ComplexFieldMapEntry;
import liquibase.repackaged.com.opencsv.bean.CsvConverter;
import liquibase.repackaged.com.opencsv.bean.CsvRecurse;
import liquibase.repackaged.com.opencsv.bean.FieldMap;
import liquibase.repackaged.com.opencsv.bean.FieldMapByName;
import liquibase.repackaged.com.opencsv.bean.FieldMapByNameEntry;
import liquibase.repackaged.com.opencsv.exceptions.CsvBadConverterException;
import liquibase.repackaged.com.opencsv.exceptions.CsvRequiredFieldEmptyException;
import liquibase.repackaged.org.apache.commons.collections4.ListValuedMap;
import liquibase.repackaged.org.apache.commons.lang3.ArrayUtils;

public abstract class HeaderNameBaseMappingStrategy<T>
extends AbstractMappingStrategy<String, String, ComplexFieldMapEntry<String, String, T>, T> {
    protected FieldMapByName<T> fieldMap = null;
    protected Comparator<String> writeOrder = null;
    protected final boolean forceCorrectRecordLength;

    public HeaderNameBaseMappingStrategy() {
        this.forceCorrectRecordLength = false;
    }

    public HeaderNameBaseMappingStrategy(boolean forceCorrectRecordLength) {
        this.forceCorrectRecordLength = forceCorrectRecordLength;
    }

    @Override
    public void captureHeader(CSVReader reader) throws IOException, CsvRequiredFieldEmptyException {
        if (this.type == null) {
            throw new IllegalStateException(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("type.unset"));
        }
        CharSequence[] header = ArrayUtils.nullToEmpty(reader.readNextSilently());
        for (int i2 = 0; i2 < header.length; ++i2) {
            if (header[i2] != null) continue;
            header[i2] = "";
        }
        this.headerIndex.initializeHeaderIndex((String[])header);
        List<FieldMapByNameEntry<T>> missingRequiredHeaders = this.fieldMap.determineMissingRequiredHeaders((String[])header);
        if (!missingRequiredHeaders.isEmpty()) {
            CharSequence[] requiredHeaderNames = new String[missingRequiredHeaders.size()];
            ArrayList<Field> requiredFields = new ArrayList<Field>(missingRequiredHeaders.size());
            for (int i3 = 0; i3 < missingRequiredHeaders.size(); ++i3) {
                FieldMapByNameEntry<T> fme = missingRequiredHeaders.get(i3);
                requiredHeaderNames[i3] = fme.isRegexPattern() ? String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("matching"), fme.getName()) : fme.getName();
                requiredFields.add(fme.getField().getField());
            }
            String missingRequiredFields = String.join((CharSequence)", ", requiredHeaderNames);
            String allHeaders = String.join((CharSequence)",", header);
            CsvRequiredFieldEmptyException e2 = new CsvRequiredFieldEmptyException(this.type, requiredFields, String.format(ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.required.field.absent"), missingRequiredFields, allHeaders));
            e2.setLine((String[])header);
            throw e2;
        }
    }

    @Override
    protected String chooseMultivaluedFieldIndexFromHeaderIndex(int index) {
        String[] s2 = this.headerIndex.getHeaderIndex();
        return index >= s2.length ? null : s2[index];
    }

    @Override
    public void verifyLineLength(int numberOfFields) throws CsvRequiredFieldEmptyException {
        if (!this.headerIndex.isEmpty() && numberOfFields != this.headerIndex.getHeaderIndexLength() && !this.forceCorrectRecordLength) {
            throw new CsvRequiredFieldEmptyException(this.type, ResourceBundle.getBundle("opencsv", this.errorLocale).getString("header.data.mismatch"));
        }
    }

    @Override
    protected BeanField<T, String> findField(int col) throws CsvBadConverterException {
        BeanField beanField = null;
        String columnName = this.getColumnName(col);
        if (columnName == null) {
            return null;
        }
        if (!(columnName = columnName.trim()).isEmpty()) {
            beanField = this.fieldMap.get(columnName.toUpperCase());
        }
        return beanField;
    }

    @Override
    protected void loadUnadornedFieldMap(ListValuedMap<Class<?>, Field> fields) {
        fields.entries().stream().filter(entry -> !Serializable.class.isAssignableFrom((Class)entry.getKey()) || !"serialVersionUID".equals(((Field)entry.getValue()).getName())).filter(entry -> !((Field)entry.getValue()).isAnnotationPresent(CsvRecurse.class)).forEach(entry -> {
            CsvConverter converter = this.determineConverter((Field)entry.getValue(), ((Field)entry.getValue()).getType(), null, null, null);
            this.fieldMap.put(((Field)entry.getValue()).getName().toUpperCase(), new BeanFieldSingleValue((Class)entry.getKey(), (Field)entry.getValue(), false, this.errorLocale, converter, null, null));
        });
    }

    @Override
    protected void initializeFieldMap() {
        this.fieldMap = new FieldMapByName(this.errorLocale);
        this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
    }

    @Override
    protected FieldMap<String, String, ? extends ComplexFieldMapEntry<String, String, T>, T> getFieldMap() {
        return this.fieldMap;
    }

    @Override
    public String findHeader(int col) {
        return this.headerIndex.getByPosition(col);
    }

    public void setColumnOrderOnWrite(Comparator<String> writeOrder) {
        this.writeOrder = writeOrder;
        if (this.fieldMap != null) {
            this.fieldMap.setColumnOrderOnWrite(this.writeOrder);
        }
    }
}

