/*
 * Decompiled with CFR 0.152.
 */
package com.yubico.fido.metadata;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.yubico.fido.metadata.AAGUID;
import com.yubico.fido.metadata.AAID;
import com.yubico.fido.metadata.AuthenticatorStatus;
import com.yubico.fido.metadata.BiometricStatusReport;
import com.yubico.fido.metadata.MetadataStatement;
import com.yubico.fido.metadata.StatusReport;
import com.yubico.internal.util.CollectionUtil;
import com.yubico.webauthn.data.ByteArray;
import java.net.URL;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;

@JsonDeserialize(builder=MetadataBLOBPayloadEntryBuilder.class)
public final class MetadataBLOBPayloadEntry {
    private final AAID aaid;
    private final AAGUID aaguid;
    private final Set<String> attestationCertificateKeyIdentifiers;
    private final MetadataStatement metadataStatement;
    private final List<BiometricStatusReport> biometricStatusReports;
    @NonNull
    private final List<StatusReport> statusReports;
    @NonNull
    private final LocalDate timeOfLastStatusChange;
    private final URL rogueListURL;
    private final ByteArray rogueListHash;

    private MetadataBLOBPayloadEntry(AAID aaid, AAGUID aaguid, Set<String> attestationCertificateKeyIdentifiers, MetadataStatement metadataStatement, List<BiometricStatusReport> biometricStatusReports, @NonNull List<StatusReport> statusReports, @NonNull LocalDate timeOfLastStatusChange, URL rogueListURL, ByteArray rogueListHash) {
        if (statusReports == null) {
            throw new NullPointerException("statusReports is marked non-null but is null");
        }
        if (timeOfLastStatusChange == null) {
            throw new NullPointerException("timeOfLastStatusChange is marked non-null but is null");
        }
        this.aaid = aaid;
        this.aaguid = aaguid;
        this.attestationCertificateKeyIdentifiers = CollectionUtil.immutableSetOrEmpty(attestationCertificateKeyIdentifiers);
        this.metadataStatement = metadataStatement;
        this.biometricStatusReports = CollectionUtil.immutableListOrEmpty(biometricStatusReports);
        this.statusReports = Collections.unmodifiableList(statusReports.stream().filter(statusReport -> !statusReport.getStatus().equals((Object)AuthenticatorStatus.UNKNOWN)).collect(Collectors.toList()));
        this.timeOfLastStatusChange = timeOfLastStatusChange;
        this.rogueListURL = rogueListURL;
        this.rogueListHash = rogueListHash;
    }

    public Optional<AAID> getAaid() {
        return Optional.ofNullable(this.aaid);
    }

    public Optional<AAGUID> getAaguid() {
        return Optional.ofNullable(this.aaguid);
    }

    public Optional<MetadataStatement> getMetadataStatement() {
        return Optional.ofNullable(this.metadataStatement);
    }

    public Optional<LocalDate> getTimeOfLastStatusChange() {
        return Optional.of(this.timeOfLastStatusChange);
    }

    public Optional<URL> getRogueListURL() {
        return Optional.ofNullable(this.rogueListURL);
    }

    public Optional<ByteArray> getRogueListHash() {
        return Optional.ofNullable(this.rogueListHash);
    }

    @Generated
    public static MetadataBLOBPayloadEntryBuilder builder() {
        return new MetadataBLOBPayloadEntryBuilder();
    }

    @Generated
    public MetadataBLOBPayloadEntryBuilder toBuilder() {
        return new MetadataBLOBPayloadEntryBuilder().aaid(this.aaid).aaguid(this.aaguid).attestationCertificateKeyIdentifiers(this.attestationCertificateKeyIdentifiers).metadataStatement(this.metadataStatement).biometricStatusReports(this.biometricStatusReports).statusReports(this.statusReports).timeOfLastStatusChange(this.timeOfLastStatusChange).rogueListURL(this.rogueListURL).rogueListHash(this.rogueListHash);
    }

    @Generated
    public Set<String> getAttestationCertificateKeyIdentifiers() {
        return this.attestationCertificateKeyIdentifiers;
    }

    @Generated
    public List<BiometricStatusReport> getBiometricStatusReports() {
        return this.biometricStatusReports;
    }

    @NonNull
    @Generated
    public List<StatusReport> getStatusReports() {
        return this.statusReports;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetadataBLOBPayloadEntry)) {
            return false;
        }
        MetadataBLOBPayloadEntry other = (MetadataBLOBPayloadEntry)o;
        Optional<AAID> this$aaid = this.getAaid();
        Optional<AAID> other$aaid = other.getAaid();
        if (this$aaid == null ? other$aaid != null : !((Object)this$aaid).equals(other$aaid)) {
            return false;
        }
        Optional<AAGUID> this$aaguid = this.getAaguid();
        Optional<AAGUID> other$aaguid = other.getAaguid();
        if (this$aaguid == null ? other$aaguid != null : !((Object)this$aaguid).equals(other$aaguid)) {
            return false;
        }
        Set<String> this$attestationCertificateKeyIdentifiers = this.getAttestationCertificateKeyIdentifiers();
        Set<String> other$attestationCertificateKeyIdentifiers = other.getAttestationCertificateKeyIdentifiers();
        if (this$attestationCertificateKeyIdentifiers == null ? other$attestationCertificateKeyIdentifiers != null : !((Object)this$attestationCertificateKeyIdentifiers).equals(other$attestationCertificateKeyIdentifiers)) {
            return false;
        }
        Optional<MetadataStatement> this$metadataStatement = this.getMetadataStatement();
        Optional<MetadataStatement> other$metadataStatement = other.getMetadataStatement();
        if (this$metadataStatement == null ? other$metadataStatement != null : !((Object)this$metadataStatement).equals(other$metadataStatement)) {
            return false;
        }
        List<BiometricStatusReport> this$biometricStatusReports = this.getBiometricStatusReports();
        List<BiometricStatusReport> other$biometricStatusReports = other.getBiometricStatusReports();
        if (this$biometricStatusReports == null ? other$biometricStatusReports != null : !((Object)this$biometricStatusReports).equals(other$biometricStatusReports)) {
            return false;
        }
        List<StatusReport> this$statusReports = this.getStatusReports();
        List<StatusReport> other$statusReports = other.getStatusReports();
        if (this$statusReports == null ? other$statusReports != null : !((Object)this$statusReports).equals(other$statusReports)) {
            return false;
        }
        Optional<LocalDate> this$timeOfLastStatusChange = this.getTimeOfLastStatusChange();
        Optional<LocalDate> other$timeOfLastStatusChange = other.getTimeOfLastStatusChange();
        if (this$timeOfLastStatusChange == null ? other$timeOfLastStatusChange != null : !((Object)this$timeOfLastStatusChange).equals(other$timeOfLastStatusChange)) {
            return false;
        }
        Optional<URL> this$rogueListURL = this.getRogueListURL();
        Optional<URL> other$rogueListURL = other.getRogueListURL();
        if (this$rogueListURL == null ? other$rogueListURL != null : !((Object)this$rogueListURL).equals(other$rogueListURL)) {
            return false;
        }
        Optional<ByteArray> this$rogueListHash = this.getRogueListHash();
        Optional<ByteArray> other$rogueListHash = other.getRogueListHash();
        return !(this$rogueListHash == null ? other$rogueListHash != null : !((Object)this$rogueListHash).equals(other$rogueListHash));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<AAID> $aaid = this.getAaid();
        result = result * 59 + ($aaid == null ? 43 : ((Object)$aaid).hashCode());
        Optional<AAGUID> $aaguid = this.getAaguid();
        result = result * 59 + ($aaguid == null ? 43 : ((Object)$aaguid).hashCode());
        Set<String> $attestationCertificateKeyIdentifiers = this.getAttestationCertificateKeyIdentifiers();
        result = result * 59 + ($attestationCertificateKeyIdentifiers == null ? 43 : ((Object)$attestationCertificateKeyIdentifiers).hashCode());
        Optional<MetadataStatement> $metadataStatement = this.getMetadataStatement();
        result = result * 59 + ($metadataStatement == null ? 43 : ((Object)$metadataStatement).hashCode());
        List<BiometricStatusReport> $biometricStatusReports = this.getBiometricStatusReports();
        result = result * 59 + ($biometricStatusReports == null ? 43 : ((Object)$biometricStatusReports).hashCode());
        List<StatusReport> $statusReports = this.getStatusReports();
        result = result * 59 + ($statusReports == null ? 43 : ((Object)$statusReports).hashCode());
        Optional<LocalDate> $timeOfLastStatusChange = this.getTimeOfLastStatusChange();
        result = result * 59 + ($timeOfLastStatusChange == null ? 43 : ((Object)$timeOfLastStatusChange).hashCode());
        Optional<URL> $rogueListURL = this.getRogueListURL();
        result = result * 59 + ($rogueListURL == null ? 43 : ((Object)$rogueListURL).hashCode());
        Optional<ByteArray> $rogueListHash = this.getRogueListHash();
        result = result * 59 + ($rogueListHash == null ? 43 : ((Object)$rogueListHash).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "MetadataBLOBPayloadEntry(aaid=" + this.getAaid() + ", aaguid=" + this.getAaguid() + ", attestationCertificateKeyIdentifiers=" + this.getAttestationCertificateKeyIdentifiers() + ", metadataStatement=" + this.getMetadataStatement() + ", biometricStatusReports=" + this.getBiometricStatusReports() + ", statusReports=" + this.getStatusReports() + ", timeOfLastStatusChange=" + this.getTimeOfLastStatusChange() + ", rogueListURL=" + this.getRogueListURL() + ", rogueListHash=" + this.getRogueListHash() + ")";
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class MetadataBLOBPayloadEntryBuilder {
        @Generated
        private AAID aaid;
        @Generated
        private AAGUID aaguid;
        @Generated
        private Set<String> attestationCertificateKeyIdentifiers;
        @Generated
        private MetadataStatement metadataStatement;
        @Generated
        private List<BiometricStatusReport> biometricStatusReports;
        @Generated
        private List<StatusReport> statusReports;
        @Generated
        private LocalDate timeOfLastStatusChange;
        @Generated
        private URL rogueListURL;
        @Generated
        private ByteArray rogueListHash;

        @Generated
        MetadataBLOBPayloadEntryBuilder() {
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder aaid(AAID aaid) {
            this.aaid = aaid;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder aaguid(AAGUID aaguid) {
            this.aaguid = aaguid;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder attestationCertificateKeyIdentifiers(Set<String> attestationCertificateKeyIdentifiers) {
            this.attestationCertificateKeyIdentifiers = attestationCertificateKeyIdentifiers;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder metadataStatement(MetadataStatement metadataStatement) {
            this.metadataStatement = metadataStatement;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder biometricStatusReports(List<BiometricStatusReport> biometricStatusReports) {
            this.biometricStatusReports = biometricStatusReports;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder statusReports(@NonNull List<StatusReport> statusReports) {
            if (statusReports == null) {
                throw new NullPointerException("statusReports is marked non-null but is null");
            }
            this.statusReports = statusReports;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder timeOfLastStatusChange(@NonNull LocalDate timeOfLastStatusChange) {
            if (timeOfLastStatusChange == null) {
                throw new NullPointerException("timeOfLastStatusChange is marked non-null but is null");
            }
            this.timeOfLastStatusChange = timeOfLastStatusChange;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder rogueListURL(URL rogueListURL) {
            this.rogueListURL = rogueListURL;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntryBuilder rogueListHash(ByteArray rogueListHash) {
            this.rogueListHash = rogueListHash;
            return this;
        }

        @Generated
        public MetadataBLOBPayloadEntry build() {
            return new MetadataBLOBPayloadEntry(this.aaid, this.aaguid, this.attestationCertificateKeyIdentifiers, this.metadataStatement, this.biometricStatusReports, this.statusReports, this.timeOfLastStatusChange, this.rogueListURL, this.rogueListHash);
        }

        @Generated
        public String toString() {
            return "MetadataBLOBPayloadEntry.MetadataBLOBPayloadEntryBuilder(aaid=" + this.aaid + ", aaguid=" + this.aaguid + ", attestationCertificateKeyIdentifiers=" + this.attestationCertificateKeyIdentifiers + ", metadataStatement=" + this.metadataStatement + ", biometricStatusReports=" + this.biometricStatusReports + ", statusReports=" + this.statusReports + ", timeOfLastStatusChange=" + this.timeOfLastStatusChange + ", rogueListURL=" + this.rogueListURL + ", rogueListHash=" + this.rogueListHash + ")";
        }
    }
}

