/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.config;

import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;
import org.springframework.webflow.conversation.ConversationManager;
import org.springframework.webflow.conversation.impl.SessionBindingConversationManager;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.definition.registry.FlowDefinitionLocator;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.FlowExecutionListener;
import org.springframework.webflow.execution.factory.ConditionalFlowExecutionListenerLoader;
import org.springframework.webflow.execution.factory.FlowExecutionListenerCriteriaFactory;
import org.springframework.webflow.execution.repository.impl.DefaultFlowExecutionRepository;
import org.springframework.webflow.execution.repository.snapshot.FlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SerializedFlowExecutionSnapshotFactory;
import org.springframework.webflow.execution.repository.snapshot.SimpleFlowExecutionSnapshotFactory;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.FlowExecutorImpl;

public class FlowExecutorBuilder {
    private final FlowDefinitionLocator flowRegistry;
    private Integer maxFlowExecutions;
    private Integer maxFlowExecutionSnapshots;
    private LocalAttributeMap<Object> executionAttributes = new LocalAttributeMap();
    private ConditionalFlowExecutionListenerLoader listenerLoader;
    private FlowExecutionListenerCriteriaFactory listenerCriteriaFactory = new FlowExecutionListenerCriteriaFactory();
    private ConversationManager conversationManager;

    public FlowExecutorBuilder(FlowDefinitionLocator flowRegistry) {
        Assert.notNull((Object)flowRegistry, (String)"FlowDefinitionLocator is required");
        this.flowRegistry = flowRegistry;
    }

    public FlowExecutorBuilder(FlowDefinitionLocator flowRegistry, ApplicationContext applicationContext) {
        Assert.notNull((Object)flowRegistry, (String)"FlowDefinitionLocator is required");
        this.flowRegistry = flowRegistry;
    }

    public FlowExecutorBuilder setMaxFlowExecutions(int maxFlowExecutions) {
        this.maxFlowExecutions = maxFlowExecutions;
        return this;
    }

    public FlowExecutorBuilder setMaxFlowExecutionSnapshots(int maxFlowExecutionSnapshots) {
        this.maxFlowExecutionSnapshots = maxFlowExecutionSnapshots;
        return this;
    }

    public FlowExecutorBuilder setAlwaysRedirectOnPause(boolean redirectOnPause) {
        this.executionAttributes.put("alwaysRedirectOnPause", redirectOnPause);
        return this;
    }

    public FlowExecutorBuilder setRedirectInSameState(boolean redirectInSameState) {
        this.executionAttributes.put("redirectInSameState", redirectInSameState);
        return this;
    }

    public FlowExecutorBuilder addFlowExecutionAttribute(String name, Object value) {
        this.executionAttributes.put(name, value);
        return this;
    }

    public FlowExecutorBuilder addFlowExecutionListener(FlowExecutionListener listener) {
        return this.addFlowExecutionListener(listener, "*");
    }

    public FlowExecutorBuilder addFlowExecutionListener(FlowExecutionListener listener, String criteria) {
        if (this.listenerLoader == null) {
            this.listenerLoader = new ConditionalFlowExecutionListenerLoader();
        }
        this.listenerLoader.addListener(listener, this.listenerCriteriaFactory.getListenerCriteria(criteria));
        return this;
    }

    public FlowExecutorBuilder setConversationManager(ConversationManager conversationManager) {
        this.conversationManager = conversationManager;
        return this;
    }

    public FlowExecutor build() {
        FlowExecutionImplFactory executionFactory = this.getExecutionFactory();
        DefaultFlowExecutionRepository executionRepository = this.getFlowExecutionRepository(executionFactory);
        executionFactory.setExecutionKeyFactory(executionRepository);
        return new FlowExecutorImpl(this.flowRegistry, executionFactory, executionRepository);
    }

    private FlowExecutionImplFactory getExecutionFactory() {
        FlowExecutionImplFactory executionFactory = new FlowExecutionImplFactory();
        executionFactory.setExecutionAttributes(this.getExecutionAttributes());
        if (this.listenerLoader != null) {
            executionFactory.setExecutionListenerLoader(this.listenerLoader);
        }
        return executionFactory;
    }

    private DefaultFlowExecutionRepository getFlowExecutionRepository(FlowExecutionFactory executionFactory) {
        ConversationManager manager = this.getConversationManager();
        FlowExecutionSnapshotFactory snapshotFactory = this.getSnapshotFactory(executionFactory);
        DefaultFlowExecutionRepository repository = new DefaultFlowExecutionRepository(manager, snapshotFactory);
        if (this.maxFlowExecutionSnapshots != null) {
            repository.setMaxSnapshots(this.maxFlowExecutionSnapshots == 0 ? 1 : this.maxFlowExecutionSnapshots);
        }
        return repository;
    }

    private ConversationManager getConversationManager() {
        ConversationManager manager = this.conversationManager;
        if (manager == null) {
            manager = new SessionBindingConversationManager();
        }
        if (this.maxFlowExecutions != null && manager instanceof SessionBindingConversationManager) {
            ((SessionBindingConversationManager)manager).setMaxConversations(this.maxFlowExecutions);
        }
        return manager;
    }

    private FlowExecutionSnapshotFactory getSnapshotFactory(FlowExecutionFactory executionFactory) {
        FlowExecutionSnapshotFactory factory = null;
        factory = this.maxFlowExecutionSnapshots != null && this.maxFlowExecutionSnapshots == 0 ? new SimpleFlowExecutionSnapshotFactory(executionFactory, this.flowRegistry) : new SerializedFlowExecutionSnapshotFactory(executionFactory, this.flowRegistry);
        return factory;
    }

    private LocalAttributeMap<Object> getExecutionAttributes() {
        LocalAttributeMap<Object> attributes = new LocalAttributeMap<Object>(this.executionAttributes.asMap());
        if (!attributes.contains("alwaysRedirectOnPause")) {
            attributes.put("alwaysRedirectOnPause", true);
        }
        if (!attributes.contains("redirectInSameState")) {
            attributes.put("redirectInSameState", true);
        }
        return attributes;
    }
}

