/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.config;

import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.ProtocolAttributeEncoder;
import org.apereo.cas.authentication.principal.ServiceFactory;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.ticket.proxy.ProxyHandler;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.apereo.cas.validation.AuthenticationAttributeReleasePolicy;
import org.apereo.cas.validation.CasProtocolAttributesRenderer;
import org.apereo.cas.validation.CasProtocolValidationSpecification;
import org.apereo.cas.validation.CasProtocolVersionValidationSpecification;
import org.apereo.cas.validation.CasProtocolViewFactory;
import org.apereo.cas.validation.ChainingCasProtocolValidationSpecification;
import org.apereo.cas.validation.RequestedAuthenticationContextValidator;
import org.apereo.cas.validation.ServiceTicketValidationAuthorizersExecutionPlan;
import org.apereo.cas.web.ServiceValidateConfigurationContext;
import org.apereo.cas.web.ServiceValidationViewFactory;
import org.apereo.cas.web.ServiceValidationViewFactoryConfigurer;
import org.apereo.cas.web.ServiceValidationViewTypes;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.apereo.cas.web.v1.LegacyValidateController;
import org.apereo.cas.web.v2.ProxyController;
import org.apereo.cas.web.v2.ProxyValidateController;
import org.apereo.cas.web.v2.ServiceValidateController;
import org.apereo.cas.web.v3.V3ProxyValidateController;
import org.apereo.cas.web.v3.V3ServiceValidateController;
import org.apereo.cas.web.view.Cas10ResponseView;
import org.apereo.cas.web.view.Cas20ResponseView;
import org.apereo.cas.web.view.Cas30ResponseView;
import org.apereo.cas.web.view.attributes.AttributeValuesPerLineProtocolAttributesRenderer;
import org.apereo.cas.web.view.attributes.DefaultCas30ProtocolAttributesRenderer;
import org.apereo.cas.web.view.attributes.InlinedCas30ProtocolAttributesRenderer;
import org.apereo.cas.web.view.attributes.NoOpProtocolAttributesRenderer;
import org.apereo.cas.web.view.json.Cas30JsonResponseView;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.PropertyResolver;
import org.springframework.web.servlet.View;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature=CasFeatureModule.FeatureCatalog.Validation)
@AutoConfiguration
public class CasValidationConfiguration {
    private static final BeanCondition CONDITION_PROXY_AUTHN = BeanCondition.on((String)"cas.sso.proxy-authn-enabled").isTrue().evenIfMissing();

    @Configuration(value="CasValidationControllerConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasValidationControllerConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"proxyController"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ProxyController proxyController(CasConfigurationProperties casProperties, @Qualifier(value="webApplicationServiceFactory") ServiceFactory<WebApplicationService> webApplicationServiceFactory, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, ConfigurableApplicationContext applicationContext, @Qualifier(value="cas2ProxySuccessView") View cas2ProxySuccessView, @Qualifier(value="cas2ProxyFailureView") View cas2ProxyFailureView) {
            return new ProxyController(cas2ProxySuccessView, cas2ProxyFailureView, centralAuthenticationService, webApplicationServiceFactory, (ApplicationContext)applicationContext, casProperties);
        }

        @Bean
        @ConditionalOnMissingBean(name={"serviceValidateController"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ServiceValidateController serviceValidateController(@Qualifier(value="requestedContextValidator") RequestedAuthenticationContextValidator requestedContextValidator, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="serviceValidationAuthorizers") ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers, @Qualifier(value="proxy20Handler") ProxyHandler proxy20Handler, CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="serviceValidateControllerValidationSpecification") CasProtocolValidationSpecification serviceValidateControllerValidationSpecification, @Qualifier(value="serviceValidationViewFactory") ServiceValidationViewFactory serviceValidationViewFactory) {
            ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().ticketRegistry(ticketRegistry).authenticationSystemSupport(authenticationSystemSupport).servicesManager(servicesManager).centralAuthenticationService(centralAuthenticationService).argumentExtractor(argumentExtractor).requestedContextValidator(requestedContextValidator).validationAuthorizers(serviceValidationAuthorizers).casProperties(casProperties).validationViewFactory(serviceValidationViewFactory).validationSpecifications(CollectionUtils.wrapSet((Object)serviceValidateControllerValidationSpecification)).proxyHandler(proxy20Handler).build();
            return new ServiceValidateController(context);
        }

        @Bean
        @ConditionalOnMissingBean(name={"legacyValidateController"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public LegacyValidateController legacyValidateController(@Qualifier(value="requestedContextValidator") RequestedAuthenticationContextValidator requestedContextValidator, @Qualifier(value="proxy10Handler") ProxyHandler proxy10Handler, @Qualifier(value="serviceValidationAuthorizers") ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, CasConfigurationProperties casProperties, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="legacyValidateControllerValidationSpecification") CasProtocolValidationSpecification legacyValidateControllerValidationSpecification, @Qualifier(value="serviceValidationViewFactory") ServiceValidationViewFactory serviceValidationViewFactory) {
            ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().ticketRegistry(ticketRegistry).authenticationSystemSupport(authenticationSystemSupport).servicesManager(servicesManager).centralAuthenticationService(centralAuthenticationService).argumentExtractor(argumentExtractor).requestedContextValidator(requestedContextValidator).validationAuthorizers(serviceValidationAuthorizers).casProperties(casProperties).validationViewFactory(serviceValidationViewFactory).validationSpecifications(CollectionUtils.wrapSet((Object)legacyValidateControllerValidationSpecification)).proxyHandler(proxy10Handler).build();
            return new LegacyValidateController(context);
        }

        @Bean
        @ConditionalOnMissingBean(name={"proxyValidateController"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public ProxyValidateController proxyValidateController(@Qualifier(value="requestedContextValidator") RequestedAuthenticationContextValidator requestedContextValidator, @Qualifier(value="serviceValidationAuthorizers") ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="proxy20Handler") ProxyHandler proxy20Handler, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="proxyValidateControllerValidationSpecification") CasProtocolValidationSpecification proxyValidateControllerValidationSpecification, @Qualifier(value="serviceValidationViewFactory") ServiceValidationViewFactory serviceValidationViewFactory) {
            ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().ticketRegistry(ticketRegistry).authenticationSystemSupport(authenticationSystemSupport).servicesManager(servicesManager).centralAuthenticationService(centralAuthenticationService).argumentExtractor(argumentExtractor).requestedContextValidator(requestedContextValidator).validationAuthorizers(serviceValidationAuthorizers).casProperties(casProperties).validationViewFactory(serviceValidationViewFactory).validationSpecifications(CollectionUtils.wrapSet((Object)proxyValidateControllerValidationSpecification)).proxyHandler(proxy20Handler).build();
            return new ProxyValidateController(context);
        }

        @Bean
        @ConditionalOnMissingBean(name={"v3ProxyValidateController"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public V3ProxyValidateController v3ProxyValidateController(@Qualifier(value="requestedContextValidator") RequestedAuthenticationContextValidator requestedContextValidator, @Qualifier(value="serviceValidationAuthorizers") ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="proxy20Handler") ProxyHandler proxy20Handler, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="v3ProxyValidateControllerValidationSpecification") CasProtocolValidationSpecification v3ProxyValidateControllerValidationSpecification, @Qualifier(value="serviceValidationViewFactory") ServiceValidationViewFactory serviceValidationViewFactory) {
            ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().ticketRegistry(ticketRegistry).authenticationSystemSupport(authenticationSystemSupport).servicesManager(servicesManager).centralAuthenticationService(centralAuthenticationService).argumentExtractor(argumentExtractor).requestedContextValidator(requestedContextValidator).validationAuthorizers(serviceValidationAuthorizers).casProperties(casProperties).validationViewFactory(serviceValidationViewFactory).validationSpecifications(CollectionUtils.wrapSet((Object)v3ProxyValidateControllerValidationSpecification)).proxyHandler(proxy20Handler).build();
            return new V3ProxyValidateController(context);
        }

        @Bean
        @ConditionalOnMissingBean(name={"v3ServiceValidateController"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public V3ServiceValidateController v3ServiceValidateController(@Qualifier(value="serviceValidationAuthorizers") ServiceTicketValidationAuthorizersExecutionPlan serviceValidationAuthorizers, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="argumentExtractor") ArgumentExtractor argumentExtractor, @Qualifier(value="proxy20Handler") ProxyHandler proxy20Handler, @Qualifier(value="centralAuthenticationService") CentralAuthenticationService centralAuthenticationService, CasConfigurationProperties casProperties, @Qualifier(value="ticketRegistry") TicketRegistry ticketRegistry, @Qualifier(value="defaultAuthenticationSystemSupport") AuthenticationSystemSupport authenticationSystemSupport, @Qualifier(value="requestedContextValidator") RequestedAuthenticationContextValidator requestedContextValidator, @Qualifier(value="v3ServiceValidateControllerValidationSpecification") CasProtocolValidationSpecification v3ServiceValidateControllerValidationSpecification, @Qualifier(value="serviceValidationViewFactory") ServiceValidationViewFactory serviceValidationViewFactory) {
            ServiceValidateConfigurationContext context = ServiceValidateConfigurationContext.builder().ticketRegistry(ticketRegistry).authenticationSystemSupport(authenticationSystemSupport).servicesManager(servicesManager).centralAuthenticationService(centralAuthenticationService).argumentExtractor(argumentExtractor).requestedContextValidator(requestedContextValidator).validationAuthorizers(serviceValidationAuthorizers).casProperties(casProperties).validationViewFactory(serviceValidationViewFactory).validationSpecifications(CollectionUtils.wrapSet((Object)v3ServiceValidateControllerValidationSpecification)).proxyHandler(proxy20Handler).build();
            return new V3ServiceValidateController(context);
        }
    }

    @Configuration(value="CasValidationViewsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasValidationViewsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"cas3ServiceSuccessView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas3ServiceSuccessView(@Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="cas3ProtocolAttributesRenderer") CasProtocolAttributesRenderer cas3ProtocolAttributesRenderer, @Qualifier(value="cas3SuccessView") View cas3SuccessView) {
            return new Cas30ResponseView(true, protocolAttributeEncoder, servicesManager, cas3SuccessView, authenticationAttributeReleasePolicy, authenticationServiceSelectionPlan, cas3ProtocolAttributesRenderer);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas2SuccessView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) {
            return casProtocolViewFactory.create(applicationContext, casProperties.getView().getCas2().getSuccess(), "application/xml");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas2ServiceFailureView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, casProperties.getView().getCas2().getFailure());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas2ProxyFailureView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties) throws Exception {
            return (View)BeanSupplier.of(View.class).when(CONDITION_PROXY_AUTHN.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> casProtocolViewFactory.create(applicationContext, casProperties.getView().getCas2().getProxy().getFailure(), "application/xml")).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas2ProxySuccessView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) throws Exception {
            return (View)BeanSupplier.of(View.class).when(CONDITION_PROXY_AUTHN.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> casProtocolViewFactory.create(applicationContext, casProperties.getView().getCas2().getProxy().getSuccess(), "application/xml")).otherwiseProxy().get();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas3SuccessView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, casProperties.getView().getCas3().getSuccess());
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas3ServiceFailureView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, casProperties.getView().getCas3().getFailure(), "application/xml");
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View casPostResponseView(@Qualifier(value="casProtocolViewFactory") CasProtocolViewFactory casProtocolViewFactory, ConfigurableApplicationContext applicationContext) {
            return casProtocolViewFactory.create(applicationContext, "protocol/casPostResponseView");
        }

        @Bean
        @ConditionalOnMissingBean(name={"cas1ServiceSuccessView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas1ServiceSuccessView(@Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="cas1ProtocolAttributesRenderer") CasProtocolAttributesRenderer cas1ProtocolAttributesRenderer) {
            return new Cas10ResponseView(true, protocolAttributeEncoder, servicesManager, authenticationAttributeReleasePolicy, authenticationServiceSelectionPlan, cas1ProtocolAttributesRenderer);
        }

        @Bean
        @ConditionalOnMissingBean(name={"cas1ServiceFailureView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas1ServiceFailureView(@Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="cas1ProtocolAttributesRenderer") CasProtocolAttributesRenderer cas1ProtocolAttributesRenderer) {
            return new Cas10ResponseView(false, protocolAttributeEncoder, servicesManager, authenticationAttributeReleasePolicy, authenticationServiceSelectionPlan, cas1ProtocolAttributesRenderer);
        }

        @Bean
        @ConditionalOnMissingBean(name={"cas2ServiceSuccessView"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public View cas2ServiceSuccessView(@Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="cas2SuccessView") View cas2SuccessView) {
            return new Cas20ResponseView(true, protocolAttributeEncoder, servicesManager, cas2SuccessView, authenticationAttributeReleasePolicy, authenticationServiceSelectionPlan, NoOpProtocolAttributesRenderer.INSTANCE);
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"cas3ServiceJsonView"})
        public View cas3ServiceJsonView(@Qualifier(value="authenticationAttributeReleasePolicy") AuthenticationAttributeReleasePolicy authenticationAttributeReleasePolicy, @Qualifier(value="casAttributeEncoder") ProtocolAttributeEncoder protocolAttributeEncoder, @Qualifier(value="servicesManager") ServicesManager servicesManager, @Qualifier(value="authenticationServiceSelectionPlan") AuthenticationServiceSelectionPlan authenticationServiceSelectionPlan, @Qualifier(value="cas3ProtocolAttributesRenderer") CasProtocolAttributesRenderer cas3ProtocolAttributesRenderer) {
            return new Cas30JsonResponseView(true, protocolAttributeEncoder, servicesManager, authenticationAttributeReleasePolicy, authenticationServiceSelectionPlan, cas3ProtocolAttributesRenderer);
        }
    }

    @Configuration(value="CasValidationSpecificationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasValidationSpecificationConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"v3ServiceValidateControllerValidationSpecification"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolValidationSpecification v3ServiceValidateControllerValidationSpecification(@Qualifier(value="casSingleAuthenticationProtocolValidationSpecification") CasProtocolValidationSpecification casSingleAuthenticationProtocolValidationSpecification) {
            ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
            validationChain.addSpecification(casSingleAuthenticationProtocolValidationSpecification);
            validationChain.addSpecification((CasProtocolValidationSpecification)new CasProtocolVersionValidationSpecification(Set.of(CasProtocolValidationSpecification.CasProtocolVersions.CAS30)));
            return validationChain;
        }

        @Bean
        @ConditionalOnMissingBean(name={"v3ProxyValidateControllerValidationSpecification"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolValidationSpecification v3ProxyValidateControllerValidationSpecification(ConfigurableApplicationContext applicationContext, @Qualifier(value="casAlwaysSatisfiedProtocolValidationSpecification") CasProtocolValidationSpecification casAlwaysSatisfiedProtocolValidationSpecification) throws Exception {
            return (CasProtocolValidationSpecification)BeanSupplier.of(CasProtocolValidationSpecification.class).when(CONDITION_PROXY_AUTHN.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> {
                ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
                validationChain.addSpecification(casAlwaysSatisfiedProtocolValidationSpecification);
                validationChain.addSpecification((CasProtocolValidationSpecification)new CasProtocolVersionValidationSpecification(Set.of(CasProtocolValidationSpecification.CasProtocolVersions.CAS30)));
                return validationChain;
            }).otherwiseProxy().get();
        }

        @Bean
        @ConditionalOnMissingBean(name={"proxyValidateControllerValidationSpecification"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolValidationSpecification proxyValidateControllerValidationSpecification(@Qualifier(value="casAlwaysSatisfiedProtocolValidationSpecification") CasProtocolValidationSpecification casAlwaysSatisfiedProtocolValidationSpecification) {
            ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
            validationChain.addSpecification(casAlwaysSatisfiedProtocolValidationSpecification);
            validationChain.addSpecification((CasProtocolValidationSpecification)new CasProtocolVersionValidationSpecification(Set.of(CasProtocolValidationSpecification.CasProtocolVersions.CAS20)));
            return validationChain;
        }

        @Bean
        @ConditionalOnMissingBean(name={"legacyValidateControllerValidationSpecification"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolValidationSpecification legacyValidateControllerValidationSpecification(@Qualifier(value="casSingleAuthenticationProtocolValidationSpecification") CasProtocolValidationSpecification casSingleAuthenticationProtocolValidationSpecification) {
            ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
            validationChain.addSpecification(casSingleAuthenticationProtocolValidationSpecification);
            validationChain.addSpecification((CasProtocolValidationSpecification)new CasProtocolVersionValidationSpecification(Set.of(CasProtocolValidationSpecification.CasProtocolVersions.CAS10)));
            return validationChain;
        }

        @Bean
        @ConditionalOnMissingBean(name={"serviceValidateControllerValidationSpecification"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolValidationSpecification serviceValidateControllerValidationSpecification(@Qualifier(value="casSingleAuthenticationProtocolValidationSpecification") CasProtocolValidationSpecification casSingleAuthenticationProtocolValidationSpecification) {
            ChainingCasProtocolValidationSpecification validationChain = new ChainingCasProtocolValidationSpecification();
            validationChain.addSpecification(casSingleAuthenticationProtocolValidationSpecification);
            validationChain.addSpecification((CasProtocolValidationSpecification)new CasProtocolVersionValidationSpecification(Set.of(CasProtocolValidationSpecification.CasProtocolVersions.CAS20)));
            return validationChain;
        }
    }

    @Configuration(value="CasValidationViewFactoryConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasValidationViewFactoryConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"serviceValidationViewFactory"})
        public ServiceValidationViewFactory serviceValidationViewFactory(List<ServiceValidationViewFactoryConfigurer> configurers) {
            ServiceValidationViewFactory viewFactory = new ServiceValidationViewFactory();
            AnnotationAwareOrderComparator.sort(configurers);
            configurers.forEach(cfg -> cfg.configureViewFactory(viewFactory));
            return viewFactory;
        }
    }

    @Configuration(value="CasValidationRendererConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasValidationRendererConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"cas3ProtocolAttributesRenderer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolAttributesRenderer cas3ProtocolAttributesRenderer(CasConfigurationProperties casProperties) {
            switch (casProperties.getView().getCas3().getAttributeRendererType()) {
                case INLINE: {
                    return new InlinedCas30ProtocolAttributesRenderer();
                }
            }
            return new DefaultCas30ProtocolAttributesRenderer();
        }

        @Bean
        @ConditionalOnMissingBean(name={"cas1ProtocolAttributesRenderer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CasProtocolAttributesRenderer cas1ProtocolAttributesRenderer(CasConfigurationProperties casProperties) {
            switch (casProperties.getView().getCas1().getAttributeRendererType()) {
                case VALUES_PER_LINE: {
                    return new AttributeValuesPerLineProtocolAttributesRenderer();
                }
            }
            return NoOpProtocolAttributesRenderer.INSTANCE;
        }
    }

    @Configuration(value="CasValidationViewRegistrationConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasValidationViewRegistrationConfiguration {
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @Bean
        @ConditionalOnMissingBean(name={"casServiceValidationViewFactoryConfigurer"})
        public ServiceValidationViewFactoryConfigurer casServiceValidationViewFactoryConfigurer(CasConfigurationProperties casProperties, @Qualifier(value="cas3ServiceSuccessView") View cas3ServiceSuccessView, @Qualifier(value="cas3ServiceJsonView") View cas3ServiceJsonView, @Qualifier(value="cas3ServiceFailureView") View cas3ServiceFailureView, @Qualifier(value="cas2ServiceSuccessView") View cas2ServiceSuccessView, @Qualifier(value="cas2ServiceFailureView") View cas2ServiceFailureView, @Qualifier(value="cas1ServiceSuccessView") View cas1ServiceSuccessView, @Qualifier(value="cas1ServiceFailureView") View cas1ServiceFailureView) {
            return viewFactory -> {
                viewFactory.registerView(ServiceValidationViewTypes.JSON, cas3ServiceJsonView);
                viewFactory.registerView(V3ServiceValidateController.class, Pair.of((Object)cas3ServiceSuccessView, (Object)cas3ServiceFailureView));
                viewFactory.registerView(V3ProxyValidateController.class, Pair.of((Object)cas3ServiceSuccessView, (Object)cas3ServiceFailureView));
                if (casProperties.getView().getCas2().isV3ForwardCompatible()) {
                    viewFactory.registerView(ProxyValidateController.class, Pair.of((Object)cas3ServiceSuccessView, (Object)cas3ServiceFailureView));
                    viewFactory.registerView(ServiceValidateController.class, Pair.of((Object)cas3ServiceSuccessView, (Object)cas3ServiceFailureView));
                } else {
                    viewFactory.registerView(ProxyValidateController.class, Pair.of((Object)cas2ServiceSuccessView, (Object)cas2ServiceFailureView));
                    viewFactory.registerView(ServiceValidateController.class, Pair.of((Object)cas2ServiceSuccessView, (Object)cas2ServiceFailureView));
                }
                viewFactory.registerView(LegacyValidateController.class, Pair.of((Object)cas1ServiceSuccessView, (Object)cas1ServiceFailureView));
            };
        }
    }
}

