/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.PredictorParams;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasCheckpointInterval;
import org.apache.spark.ml.param.shared.HasSeed;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.regression.DecisionTreeRegressionModel;
import org.apache.spark.ml.regression.RandomForestRegressionModel$;
import org.apache.spark.ml.regression.RegressionModel;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.DecisionTreeParams;
import org.apache.spark.ml.tree.EnsembleModelReadWrite$;
import org.apache.spark.ml.tree.HasVarianceImpurity;
import org.apache.spark.ml.tree.Node;
import org.apache.spark.ml.tree.RandomForestParams;
import org.apache.spark.ml.tree.RandomForestRegressorParams;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$;
import org.apache.spark.ml.tree.TreeEnsembleParams;
import org.apache.spark.ml.tree.TreeEnsembleRegressorParams;
import org.apache.spark.ml.util.DefaultParamsReader;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.configuration.Strategy;
import org.apache.spark.mllib.tree.impurity.Impurity;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JObject;
import org.json4s.JsonDSL$;
import org.json4s.MonadicJValue$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tme\u0001B\u0015+\u0001UB\u0001\"\u0019\u0001\u0003\u0006\u0004%\tE\u0019\u0005\tW\u0002\u0011\t\u0011)A\u0005G\"AA\u000e\u0001BC\u0002\u0013%Q\u000e\u0003\u0005s\u0001\t\u0005\t\u0015!\u0003o\u0011!\u0019\bA!b\u0001\n\u0003\"\b\u0002\u0003=\u0001\u0005\u0003\u0005\u000b\u0011B;\t\re\u0004A\u0011\u0001\u0017{\u0011\u0019I\b\u0001\"\u0001-}\"9\u0011\u0010\u0001C\u0001Y\u0005\u0015\u0001bBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\u0007\u0003\u0003\u0001A\u0011I7\t\u0015\u0005\r\u0002\u0001#b\u0001\n\u0013\t)\u0003C\u0004\u00020\u0001!\t%!\n\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011Q\n\u0001\u0005B\u0005=\u0003bBAI\u0001\u0011\u0005\u00131\u0013\u0005\b\u00033\u0003A\u0011IAN\u0011\u001d\ty\u000b\u0001C!\u0003cC!\"!.\u0001\u0011\u000b\u0007I\u0011AA\\\u0011!\ty\f\u0001C\u0001Y\u0005\u0005\u0007bBAk\u0001\u0011\u0005\u0013q[\u0004\b\u0003OT\u0003\u0012AAu\r\u0019I#\u0006#\u0001\u0002l\"1\u0011p\u0006C\u0001\u0005\u000fAqA!\u0003\u0018\t\u0003\u0012Y\u0001C\u0004\u0003\u0016]!\tEa\u0006\u0007\u000f\t}q\u0003A\f\u0003\"!I!1E\u000e\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\u0007sn!\tA!\n\t\u000f\t52\u0004\"\u0015\u00030\u00191!\u0011H\f\u0005\u0005wAa!_\u0010\u0005\u0002\tu\u0002\"\u0003B!?\t\u0007I\u0011\u0002B\"\u0011!\u0011ye\bQ\u0001\n\t\u0015\u0003\"\u0003B)?\t\u0007I\u0011\u0002B\"\u0011!\u0011\u0019f\bQ\u0001\n\t\u0015\u0003b\u0002B\u000b?\u0011\u0005#Q\u000b\u0005\t\u00053:B\u0011\u0001\u0017\u0003\\!Q!qO\f\u0012\u0002\u0013\u0005AF!\u001f\t\u0013\t5u#!A\u0005\n\t=%a\u0007*b]\u0012|WNR8sKN$(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GN\u0003\u0002,Y\u0005Q!/Z4sKN\u001c\u0018n\u001c8\u000b\u00055r\u0013AA7m\u0015\ty\u0003'A\u0003ta\u0006\u00148N\u0003\u00022e\u00051\u0011\r]1dQ\u0016T\u0011aM\u0001\u0004_J<7\u0001A\n\u0007\u0001Y\nu)T*\u0011\t]B$\bQ\u0007\u0002U%\u0011\u0011H\u000b\u0002\u0010%\u0016<'/Z:tS>tWj\u001c3fYB\u00111HP\u0007\u0002y)\u0011Q\bL\u0001\u0007Y&t\u0017\r\\4\n\u0005}b$A\u0002,fGR|'\u000f\u0005\u00028\u0001A\u0011!)R\u0007\u0002\u0007*\u0011A\tL\u0001\u0005iJ,W-\u0003\u0002G\u0007\nY\"+\u00198e_64uN]3tiJ+wM]3tg>\u0014\b+\u0019:b[N\u00042A\u0011%K\u0013\tI5IA\tUe\u0016,WI\\:f[\ndW-T8eK2\u0004\"aN&\n\u00051S#a\u0007#fG&\u001c\u0018n\u001c8Ue\u0016,'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002O#6\tqJ\u0003\u0002QY\u0005!Q\u000f^5m\u0013\t\u0011vJ\u0001\u0006N\u0019^\u0013\u0018\u000e^1cY\u0016\u0004\"\u0001\u00160\u000f\u0005U[fB\u0001,Z\u001b\u00059&B\u0001-5\u0003\u0019a$o\\8u}%\t!,A\u0003tG\u0006d\u0017-\u0003\u0002];\u00069\u0001/Y2lC\u001e,'\"\u0001.\n\u0005}\u0003'\u0001D*fe&\fG.\u001b>bE2,'B\u0001/^\u0003\r)\u0018\u000eZ\u000b\u0002GB\u0011A\r\u001b\b\u0003K\u001a\u0004\"AV/\n\u0005\u001dl\u0016A\u0002)sK\u0012,g-\u0003\u0002jU\n11\u000b\u001e:j]\u001eT!aZ/\u0002\tULG\rI\u0001\u0007?R\u0014X-Z:\u0016\u00039\u00042a\u001c9K\u001b\u0005i\u0016BA9^\u0005\u0015\t%O]1z\u0003\u001dyFO]3fg\u0002\n1B\\;n\r\u0016\fG/\u001e:fgV\tQ\u000f\u0005\u0002pm&\u0011q/\u0018\u0002\u0004\u0013:$\u0018\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0003Awrl\b\"B1\b\u0001\u0004\u0019\u0007\"\u00027\b\u0001\u0004q\u0007\"B:\b\u0001\u0004)H\u0003\u0002!\u0000\u0003\u0007Aa!!\u0001\t\u0001\u0004q\u0017!\u0002;sK\u0016\u001c\b\"B:\t\u0001\u0004)H#\u0001!\u0002\u001b\u0015\u001cH/[7bi\u0016$7+\u001b>f+\t\tY\u0001E\u0002p\u0003\u001bI1!a\u0004^\u0005\u0011auN\\4)\u000b-\t\u0019\"a\b\u0011\t\u0005U\u00111D\u0007\u0003\u0003/Q1!!\u0007/\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003;\t9BA\u0003TS:\u001cW-\t\u0002\u0002\"\u0005)\u0011G\f\u001b/a\u0005aq\f\u001e:fK^+\u0017n\u001a5ugV\u0011\u0011q\u0005\t\u0005_B\fI\u0003E\u0002p\u0003WI1!!\f^\u0005\u0019!u.\u001e2mK\u0006YAO]3f/\u0016Lw\r\u001b;tQ\u0015i\u00111CA\u0010\u0003=!(/\u00198tM>\u0014XnU2iK6\fG\u0003BA\u001c\u0003\u000f\u0002B!!\u000f\u0002D5\u0011\u00111\b\u0006\u0005\u0003{\ty$A\u0003usB,7OC\u0002\u0002B9\n1a]9m\u0013\u0011\t)%a\u000f\u0003\u0015M#(/^2u)f\u0004X\rC\u0004\u0002J9\u0001\r!a\u000e\u0002\rM\u001c\u0007.Z7bQ\u0015q\u00111CA\u0010\u0003%!(/\u00198tM>\u0014X\u000e\u0006\u0003\u0002R\u00055\u0004\u0003BA*\u0003OrA!!\u0016\u0002f9!\u0011qKA2\u001d\u0011\tI&!\u0019\u000f\t\u0005m\u0013q\f\b\u0004-\u0006u\u0013\"A\u001a\n\u0005E\u0012\u0014BA\u00181\u0013\r\t\tEL\u0005\u00049\u0006}\u0012\u0002BA5\u0003W\u0012\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007q\u000by\u0004C\u0004\u0002p=\u0001\r!!\u001d\u0002\u000f\u0011\fG/Y:fiB\"\u00111OA@!\u0019\t)(a\u001e\u0002|5\u0011\u0011qH\u0005\u0005\u0003s\nyDA\u0004ECR\f7/\u001a;\u0011\t\u0005u\u0014q\u0010\u0007\u0001\t1\t\t)!\u001c\u0002\u0002\u0003\u0005)\u0011AAB\u0005\ryFEM\t\u0005\u0003\u000b\u000bY\tE\u0002p\u0003\u000fK1!!#^\u0005\u001dqu\u000e\u001e5j]\u001e\u00042a\\AG\u0013\r\ty)\u0018\u0002\u0004\u0003:L\u0018a\u00029sK\u0012L7\r\u001e\u000b\u0005\u0003S\t)\n\u0003\u0004\u0002\u0018B\u0001\rAO\u0001\tM\u0016\fG/\u001e:fg\u0006!1m\u001c9z)\r\u0001\u0015Q\u0014\u0005\b\u0003?\u000b\u0002\u0019AAQ\u0003\u0015)\u0007\u0010\u001e:b!\u0011\t\u0019+!+\u000e\u0005\u0005\u0015&bAATY\u0005)\u0001/\u0019:b[&!\u00111VAS\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\b&B\t\u0002\u0014\u0005}\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\rDSAEA\n\u0003?\t!CZ3biV\u0014X-S7q_J$\u0018M\\2fgV\t!\bK\u0003\u0014\u0003'\tY,\t\u0002\u0002>\u0006)\u0011GL\u001b/a\u0005)Ao\\(mIV\u0011\u00111\u0019\t\u0005\u0003\u000b\f\t.\u0004\u0002\u0002H*!\u0011\u0011ZAf\u0003\u0015iw\u000eZ3m\u0015\r!\u0015Q\u001a\u0006\u0004\u0003\u001ft\u0013!B7mY&\u0014\u0017\u0002BAj\u0003\u000f\u0014\u0011CU1oI>lgi\u001c:fgRlu\u000eZ3m\u0003\u00159(/\u001b;f+\t\tI\u000eE\u0002O\u00037L1!!8P\u0005!iEj\u0016:ji\u0016\u0014\b&B\u000b\u0002\u0014\u0005\u0005\u0018EAAr\u0003\u0015\u0011d\u0006\r\u00181Q\u0015\u0001\u00111CA\u0010\u0003m\u0011\u0016M\u001c3p[\u001a{'/Z:u%\u0016<'/Z:tS>tWj\u001c3fYB\u0011qgF\n\b/\u00055\u00181_A}!\ry\u0017q^\u0005\u0004\u0003cl&AB!osJ+g\r\u0005\u0003O\u0003k\u0004\u0015bAA|\u001f\nQQ\n\u0014*fC\u0012\f'\r\\3\u0011\t\u0005m(QA\u0007\u0003\u0003{TA!a@\u0003\u0002\u0005\u0011\u0011n\u001c\u0006\u0003\u0005\u0007\tAA[1wC&\u0019q,!@\u0015\u0005\u0005%\u0018\u0001\u0002:fC\u0012,\"A!\u0004\u0011\t9\u0013y\u0001Q\u0005\u0004\u0005#y%\u0001C'M%\u0016\fG-\u001a:)\u000be\t\u0019\"!9\u0002\t1|\u0017\r\u001a\u000b\u0004\u0001\ne\u0001B\u0002B\u000e5\u0001\u00071-\u0001\u0003qCRD\u0007&\u0002\u000e\u0002\u0014\u0005\u0005(!\t*b]\u0012|WNR8sKN$(+Z4sKN\u001c\u0018n\u001c8N_\u0012,Gn\u0016:ji\u0016\u00148cA\u000e\u0002Z\u0006A\u0011N\\:uC:\u001cW\r\u0006\u0003\u0003(\t-\u0002c\u0001B\u001575\tq\u0003\u0003\u0004\u0003$u\u0001\r\u0001Q\u0001\tg\u00064X-S7qYR!!\u0011\u0007B\u001c!\ry'1G\u0005\u0004\u0005ki&\u0001B+oSRDaAa\u0007\u001f\u0001\u0004\u0019'!\t*b]\u0012|WNR8sKN$(+Z4sKN\u001c\u0018n\u001c8N_\u0012,GNU3bI\u0016\u00148cA\u0010\u0003\u000eQ\u0011!q\b\t\u0004\u0005Sy\u0012!C2mCN\u001ch*Y7f+\t\u0011)\u0005\u0005\u0003\u0003H\t5SB\u0001B%\u0015\u0011\u0011YE!\u0001\u0002\t1\fgnZ\u0005\u0004S\n%\u0013AC2mCN\u001ch*Y7fA\u0005iAO]3f\u00072\f7o\u001d(b[\u0016\fa\u0002\u001e:fK\u000ec\u0017m]:OC6,\u0007\u0005F\u0002A\u0005/BaAa\u0007&\u0001\u0004\u0019\u0017a\u00024s_6|E\u000e\u001a\u000b\n\u0001\nu#\u0011\rB6\u0005kBqAa\u0018'\u0001\u0004\t\u0019-\u0001\u0005pY\u0012lu\u000eZ3m\u0011\u001d\u0011\u0019G\na\u0001\u0005K\na\u0001]1sK:$\bcA\u001c\u0003h%\u0019!\u0011\u000e\u0016\u0003+I\u000bg\u000eZ8n\r>\u0014Xm\u001d;SK\u001e\u0014Xm]:pe\"9!Q\u000e\u0014A\u0002\t=\u0014aE2bi\u0016<wN]5dC24U-\u0019;ve\u0016\u001c\b#\u00023\u0003rU,\u0018b\u0001B:U\n\u0019Q*\u00199\t\u000fM4\u0003\u0013!a\u0001k\u0006\tbM]8n\u001f2$G\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\tm$fA;\u0003~-\u0012!q\u0010\t\u0005\u0005\u0003\u0013I)\u0004\u0002\u0003\u0004*!!Q\u0011BD\u0003%)hn\u00195fG.,GMC\u0002\u0002\u001auKAAa#\u0003\u0004\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u0019]\u0014\u0018\u000e^3SKBd\u0017mY3\u0015\u0005\tE\u0005\u0003\u0002B$\u0005'KAA!&\u0003J\t1qJ\u00196fGRDSaFA\n\u0003CDSAFA\n\u0003C\u0004")
public class RandomForestRegressionModel
extends RegressionModel<Vector, RandomForestRegressionModel>
implements RandomForestRegressorParams,
TreeEnsembleModel<DecisionTreeRegressionModel>,
MLWritable {
    private double[] _treeWeights;
    private Vector featureImportances;
    private final String uid;
    private final DecisionTreeRegressionModel[] _trees;
    private final int numFeatures;
    private int totalNumNodes;
    private Param<String> impurity;
    private IntParam numTrees;
    private BooleanParam bootstrap;
    private DoubleParam subsamplingRate;
    private Param<String> featureSubsetStrategy;
    private Param<String> leafCol;
    private IntParam maxDepth;
    private IntParam maxBins;
    private IntParam minInstancesPerNode;
    private DoubleParam minWeightFractionPerNode;
    private DoubleParam minInfoGain;
    private IntParam maxMemoryInMB;
    private BooleanParam cacheNodeIds;
    private Param<String> weightCol;
    private LongParam seed;
    private IntParam checkpointInterval;
    private volatile byte bitmap$0;

    public static RandomForestRegressionModel load(String path) {
        return RandomForestRegressionModel$.MODULE$.load(path);
    }

    public static MLReader<RandomForestRegressionModel> read() {
        return RandomForestRegressionModel$.MODULE$.read();
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public DecisionTreeModel getTree(int i) {
        return TreeEnsembleModel.getTree$(this, i);
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel.javaTreeWeights$(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel.toDebugString$(this);
    }

    @Override
    public Vector predictLeaf(Vector features) {
        return TreeEnsembleModel.predictLeaf$(this, features);
    }

    @Override
    public StructField getLeafField(String leafCol) {
        return TreeEnsembleModel.getLeafField$(this, leafCol);
    }

    @Override
    public long getEstimatedSize() {
        return TreeEnsembleModel.getEstimatedSize$(this);
    }

    @Override
    public final String getImpurity() {
        return HasVarianceImpurity.getImpurity$(this);
    }

    @Override
    public Impurity getOldImpurity() {
        return HasVarianceImpurity.getOldImpurity$(this);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$tree$TreeEnsembleRegressorParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return PredictorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return TreeEnsembleRegressorParams.validateAndTransformSchema$(this, schema, fitting, featuresDataType);
    }

    @Override
    public final int getNumTrees() {
        return RandomForestParams.getNumTrees$(this);
    }

    @Override
    public final boolean getBootstrap() {
        return RandomForestParams.getBootstrap$(this);
    }

    @Override
    public /* synthetic */ Strategy org$apache$spark$ml$tree$TreeEnsembleParams$$super$getOldStrategy(Map categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final double getSubsamplingRate() {
        return TreeEnsembleParams.getSubsamplingRate$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity) {
        return TreeEnsembleParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity);
    }

    @Override
    public final String getFeatureSubsetStrategy() {
        return TreeEnsembleParams.getFeatureSubsetStrategy$(this);
    }

    @Override
    public final DecisionTreeParams setLeafCol(String value) {
        return DecisionTreeParams.setLeafCol$(this, value);
    }

    @Override
    public final String getLeafCol() {
        return DecisionTreeParams.getLeafCol$(this);
    }

    @Override
    public final int getMaxDepth() {
        return DecisionTreeParams.getMaxDepth$(this);
    }

    @Override
    public final int getMaxBins() {
        return DecisionTreeParams.getMaxBins$(this);
    }

    @Override
    public final int getMinInstancesPerNode() {
        return DecisionTreeParams.getMinInstancesPerNode$(this);
    }

    @Override
    public final double getMinWeightFractionPerNode() {
        return DecisionTreeParams.getMinWeightFractionPerNode$(this);
    }

    @Override
    public final double getMinInfoGain() {
        return DecisionTreeParams.getMinInfoGain$(this);
    }

    @Override
    public final int getMaxMemoryInMB() {
        return DecisionTreeParams.getMaxMemoryInMB$(this);
    }

    @Override
    public final boolean getCacheNodeIds() {
        return DecisionTreeParams.getCacheNodeIds$(this);
    }

    @Override
    public Strategy getOldStrategy(Map<Object, Object> categoricalFeatures, int numClasses, Enumeration.Value oldAlgo, Impurity oldImpurity, double subsamplingRate) {
        return DecisionTreeParams.getOldStrategy$(this, categoricalFeatures, numClasses, oldAlgo, oldImpurity, subsamplingRate);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final long getSeed() {
        return HasSeed.getSeed$(this);
    }

    @Override
    public final int getCheckpointInterval() {
        return HasCheckpointInterval.getCheckpointInterval$(this);
    }

    private int totalNumNodes$lzycompute() {
        RandomForestRegressionModel randomForestRegressionModel = this;
        synchronized (randomForestRegressionModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel.totalNumNodes$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.totalNumNodes;
    }

    @Override
    public int totalNumNodes() {
        if ((byte)(this.bitmap$0 & 4) == 0) {
            return this.totalNumNodes$lzycompute();
        }
        return this.totalNumNodes;
    }

    @Override
    public final Param<String> impurity() {
        return this.impurity;
    }

    @Override
    public final void org$apache$spark$ml$tree$HasVarianceImpurity$_setter_$impurity_$eq(Param<String> x$1) {
        this.impurity = x$1;
    }

    @Override
    public final IntParam numTrees() {
        return this.numTrees;
    }

    @Override
    public final BooleanParam bootstrap() {
        return this.bootstrap;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$numTrees_$eq(IntParam x$1) {
        this.numTrees = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$RandomForestParams$_setter_$bootstrap_$eq(BooleanParam x$1) {
        this.bootstrap = x$1;
    }

    @Override
    public final DoubleParam subsamplingRate() {
        return this.subsamplingRate;
    }

    @Override
    public final Param<String> featureSubsetStrategy() {
        return this.featureSubsetStrategy;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$subsamplingRate_$eq(DoubleParam x$1) {
        this.subsamplingRate = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$TreeEnsembleParams$_setter_$featureSubsetStrategy_$eq(Param<String> x$1) {
        this.featureSubsetStrategy = x$1;
    }

    @Override
    public final Param<String> leafCol() {
        return this.leafCol;
    }

    @Override
    public final IntParam maxDepth() {
        return this.maxDepth;
    }

    @Override
    public final IntParam maxBins() {
        return this.maxBins;
    }

    @Override
    public final IntParam minInstancesPerNode() {
        return this.minInstancesPerNode;
    }

    @Override
    public final DoubleParam minWeightFractionPerNode() {
        return this.minWeightFractionPerNode;
    }

    @Override
    public final DoubleParam minInfoGain() {
        return this.minInfoGain;
    }

    @Override
    public final IntParam maxMemoryInMB() {
        return this.maxMemoryInMB;
    }

    @Override
    public final BooleanParam cacheNodeIds() {
        return this.cacheNodeIds;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$leafCol_$eq(Param<String> x$1) {
        this.leafCol = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxDepth_$eq(IntParam x$1) {
        this.maxDepth = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxBins_$eq(IntParam x$1) {
        this.maxBins = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInstancesPerNode_$eq(IntParam x$1) {
        this.minInstancesPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minWeightFractionPerNode_$eq(DoubleParam x$1) {
        this.minWeightFractionPerNode = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$minInfoGain_$eq(DoubleParam x$1) {
        this.minInfoGain = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$maxMemoryInMB_$eq(IntParam x$1) {
        this.maxMemoryInMB = x$1;
    }

    @Override
    public final void org$apache$spark$ml$tree$DecisionTreeParams$_setter_$cacheNodeIds_$eq(BooleanParam x$1) {
        this.cacheNodeIds = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final LongParam seed() {
        return this.seed;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasSeed$_setter_$seed_$eq(LongParam x$1) {
        this.seed = x$1;
    }

    @Override
    public final IntParam checkpointInterval() {
        return this.checkpointInterval;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasCheckpointInterval$_setter_$checkpointInterval_$eq(IntParam x$1) {
        this.checkpointInterval = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeRegressionModel[] _trees() {
        return this._trees;
    }

    @Override
    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public long estimatedSize() {
        return this.getEstimatedSize();
    }

    public DecisionTreeRegressionModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestRegressionModel randomForestRegressionModel = this;
        synchronized (randomForestRegressionModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this._trees().length, (Function0)(JFunction0.mcD.sp & Serializable)() -> 1.0, (ClassTag)ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this._treeWeights;
    }

    private double[] _treeWeights() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this._treeWeights$lzycompute();
        }
        return this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public StructType transformSchema(StructType schema) {
        StructType outputSchema;
        block0: {
            outputSchema = super.transformSchema(schema);
            if (!StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) break block0;
            outputSchema = SchemaUtils$.MODULE$.updateField(outputSchema, this.getLeafField(this.$(this.leafCol())), SchemaUtils$.MODULE$.updateField$default$3());
        }
        return outputSchema;
    }

    @Override
    public Dataset<Row> transform(Dataset<?> dataset) {
        StructType outputSchema = this.transformSchema(dataset.schema(), true);
        Seq predictionColNames = (Seq)scala.package$.MODULE$.Seq().empty();
        Seq predictionColumns = (Seq)scala.package$.MODULE$.Seq().empty();
        Broadcast bcastModel = dataset.sparkSession().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(RandomForestRegressionModel.class));
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.predictionCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator1$1(RandomForestRegressionModel $outer) {
                }
            }
            UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> BoxesRunTime.boxToDouble((double)RandomForestRegressionModel.$anonfun$transform$1(bcastModel, features)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator1$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.predictionCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)predictUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.predictionCol()), outputSchema.apply(this.$(this.predictionCol())).metadata()));
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.$(this.leafCol())))) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RandomForestRegressionModel.class.getClassLoader());
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RandomForestRegressionModel.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator2$1(RandomForestRegressionModel $outer) {
                }
            }
            public final class Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.ml.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator3$1(RandomForestRegressionModel $outer) {
                }
            }
            UserDefinedFunction leafUDF = functions$.MODULE$.udf((Function1 & Serializable)features -> ((TreeEnsembleModel)bcastModel.value()).predictLeaf((Vector)features), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator2$1(null)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_regression_RandomForestRegressionModel$$typecreator3$1(null)));
            predictionColNames = (Seq)predictionColNames.$colon$plus((Object)this.$(this.leafCol()));
            predictionColumns = (Seq)predictionColumns.$colon$plus((Object)leafUDF.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})).as(this.$(this.leafCol()), outputSchema.apply(this.$(this.leafCol())).metadata()));
        }
        if (predictionColNames.nonEmpty()) {
            return dataset.withColumns(predictionColNames, predictionColumns);
        }
        this.logWarning(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ": RandomForestRegressionModel.transform() "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.UUID, this.uid())})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"does nothing because no output columns were set."}))).log((Seq)Nil$.MODULE$))));
        return dataset.toDF();
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.wrapDoubleArray((double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)RandomForestRegressionModel.$anonfun$predict$1(features, x$3)), (ClassTag)ClassTag$.MODULE$.Double())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$)) / (double)this.getNumTrees();
    }

    @Override
    public RandomForestRegressionModel copy(ParamMap extra) {
        return (RandomForestRegressionModel)((Model)this.copyValues(new RandomForestRegressionModel(this.uid(), this._trees(), this.numFeatures()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return "RandomForestRegressionModel: uid=" + this.uid() + ", numTrees=" + this.getNumTrees() + ", numFeatures=" + this.numFeatures();
    }

    private Vector featureImportances$lzycompute() {
        RandomForestRegressionModel randomForestRegressionModel = this;
        synchronized (randomForestRegressionModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = TreeEnsembleModel$.MODULE$.featureImportances(this.trees(), this.numFeatures(), TreeEnsembleModel$.MODULE$.featureImportances$default$3());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.featureImportances;
    }

    public Vector featureImportances() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.featureImportances$lzycompute();
        }
        return this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Regression(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])this._trees()), (Function1 & Serializable)x$4 -> x$4.toOld(), ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class)));
    }

    @Override
    public MLWriter write() {
        return new RandomForestRegressionModelWriter(this);
    }

    public static final /* synthetic */ double $anonfun$transform$1(Broadcast bcastModel$1, Vector features) {
        return ((RandomForestRegressionModel)bcastModel$1.value()).predict(features);
    }

    public static final /* synthetic */ double $anonfun$predict$1(Vector features$1, DecisionTreeRegressionModel x$3) {
        return x$3.rootNode().predictImpl(features$1).prediction();
    }

    public RandomForestRegressionModel(String uid, DecisionTreeRegressionModel[] _trees, int numFeatures) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        HasCheckpointInterval.$init$(this);
        HasSeed.$init$(this);
        HasWeightCol.$init$(this);
        DecisionTreeParams.$init$(this);
        TreeEnsembleParams.$init$(this);
        RandomForestParams.$init$(this);
        TreeEnsembleRegressorParams.$init$(this);
        HasVarianceImpurity.$init$(this);
        TreeEnsembleModel.$init$(this);
        MLWritable.$init$(this);
        Predef$.MODULE$.require(ArrayOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])_trees)), (Function0 & Serializable)() -> "RandomForestRegressionModel requires at least 1 tree.");
        Statics.releaseFence();
    }

    public RandomForestRegressionModel(DecisionTreeRegressionModel[] trees, int numFeatures) {
        this(Identifiable$.MODULE$.randomUID("rfr"), trees, numFeatures);
    }

    public RandomForestRegressionModel() {
        this("", (DecisionTreeRegressionModel[])((Object[])new DecisionTreeRegressionModel[]{new DecisionTreeRegressionModel()}), -1);
    }

    private static class RandomForestRegressionModelReader
    extends MLReader<RandomForestRegressionModel> {
        private final String className = RandomForestRegressionModel.class.getName();
        private final String treeClassName = DecisionTreeRegressionModel.class.getName();

        private String className() {
            return this.className;
        }

        private String treeClassName() {
            return this.treeClassName;
        }

        @Override
        public RandomForestRegressionModel load(String path) {
            Tuple2[] tuple2Array;
            DefaultParamsReader.Metadata metadata;
            double[] treeWeights;
            DefaultFormats$ format;
            block3: {
                Tuple3<DefaultParamsReader.Metadata, Tuple2<DefaultParamsReader.Metadata, Node>[], double[]> tuple3;
                block2: {
                    format = DefaultFormats$.MODULE$;
                    tuple3 = EnsembleModelReadWrite$.MODULE$.loadImpl(path, this.sparkSession(), this.className(), this.treeClassName());
                    if (tuple3 == null) break block2;
                    DefaultParamsReader.Metadata metadata2 = (DefaultParamsReader.Metadata)tuple3._1();
                    Tuple2[] treesData = (Tuple2[])tuple3._2();
                    treeWeights = (double[])tuple3._3();
                    if (metadata2 == null) break block2;
                    metadata = metadata2;
                    if (treesData == null) break block2;
                    tuple2Array = treesData;
                    if (treeWeights != null) break block3;
                }
                throw new MatchError(tuple3);
            }
            double[] dArray = treeWeights;
            Tuple3 tuple3 = new Tuple3((Object)metadata, (Object)tuple2Array, (Object)dArray);
            DefaultParamsReader.Metadata metadata3 = (DefaultParamsReader.Metadata)tuple3._1();
            Tuple2[] treesData = (Tuple2[])tuple3._2();
            double[] treeWeights2 = (double[])tuple3._3();
            int numFeatures = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numFeatures")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            int numTrees = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata3.metadata()), "numTrees")), (Formats)format, (Manifest)ManifestFactory$.MODULE$.Int()));
            DecisionTreeRegressionModel[] trees = (DecisionTreeRegressionModel[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])treesData), (Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DefaultParamsReader.Metadata treeMetadata = (DefaultParamsReader.Metadata)tuple2._1();
                    Node root = (Node)tuple2._2();
                    DecisionTreeRegressionModel tree = new DecisionTreeRegressionModel(treeMetadata.uid(), root, numFeatures);
                    treeMetadata.getAndSetParams(tree, treeMetadata.getAndSetParams$default$2());
                    return tree;
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(DecisionTreeRegressionModel.class));
            Predef$.MODULE$.require(numTrees == trees.length, (Function0 & Serializable)() -> "RandomForestRegressionModel.load expected " + numTrees + " trees based on metadata but found " + trees.length + " trees.");
            RandomForestRegressionModel model = new RandomForestRegressionModel(metadata3.uid(), trees, numFeatures);
            metadata3.getAndSetParams(model, metadata3.getAndSetParams$default$2());
            return model;
        }
    }

    public static class RandomForestRegressionModelWriter
    extends MLWriter {
        private final RandomForestRegressionModel instance;

        @Override
        public void saveImpl(String path) {
            JObject extraMetadata = JsonDSL$.MODULE$.map2jvalue((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numFeatures"), (Object)BoxesRunTime.boxToInteger((int)this.instance.numFeatures())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numTrees"), (Object)BoxesRunTime.boxToInteger((int)this.instance.getNumTrees()))})), (Function1 & Serializable)x -> JsonDSL$.MODULE$.int2jvalue(BoxesRunTime.unboxToInt((Object)x)));
            EnsembleModelReadWrite$.MODULE$.saveImpl(this.instance, path, this.sparkSession(), extraMetadata);
        }

        public RandomForestRegressionModelWriter(RandomForestRegressionModel instance) {
            this.instance = instance;
        }
    }
}

