/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog.constraints;

import java.util.Arrays;
import java.util.Objects;
import org.apache.spark.annotation.Evolving;
import org.apache.spark.sql.connector.catalog.constraints.BaseConstraint;
import org.apache.spark.sql.connector.catalog.constraints.Constraint;
import org.apache.spark.sql.connector.expressions.NamedReference;

@Evolving
public class Unique
extends BaseConstraint {
    private final NamedReference[] columns;

    private Unique(String name, NamedReference[] columns, boolean enforced, Constraint.ValidationStatus validationStatus, boolean rely) {
        super(name, enforced, validationStatus, rely);
        this.columns = columns;
    }

    public NamedReference[] columns() {
        return this.columns;
    }

    @Override
    protected String definition() {
        return String.format("UNIQUE (%s)", this.toDDL(this.columns));
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        Unique that = (Unique)other;
        return Objects.equals(this.name(), that.name()) && Arrays.equals(this.columns, that.columns()) && this.enforced() == that.enforced() && Objects.equals((Object)this.validationStatus(), (Object)that.validationStatus()) && this.rely() == that.rely();
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.name(), this.enforced(), this.validationStatus(), this.rely()});
        result = 31 * result + Arrays.hashCode(this.columns);
        return result;
    }

    public static class Builder
    extends BaseConstraint.Builder<Builder, Unique> {
        private final NamedReference[] columns;

        Builder(String name, NamedReference[] columns) {
            super(name);
            this.columns = columns;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public Unique build() {
            return new Unique(this.name(), this.columns, this.enforced(), this.validationStatus(), this.rely());
        }
    }
}

