/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl.filter.leaf;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.orc.impl.filter.LeafFilter;
import org.apache.orc.util.CuckooSetBytes;

class StringFilters {
    private StringFilters() {
    }

    static class StringLessThanEquals
    extends LeafFilter {
        private final byte[] aValue;

        StringLessThanEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = ((String)aValue).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            BytesColumnVector bv = (BytesColumnVector)v;
            return StringExpr.compare((byte[])bv.vector[rowIdx], (int)bv.start[rowIdx], (int)bv.length[rowIdx], (byte[])this.aValue, (int)0, (int)this.aValue.length) <= 0;
        }
    }

    static class StringLessThan
    extends LeafFilter {
        private final byte[] aValue;

        StringLessThan(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = ((String)aValue).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            BytesColumnVector bv = (BytesColumnVector)v;
            return StringExpr.compare((byte[])bv.vector[rowIdx], (int)bv.start[rowIdx], (int)bv.length[rowIdx], (byte[])this.aValue, (int)0, (int)this.aValue.length) < 0;
        }
    }

    static class StringIn
    extends LeafFilter {
        private final CuckooSetBytes inSet;

        StringIn(String colName, List<Object> values, boolean negated) {
            super(colName, negated);
            byte[][] inValues = new byte[values.size()][];
            for (int i = 0; i < values.size(); ++i) {
                inValues[i] = ((String)values.get(i)).getBytes(StandardCharsets.UTF_8);
            }
            this.inSet = new CuckooSetBytes(inValues.length);
            this.inSet.load(inValues);
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            BytesColumnVector bv = (BytesColumnVector)v;
            return this.inSet.lookup(bv.vector[rowIdx], bv.start[rowIdx], bv.length[rowIdx]);
        }
    }

    static class StringEquals
    extends LeafFilter {
        private final byte[] aValue;

        StringEquals(String colName, Object aValue, boolean negated) {
            super(colName, negated);
            this.aValue = ((String)aValue).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            BytesColumnVector bv = (BytesColumnVector)v;
            return StringExpr.equal((byte[])this.aValue, (int)0, (int)this.aValue.length, (byte[])bv.vector[rowIdx], (int)bv.start[rowIdx], (int)bv.length[rowIdx]);
        }
    }

    static class StringBetween
    extends LeafFilter {
        private final byte[] low;
        private final byte[] high;

        StringBetween(String colName, Object low, Object high, boolean negated) {
            super(colName, negated);
            this.low = ((String)low).getBytes(StandardCharsets.UTF_8);
            this.high = ((String)high).getBytes(StandardCharsets.UTF_8);
        }

        @Override
        protected boolean allow(ColumnVector v, int rowIdx) {
            BytesColumnVector bv = (BytesColumnVector)v;
            return StringExpr.compare((byte[])bv.vector[rowIdx], (int)bv.start[rowIdx], (int)bv.length[rowIdx], (byte[])this.low, (int)0, (int)this.low.length) >= 0 && StringExpr.compare((byte[])bv.vector[rowIdx], (int)bv.start[rowIdx], (int)bv.length[rowIdx], (byte[])this.high, (int)0, (int)this.high.length) <= 0;
        }
    }
}

