/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.PlanExpression;
import org.apache.spark.sql.catalyst.plans.QueryPlan;
import org.apache.spark.sql.catalyst.plans.QueryPlan$;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.BaseSubqueryExec;
import org.apache.spark.sql.execution.InputAdapter;
import org.apache.spark.sql.execution.ReusedSubqueryExec;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.WholeStageCodegenExec;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanExec;
import org.apache.spark.sql.execution.adaptive.AdaptiveSparkPlanHelper;
import org.apache.spark.sql.execution.adaptive.QueryStageExec;
import org.apache.spark.sql.execution.exchange.Exchange;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.BitSet;
import scala.collection.mutable.BitSet$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LambdaDeserialize;

public final class ExplainUtils$
implements AdaptiveSparkPlanHelper {
    public static final ExplainUtils$ MODULE$ = new ExplainUtils$();

    static {
        AdaptiveSparkPlanHelper.$init$(MODULE$);
    }

    @Override
    public Option<SparkPlan> find(SparkPlan p, Function1<SparkPlan, Object> f) {
        return AdaptiveSparkPlanHelper.find$(this, p, f);
    }

    @Override
    public void foreach(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreach$(this, p, f);
    }

    @Override
    public void foreachUp(SparkPlan p, Function1<SparkPlan, BoxedUnit> f) {
        AdaptiveSparkPlanHelper.foreachUp$(this, p, f);
    }

    @Override
    public <A> Seq<A> mapPlans(SparkPlan p, Function1<SparkPlan, A> f) {
        return AdaptiveSparkPlanHelper.mapPlans$(this, p, f);
    }

    @Override
    public <A> Seq<A> flatMap(SparkPlan p, Function1<SparkPlan, IterableOnce<A>> f) {
        return AdaptiveSparkPlanHelper.flatMap$(this, p, f);
    }

    @Override
    public <B> Seq<B> collect(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collect$(this, p, pf);
    }

    @Override
    public Seq<SparkPlan> collectLeaves(SparkPlan p) {
        return AdaptiveSparkPlanHelper.collectLeaves$(this, p);
    }

    @Override
    public <B> Option<B> collectFirst(SparkPlan p, PartialFunction<SparkPlan, B> pf) {
        return AdaptiveSparkPlanHelper.collectFirst$(this, p, pf);
    }

    @Override
    public <B> Seq<B> collectWithSubqueries(SparkPlan p, PartialFunction<SparkPlan, B> f) {
        return AdaptiveSparkPlanHelper.collectWithSubqueries$(this, p, f);
    }

    @Override
    public Seq<SparkPlan> subqueriesAll(SparkPlan p) {
        return AdaptiveSparkPlanHelper.subqueriesAll$(this, p);
    }

    @Override
    public Seq<SparkPlan> allChildren(SparkPlan p) {
        return AdaptiveSparkPlanHelper.allChildren$(this, p);
    }

    @Override
    public SparkPlan stripAQEPlan(SparkPlan p) {
        return AdaptiveSparkPlanHelper.stripAQEPlan$(this, p);
    }

    public ThreadLocal<Map<QueryPlan<?>, Object>> localIdMap() {
        return QueryPlan$.MODULE$.localIdMap();
    }

    private <T extends QueryPlan<T>> void processPlanSkippingSubqueries(T plan, Function1<String, BoxedUnit> append, BitSet collectedOperators) {
        try {
            this.generateWholeStageCodegenIds(plan);
            Function0 & Serializable x$1 = (Function0 & Serializable)() -> plan;
            Function1<String, BoxedUnit> x$2 = append;
            boolean x$3 = false;
            boolean x$4 = false;
            boolean x$5 = true;
            int x$6 = QueryPlan$.MODULE$.append$default$5();
            boolean x$7 = QueryPlan$.MODULE$.append$default$7();
            QueryPlan$.MODULE$.append((Function0)x$1, x$2, false, false, x$6, true, x$7);
            append.apply((Object)"\n");
            ArrayBuffer operationsWithID = ArrayBuffer$.MODULE$.empty();
            this.collectOperatorsWithID(plan, operationsWithID, collectedOperators);
            operationsWithID.foreach((Function1 & Serializable)p -> {
                append.apply((Object)p.verboseStringWithOperatorId());
                return BoxedUnit.UNIT;
            });
        }
        catch (AnalysisException e) {
            append.apply((Object)e.toString());
        }
    }

    public <T extends QueryPlan<T>> void processPlan(T plan2, Function1<String, BoxedUnit> append) {
        Map<QueryPlan<?>, Object> prevIdMap = this.localIdMap().get();
        try {
            IdentityHashMap idMap = new IdentityHashMap();
            this.localIdMap().set(idMap);
            ArrayBuffer reusedExchanges = ArrayBuffer$.MODULE$.empty();
            IntRef currentOperatorID = IntRef.create((int)0);
            currentOperatorID.elem = this.generateOperatorIDs(plan2, currentOperatorID.elem, idMap, (ArrayBuffer<ReusedExchangeExec>)reusedExchanges, true);
            ArrayBuffer subqueries = ArrayBuffer$.MODULE$.empty();
            this.org$apache$spark$sql$execution$ExplainUtils$$getSubqueries((Function0 & Serializable)() -> plan2, (ArrayBuffer<Tuple3<SparkPlan, Expression, BaseSubqueryExec>>)subqueries);
            currentOperatorID.elem = BoxesRunTime.unboxToInt((Object)subqueries.foldLeft((Object)BoxesRunTime.boxToInteger((int)currentOperatorID.elem), (Function2 & Serializable)(curId, plan) -> BoxesRunTime.boxToInteger((int)ExplainUtils$.MODULE$.generateOperatorIDs(((BaseSubqueryExec)plan._3()).child(), BoxesRunTime.unboxToInt((Object)curId), idMap, (ArrayBuffer<ReusedExchangeExec>)reusedExchanges, true))));
            ArrayBuffer optimizedOutExchanges = ArrayBuffer$.MODULE$.empty();
            reusedExchanges.foreach((Function1 & Serializable)reused -> {
                ExplainUtils$.$anonfun$processPlan$3(idMap, optimizedOutExchanges, currentOperatorID, reusedExchanges, reused);
                return BoxedUnit.UNIT;
            });
            BitSet collectedOperators = BitSet$.MODULE$.empty();
            this.processPlanSkippingSubqueries(plan2, append, collectedOperators);
            IntRef i = IntRef.create((int)0);
            subqueries.foreach((Function1 & Serializable)sub -> {
                ExplainUtils$.$anonfun$processPlan$4(i, append, collectedOperators, sub);
                return BoxedUnit.UNIT;
            });
            i.elem = 0;
            optimizedOutExchanges.foreach((Function1 & Serializable)exchange -> {
                ExplainUtils$.$anonfun$processPlan$5(i, append, collectedOperators, exchange);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            this.localIdMap().set(prevIdMap);
        }
    }

    private int generateOperatorIDs(QueryPlan<?> plan, int startOperatorID, Map<QueryPlan<?>, Object> idMap, ArrayBuffer<ReusedExchangeExec> reusedExchanges, boolean addReusedExchanges) {
        IntRef currentOperationID = IntRef.create((int)startOperatorID);
        if (plan instanceof BaseSubqueryExec) {
            return currentOperationID.elem;
        }
        plan.foreachUp((Function1 & Serializable)x0$1 -> {
            ExplainUtils$.$anonfun$generateOperatorIDs$2(currentOperationID, idMap, reusedExchanges, addReusedExchanges, x0$1);
            return BoxedUnit.UNIT;
        });
        return currentOperationID.elem;
    }

    private void collectOperatorsWithID(QueryPlan<?> plan, ArrayBuffer<QueryPlan<?>> operators, BitSet collectedOperators) {
        if (plan instanceof BaseSubqueryExec) {
            return;
        }
        plan.foreachUp((Function1 & Serializable)x0$1 -> {
            ExplainUtils$.$anonfun$collectOperatorsWithID$2(operators, collectedOperators, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    private void generateWholeStageCodegenIds(QueryPlan<?> plan) {
        IntRef currentCodegenId = IntRef.create((int)-1);
        if (plan instanceof BaseSubqueryExec) {
            return;
        }
        plan.foreach((Function1 & Serializable)x0$1 -> {
            ExplainUtils$.$anonfun$generateWholeStageCodegenIds$2(currentCodegenId, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public String generateFieldString(String fieldName, Object values) {
        return QueryPlan$.MODULE$.generateFieldString(fieldName, values);
    }

    public void org$apache$spark$sql$execution$ExplainUtils$$getSubqueries(Function0<QueryPlan<?>> plan, ArrayBuffer<Tuple3<SparkPlan, Expression, BaseSubqueryExec>> subqueries) {
        ((TreeNode)plan.apply()).foreach((Function1 & Serializable)x0$1 -> {
            ExplainUtils$.$anonfun$getSubqueries$1(subqueries, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public String getOpId(QueryPlan<?> plan) {
        return (String)Option$.MODULE$.apply(this.localIdMap().get().get(plan)).map((Function1 & Serializable)v -> ExplainUtils$.$anonfun$getOpId$1(BoxesRunTime.unboxToInt((Object)v))).getOrElse((Function0 & Serializable)() -> "unknown");
    }

    public static final /* synthetic */ void $anonfun$processPlan$3(IdentityHashMap idMap$1, ArrayBuffer optimizedOutExchanges$1, IntRef currentOperatorID$1, ArrayBuffer reusedExchanges$1, ReusedExchangeExec reused) {
        Exchange child = reused.child();
        if (!idMap$1.containsKey(child)) {
            optimizedOutExchanges$1.append((Object)child);
            currentOperatorID$1.elem = MODULE$.generateOperatorIDs(child, currentOperatorID$1.elem, idMap$1, (ArrayBuffer<ReusedExchangeExec>)reusedExchanges$1, false);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$processPlan$4(IntRef i$1, Function1 append$2, BitSet collectedOperators$1, Tuple3 sub) {
        Object object = i$1.elem == 0 ? append$2.apply((Object)"\n===== Subqueries =====\n\n") : BoxedUnit.UNIT;
        ++i$1.elem;
        append$2.apply((Object)("Subquery:" + i$1.elem + " Hosting operator id = " + MODULE$.getOpId((QueryPlan)sub._1()) + " Hosting Expression = " + sub._2() + "\n"));
        if (!(sub._3() instanceof ReusedSubqueryExec)) {
            MODULE$.processPlanSkippingSubqueries(((BaseSubqueryExec)sub._3()).child(), (Function1<String, BoxedUnit>)append$2, collectedOperators$1);
        }
        append$2.apply((Object)"\n");
    }

    public static final /* synthetic */ void $anonfun$processPlan$5(IntRef i$1, Function1 append$2, BitSet collectedOperators$1, Exchange exchange) {
        Object object = i$1.elem == 0 ? append$2.apply((Object)"\n===== Adaptively Optimized Out Exchanges =====\n\n") : BoxedUnit.UNIT;
        ++i$1.elem;
        append$2.apply((Object)("Subplan:" + i$1.elem + "\n"));
        MODULE$.processPlanSkippingSubqueries(exchange, (Function1<String, BoxedUnit>)append$2, collectedOperators$1);
        append$2.apply((Object)"\n");
    }

    public static final /* synthetic */ int $anonfun$generateOperatorIDs$1(boolean addReusedExchanges$1, ArrayBuffer reusedExchanges$2, IntRef currentOperationID$1, QueryPlan plan) {
        QueryPlan queryPlan = plan;
        if (queryPlan instanceof ReusedExchangeExec) {
            ReusedExchangeExec reusedExchangeExec = (ReusedExchangeExec)queryPlan;
            if (addReusedExchanges$1) {
                reusedExchanges$2.append((Object)reusedExchangeExec);
            }
        }
        ++currentOperationID$1.elem;
        return currentOperationID$1.elem;
    }

    private static final void setOpId$1(QueryPlan plan2, Map idMap$2, boolean addReusedExchanges$1, ArrayBuffer reusedExchanges$2, IntRef currentOperationID$1) {
        idMap$2.computeIfAbsent(plan2, plan -> BoxesRunTime.boxToInteger((int)ExplainUtils$.$anonfun$generateOperatorIDs$1(addReusedExchanges$1, reusedExchanges$2, currentOperationID$1, plan)));
    }

    public static final /* synthetic */ void $anonfun$generateOperatorIDs$2(IntRef currentOperationID$1, Map idMap$2, ArrayBuffer reusedExchanges$2, boolean addReusedExchanges$1, Object x0$1) {
        Object object = x0$1;
        if (object instanceof WholeStageCodegenExec) {
            return;
        }
        if (object instanceof InputAdapter) {
            return;
        }
        if (object instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)object;
            currentOperationID$1.elem = MODULE$.generateOperatorIDs(adaptiveSparkPlanExec.executedPlan(), currentOperationID$1.elem, idMap$2, (ArrayBuffer<ReusedExchangeExec>)reusedExchanges$2, addReusedExchanges$1);
            if (!adaptiveSparkPlanExec.executedPlan().fastEquals((TreeNode)adaptiveSparkPlanExec.initialPlan())) {
                currentOperationID$1.elem = MODULE$.generateOperatorIDs(adaptiveSparkPlanExec.initialPlan(), currentOperationID$1.elem, idMap$2, (ArrayBuffer<ReusedExchangeExec>)reusedExchanges$2, addReusedExchanges$1);
            }
            ExplainUtils$.setOpId$1(adaptiveSparkPlanExec, idMap$2, addReusedExchanges$1, reusedExchanges$2, currentOperationID$1);
            return;
        }
        if (object instanceof QueryStageExec) {
            QueryStageExec queryStageExec = (QueryStageExec)object;
            currentOperationID$1.elem = MODULE$.generateOperatorIDs(queryStageExec.plan(), currentOperationID$1.elem, idMap$2, (ArrayBuffer<ReusedExchangeExec>)reusedExchanges$2, addReusedExchanges$1);
            ExplainUtils$.setOpId$1(queryStageExec, idMap$2, addReusedExchanges$1, reusedExchanges$2, currentOperationID$1);
            return;
        }
        if (object instanceof QueryPlan) {
            QueryPlan queryPlan = (QueryPlan)object;
            ExplainUtils$.setOpId$1(queryPlan, idMap$2, addReusedExchanges$1, reusedExchanges$2, currentOperationID$1);
            currentOperationID$1.elem = BoxesRunTime.unboxToInt((Object)queryPlan.innerChildren().foldLeft((Object)BoxesRunTime.boxToInteger((int)currentOperationID$1.elem), (Function2 & Serializable)(curId, plan) -> BoxesRunTime.boxToInteger((int)ExplainUtils$.MODULE$.generateOperatorIDs(plan, BoxesRunTime.unboxToInt((Object)curId), idMap$2, (ArrayBuffer<ReusedExchangeExec>)reusedExchanges$2, addReusedExchanges$1))));
            return;
        }
        throw new MatchError(object);
    }

    public static final /* synthetic */ Object $anonfun$collectOperatorsWithID$1(BitSet collectedOperators$2, ArrayBuffer operators$1, QueryPlan plan$3, int id) {
        if (collectedOperators$2.add((Object)BoxesRunTime.boxToInteger((int)id))) {
            return operators$1.$plus$eq((Object)plan$3);
        }
        return BoxedUnit.UNIT;
    }

    private static final void collectOperatorWithID$1(QueryPlan plan, BitSet collectedOperators$2, ArrayBuffer operators$1) {
        Option$.MODULE$.apply(MODULE$.localIdMap().get().get(plan)).foreach((Function1 & Serializable)id -> ExplainUtils$.$anonfun$collectOperatorsWithID$1(collectedOperators$2, operators$1, plan, BoxesRunTime.unboxToInt((Object)id)));
    }

    public static final /* synthetic */ void $anonfun$collectOperatorsWithID$2(ArrayBuffer operators$1, BitSet collectedOperators$2, Object x0$1) {
        Object object = x0$1;
        if (object instanceof WholeStageCodegenExec) {
            return;
        }
        if (object instanceof InputAdapter) {
            return;
        }
        if (object instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)object;
            MODULE$.collectOperatorsWithID(adaptiveSparkPlanExec.executedPlan(), operators$1, collectedOperators$2);
            if (!adaptiveSparkPlanExec.executedPlan().fastEquals((TreeNode)adaptiveSparkPlanExec.initialPlan())) {
                MODULE$.collectOperatorsWithID(adaptiveSparkPlanExec.initialPlan(), operators$1, collectedOperators$2);
            }
            ExplainUtils$.collectOperatorWithID$1(adaptiveSparkPlanExec, collectedOperators$2, operators$1);
            return;
        }
        if (object instanceof QueryStageExec) {
            QueryStageExec queryStageExec = (QueryStageExec)object;
            MODULE$.collectOperatorsWithID(queryStageExec.plan(), operators$1, collectedOperators$2);
            ExplainUtils$.collectOperatorWithID$1(queryStageExec, collectedOperators$2, operators$1);
            return;
        }
        if (object instanceof QueryPlan) {
            QueryPlan queryPlan = (QueryPlan)object;
            ExplainUtils$.collectOperatorWithID$1(queryPlan, collectedOperators$2, operators$1);
            queryPlan.innerChildren().foreach((Function1 & Serializable)x$1 -> {
                ExplainUtils$.MODULE$.collectOperatorsWithID(x$1, operators$1, collectedOperators$2);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(object);
    }

    private static final void setCodegenId$1(QueryPlan p, Seq children, IntRef currentCodegenId$1) {
        if (currentCodegenId$1.elem != -1) {
            p.setTagValue(QueryPlan$.MODULE$.CODEGEN_ID_TAG(), (Object)BoxesRunTime.boxToInteger((int)currentCodegenId$1.elem));
        }
        children.foreach((Function1 & Serializable)plan -> {
            ExplainUtils$.MODULE$.generateWholeStageCodegenIds(plan);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$generateWholeStageCodegenIds$2(IntRef currentCodegenId$1, Object x0$1) {
        Object object = x0$1;
        if (object instanceof WholeStageCodegenExec) {
            WholeStageCodegenExec wholeStageCodegenExec = (WholeStageCodegenExec)object;
            currentCodegenId$1.elem = wholeStageCodegenExec.codegenStageId();
            return;
        }
        if (object instanceof InputAdapter) {
            currentCodegenId$1.elem = -1;
            return;
        }
        if (object instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)object;
            ExplainUtils$.setCodegenId$1(adaptiveSparkPlanExec, (Seq)new .colon.colon((Object)adaptiveSparkPlanExec.executedPlan(), (List)Nil$.MODULE$), currentCodegenId$1);
            return;
        }
        if (object instanceof QueryStageExec) {
            QueryStageExec queryStageExec = (QueryStageExec)object;
            ExplainUtils$.setCodegenId$1(queryStageExec, (Seq)new .colon.colon((Object)queryStageExec.plan(), (List)Nil$.MODULE$), currentCodegenId$1);
            return;
        }
        if (object instanceof QueryPlan) {
            QueryPlan queryPlan = (QueryPlan)object;
            ExplainUtils$.setCodegenId$1(queryPlan, queryPlan.innerChildren(), currentCodegenId$1);
            return;
        }
        throw new MatchError(object);
    }

    public static final /* synthetic */ void $anonfun$getSubqueries$1(ArrayBuffer subqueries$1, Object x0$1) {
        Object object = x0$1;
        if (object instanceof AdaptiveSparkPlanExec) {
            AdaptiveSparkPlanExec adaptiveSparkPlanExec = (AdaptiveSparkPlanExec)object;
            MODULE$.org$apache$spark$sql$execution$ExplainUtils$$getSubqueries((Function0 & Serializable)() -> adaptiveSparkPlanExec.executedPlan(), (ArrayBuffer<Tuple3<SparkPlan, Expression, BaseSubqueryExec>>)subqueries$1);
            return;
        }
        if (object instanceof QueryStageExec) {
            QueryStageExec queryStageExec = (QueryStageExec)object;
            MODULE$.org$apache$spark$sql$execution$ExplainUtils$$getSubqueries((Function0 & Serializable)() -> queryStageExec.plan(), (ArrayBuffer<Tuple3<SparkPlan, Expression, BaseSubqueryExec>>)subqueries$1);
            return;
        }
        if (object instanceof SparkPlan) {
            SparkPlan sparkPlan = (SparkPlan)object;
            sparkPlan.expressions().foreach((Function1 & Serializable)x$2 -> x$2.collect((PartialFunction)new Serializable(subqueries$1, sparkPlan){
                private static final long serialVersionUID = 0L;
                private final ArrayBuffer subqueries$1;
                private final SparkPlan x4$1;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof PlanExpression) {
                        PlanExpression planExpression = (PlanExpression)A1;
                        QueryPlan queryPlan = planExpression.plan();
                        if (queryPlan instanceof BaseSubqueryExec) {
                            BaseSubqueryExec baseSubqueryExec = (BaseSubqueryExec)queryPlan;
                            this.subqueries$1.$plus$eq((Object)new Tuple3((Object)this.x4$1, (Object)planExpression, (Object)baseSubqueryExec));
                            ExplainUtils$.MODULE$.org$apache$spark$sql$execution$ExplainUtils$$getSubqueries((Function0 & Serializable)() -> baseSubqueryExec, (ArrayBuffer<Tuple3<SparkPlan, Expression, BaseSubqueryExec>>)this.subqueries$1);
                        }
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof PlanExpression;
                }
                {
                    this.subqueries$1 = subqueries$1;
                    this.x4$1 = x4$1;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.execution.BaseSubqueryExec )}, serializedLambda);
                }
            }));
            return;
        }
        throw new MatchError(object);
    }

    public static final /* synthetic */ String $anonfun$getOpId$1(int v) {
        return String.valueOf(BoxesRunTime.boxToInteger((int)v));
    }

    private ExplainUtils$() {
    }
}

