/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.pre;

import ch.ethz.globis.phtree.pre.PreProcessorPointF;
import ch.ethz.globis.phtree.util.BitTools;
import java.util.Arrays;

public class ExponentPP
implements PreProcessorPointF {
    private double[] disp;

    public ExponentPP(double[] displacements) {
        this.disp = Arrays.copyOf(displacements, displacements.length);
    }

    @Override
    public void pre(double[] raw, long[] pre) {
        for (int d = 0; d < raw.length; ++d) {
            pre[d] = BitTools.toSortableLong(raw[d] + this.disp[d]);
        }
    }

    @Override
    public void post(long[] pre, double[] post) {
        for (int d = 0; d < pre.length; ++d) {
            post[d] = BitTools.toDouble(pre[d]) - this.disp[d];
        }
    }

    public double getDisplacement(int dim) {
        if (dim < 0 || dim >= this.disp.length) {
            throw new IllegalArgumentException("Supplied dim is out of bounds");
        }
        return this.disp[dim];
    }

    @Override
    public long pre(double raw) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double post(long pre) {
        throw new UnsupportedOperationException();
    }
}

