/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.globis.phtree.v16hd;

import ch.ethz.globis.phtree.PhEntry;
import ch.ethz.globis.phtree.PhFilter;
import ch.ethz.globis.phtree.v16hd.BitsHD;
import ch.ethz.globis.phtree.v16hd.Node;
import ch.ethz.globis.phtree.v16hd.bst.BSTIteratorMask;

public class NodeIteratorNoGC<T> {
    private Node node;
    private final BSTIteratorMask niIterator;
    private final long[] maskLower;
    private final long[] maskUpper;
    private long[] rangeMin;
    private long[] rangeMax;
    private PhFilter checker;

    public NodeIteratorNoGC(int dims) {
        this.maskLower = BitsHD.newArray(dims);
        this.maskUpper = BitsHD.newArray(dims);
        this.niIterator = new BSTIteratorMask();
    }

    private void reinit(Node node, long[] rangeMin, long[] rangeMax, PhFilter checker) {
        this.rangeMin = rangeMin;
        this.rangeMax = rangeMax;
        this.checker = checker;
        this.node = node;
        this.niIterator.reset(node.getRoot(), this.maskLower, this.maskUpper);
    }

    boolean increment(PhEntry<T> result) {
        while (this.niIterator.hasNextEntry()) {
            Node.BSTEntry be = this.niIterator.nextEntry();
            if (!this.readValue(be, result)) continue;
            return true;
        }
        return false;
    }

    private boolean readValue(Node.BSTEntry candidate, PhEntry<T> result) {
        if (!this.node.checkAndGetEntry(candidate, result, this.rangeMin, this.rangeMax)) {
            return false;
        }
        if (candidate.getValue() instanceof Node) {
            Node sub = (Node)candidate.getValue();
            return this.checker == null || sub.getPostLen() >= 63 || this.checker.isValid(sub.getPostLen() + 1, candidate.getKdKey());
        }
        return this.checker == null || this.checker.isValid(candidate.getKdKey());
    }

    private void calcLimits(long[] rangeMin, long[] rangeMax, long[] prefix) {
        if (prefix == null) {
            prefix = rangeMin;
        }
        int postLen = this.node.getPostLen();
        long maskHcBit = 1L << postLen;
        long maskVT = -1L << postLen;
        long[] lowerLimit = this.maskLower;
        long[] upperLimit = this.maskUpper;
        BitsHD.set0(lowerLimit);
        BitsHD.set0(upperLimit);
        int maskSlot = 0;
        long mask1 = 1L << BitsHD.mod65x(prefix.length) - 1;
        if (maskHcBit >= 0L) {
            for (int i = 0; i < prefix.length; ++i) {
                long nodeBisection = (prefix[i] | maskHcBit) & maskVT;
                if (rangeMin[i] >= nodeBisection) {
                    int n = maskSlot;
                    lowerLimit[n] = lowerLimit[n] | mask1;
                }
                if (rangeMax[i] >= nodeBisection) {
                    int n = maskSlot;
                    upperLimit[n] = upperLimit[n] | mask1;
                }
                if ((mask1 >>>= 1) != 0L) continue;
                mask1 = Long.MIN_VALUE;
                ++maskSlot;
            }
        } else {
            for (int i = 0; i < prefix.length; ++i) {
                if (rangeMin[i] < 0L) {
                    int n = maskSlot;
                    upperLimit[n] = upperLimit[n] | mask1;
                }
                if (rangeMax[i] < 0L) {
                    int n = maskSlot;
                    lowerLimit[n] = lowerLimit[n] | mask1;
                }
                if ((mask1 >>>= 1) != 0L) continue;
                mask1 = Long.MIN_VALUE;
                ++maskSlot;
            }
        }
    }

    void init(long[] rangeMin, long[] rangeMax, Node node, PhFilter checker, long[] prefix) {
        this.node = node;
        this.calcLimits(rangeMin, rangeMax, prefix);
        this.reinit(node, rangeMin, rangeMax, checker);
    }
}

