/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import org.twak.utils.Intersector;
import org.twak.utils.Line;
import org.twak.utils.Mathz;
import org.twak.utils.Pair;
import org.twak.utils.collections.Arrayz;
import org.twak.utils.collections.ConsecutivePairs;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.collections.MultiMap;
import org.twak.utils.collections.SuperLoop;
import org.twak.utils.geom.Anglez;
import org.twak.utils.geom.DRectangle;
import org.twak.utils.geom.Graph2D;
import org.twak.utils.geom.HalfMesh2;
import org.twak.utils.geom.LinearForm;
import org.twak.utils.geom.LinearForm3D;
import org.twak.utils.geom.ObjDump;
import org.twak.utils.geom.UnionWalker;
import org.twak.utils.results.OOB;
import org.twak.utils.triangulate.EarCutTriangulator;

public class Loopz {
    public static LoopL<Point2d> insideOutside(LoopL<Point2d> a, LoopL<Point2d> b) {
        LoopL<Point2d> out = a;
        HashSet<Line> lines = new HashSet<Line>();
        for (Loopable<Point2d> ctx : a.getLoopableIterable()) {
            lines.add(new Line(ctx.get(), ctx.getNext().get()));
        }
        for (Loopable<Point2d> ctx : b.getLoopableIterable()) {
            lines.add(new Line(ctx.get(), ctx.getNext().get()));
        }
        Intersector is = new Intersector();
        List<Intersector.Collision> cols = is.intersectLines(lines);
        MultiMap<Line, Point2d> cutLineAt = new MultiMap<Line, Point2d>();
        for (Intersector.Collision c : cols) {
            for (Line l : c.lines) {
                if (l.start.equals(c.location) || l.end.equals(c.location)) continue;
                cutLineAt.put(l, c.location);
            }
        }
        Iterator<Intersector.Collision> iterator = cutLineAt.keySet().iterator();
        while (iterator.hasNext()) {
            Line l;
            final Line ll = l = (Line)((Object)iterator.next());
            lines.remove(l);
            List cutPoints = cutLineAt.get(l);
            cutPoints.sort(new Comparator<Point2d>(){

                @Override
                public int compare(Point2d o1, Point2d o2) {
                    return Double.compare(ll.findPPram(o1), ll.findPPram(o2));
                }
            });
            cutPoints.add(0, l.start);
            cutPoints.add(l.end);
            for (Pair pair : new ConsecutivePairs(cutPoints, false)) {
                lines.add(new Line((Point2d)pair.first(), (Point2d)pair.second()));
            }
        }
        UnionWalker uw = new UnionWalker();
        lines.stream().forEach(x -> uw.addEdge(x.start, x.end));
        out = uw.findAll();
        return out;
    }

    public static double area(Loop<Point2d> loop) {
        Point2d origin = loop.iterator().next();
        double area = 0.0;
        for (Loopable<Point2d> pt : loop.loopableIterator()) {
            area += Mathz.area(origin, pt.getNext().get(), pt.get());
        }
        return area;
    }

    public static double area(LoopL<Point2d> insideOutside) {
        return insideOutside.stream().mapToDouble(x -> Loopz.area(x)).sum();
    }

    public static double area3(Loop<Point3d> loop) {
        Point3d origin = loop.iterator().next();
        double area = 0.0;
        for (Loopable<Point3d> pt : loop.loopableIterator()) {
            area += Mathz.area(origin, pt.getNext().get(), pt.get());
        }
        return area;
    }

    public static double area3(LoopL<Point3d> insideOutside) {
        return insideOutside.stream().mapToDouble(x -> Loopz.area3(x)).sum();
    }

    public static void writeXZObj(LoopL<Point2d> lloops, File file, boolean filterHoles) {
        ObjDump obj = new ObjDump();
        for (Loop loop : lloops) {
            if (filterHoles && !(Loopz.area(loop) < 0.0)) continue;
            ArrayList<Point3d> ptz = new ArrayList<Point3d>();
            for (Point2d p : loop) {
                ptz.add(new Point3d(p.x, 0.0, p.y));
            }
            obj.addFace(ptz);
        }
        obj.dump(file);
    }

    public static Graph2D toGraph(LoopL<Point2d> edges) {
        Graph2D g2 = new Graph2D();
        for (Loop loop : edges) {
            for (Loopable ll : loop.loopableIterator()) {
                g2.add((Point2d)ll.get(), (Point2d)ll.getNext().get());
            }
        }
        return g2;
    }

    public static void triangulate(Loop<? extends Point3d> loop, boolean reverseTriangles, List<Integer> indsO, List<Float> posO, List<Float> normsO) {
        int[] nArray;
        ArrayList<Float> pos = new ArrayList<Float>();
        ArrayList<Integer> inds = new ArrayList<Integer>();
        Vector3d normal = new Vector3d();
        if (reverseTriangles) {
            int[] nArray2 = new int[3];
            nArray2[0] = 2;
            nArray2[1] = 1;
            nArray = nArray2;
            nArray2[2] = 0;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = 0;
            nArray3[1] = 1;
            nArray = nArray3;
            nArray3[2] = 2;
        }
        int[] order = nArray;
        for (Loopable<? extends Point3d> pt : loop.loopableIterator()) {
            inds.add(inds.size());
            Point3d p = pt.get();
            pos.add(Float.valueOf((float)p.x));
            pos.add(Float.valueOf((float)p.y));
            pos.add(Float.valueOf((float)p.z));
            Vector3d l = new Vector3d(pt.get());
            l.sub(pt.getPrev().get());
            Vector3d n = new Vector3d(pt.getNext().get());
            n.sub(pt.get());
            if (!(l.lengthSquared() > 0.0) || !(n.lengthSquared() > 0.0)) continue;
            l.normalize();
            n.normalize();
            l.cross(l, n);
            normal.add(l);
        }
        float[] n = new float[]{(float)normal.x, (float)normal.y, (float)normal.z};
        float[] p = Arrayz.toFloatArray(pos);
        int[] i = Arrayz.toIntArray(inds);
        int[] ti = new int[i.length * 3];
        int tris = EarCutTriangulator.triangulateConcavePolygon(p, 0, inds.size(), i, ti, n);
        if (tris > 0) {
            int j;
            int offset = posO.size() / 3;
            for (j = 0; j < tris * 3; j += 3) {
                indsO.add(ti[j + order[0]] + offset);
                indsO.add(ti[j + order[1]] + offset);
                indsO.add(ti[j + order[2]] + offset);
            }
            for (j = 0; j < pos.size(); j += 3) {
                posO.add((Float)pos.get(j + 0));
                posO.add((Float)pos.get(j + 1));
                posO.add((Float)pos.get(j + 2));
                normsO.add(Float.valueOf(n[0]));
                normsO.add(Float.valueOf(n[1]));
                normsO.add(Float.valueOf(n[2]));
            }
        }
    }

    public static LoopL<Point3d> insertInnerEdges(LoopL<Point3d> ll) {
        while (ll.size() > 1) {
            LoopL<Loop> out = new LoopL<Loop>();
            Loop hole = (Loop)ll.get(1);
            Loop peri = (Loop)ll.get(0);
            out.add(peri);
            for (int i = 2; i < ll.size(); ++i) {
                out.add((Loop)ll.get(i));
            }
            Loopable hi = null;
            Loopable pi = null;
            double bestDist = Double.MAX_VALUE;
            for (Loopable h2 : hole.loopableIterator()) {
                for (Loopable p : peri.loopableIterator()) {
                    double dist = ((Point3d)h2.get()).distanceSquared((Point3d)p.get());
                    if (!(dist < bestDist)) continue;
                    hi = h2;
                    pi = p;
                    bestDist = dist;
                }
            }
            Loopable<Point3d> h2 = new Loopable<Point3d>(new Point3d((Point3d)hi.get()));
            Loopable<Point3d> p2 = new Loopable<Point3d>(new Point3d((Point3d)pi.get()));
            h2.prev = hi.prev;
            h2.next = p2;
            p2.next = pi.next;
            p2.prev = h2;
            pi.next.prev = p2;
            hi.prev.next = h2;
            hi.prev = pi;
            pi.next = hi;
            ll = out;
        }
        return ll;
    }

    public static LoopL<Point2d> removeInnerEdges(LoopL<Point2d> edges) {
        Graph2D g2 = Loopz.toGraph(edges);
        g2.removeInnerEdges();
        UnionWalker uw = new UnionWalker();
        for (Point2d a : g2.map.keySet()) {
            for (Line l : g2.get(a)) {
                uw.addEdge(l.start, l.end);
            }
        }
        edges = uw.findAll();
        return edges;
    }

    public static double[] minMaxXZ(Loop<Point3d> in) {
        double[] out = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        for (Point3d p : in) {
            out[0] = Math.min(out[0], p.x);
            out[1] = Math.max(out[1], p.x);
            out[2] = Math.min(out[2], p.z);
            out[3] = Math.max(out[3], p.z);
        }
        return out;
    }

    public static double[] minMaxXY(LoopL<Point3d> in) {
        double[] out = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        for (Loop loop : in) {
            for (Point3d p : loop) {
                out[0] = Math.min(out[0], p.x);
                out[1] = Math.max(out[1], p.x);
                out[2] = Math.min(out[2], p.y);
                out[3] = Math.max(out[3], p.y);
            }
        }
        return out;
    }

    public static double[] minMax(LoopL<Point3d> in) {
        double[] out = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        for (Loop loop : in) {
            for (Point3d p : loop) {
                out[0] = Math.min(out[0], p.x);
                out[1] = Math.max(out[1], p.x);
                out[2] = Math.min(out[2], p.y);
                out[3] = Math.max(out[3], p.y);
                out[4] = Math.min(out[4], p.z);
                out[5] = Math.max(out[5], p.z);
            }
        }
        return out;
    }

    public static DRectangle rect(LoopL<? extends Point2d> in) {
        double[] out = Loopz.minMax2d(in);
        return new DRectangle(out[0], out[2], out[1] - out[0], out[3] - out[2]);
    }

    public static DRectangle rect(Loop<? extends Point2d> in) {
        double[] out = Loopz.minMax2d(in);
        return new DRectangle(out[0], out[2], out[1] - out[0], out[3] - out[2]);
    }

    public static double[] minMax2d(LoopL<? extends Point2d> in) {
        double[] out = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        for (Loop loop : in) {
            Loopz.minMax2d(loop, out);
        }
        return out;
    }

    public static double[] minMax2d(Loop<? extends Point2d> in) {
        double[] out = new double[]{Double.MAX_VALUE, -1.7976931348623157E308, Double.MAX_VALUE, -1.7976931348623157E308};
        Loopz.minMax2d(in, out);
        return out;
    }

    private static void minMax2d(Loop<? extends Point2d> in, double[] out) {
        for (Point2d point2d : in) {
            out[0] = Math.min(out[0], point2d.x);
            out[1] = Math.max(out[1], point2d.x);
            out[2] = Math.min(out[2], point2d.y);
            out[3] = Math.max(out[3], point2d.y);
        }
    }

    public static void expand(double[] minMax, double i) {
        for (int j = 0; j < minMax.length; j += 2) {
            int n = j + 0;
            minMax[n] = minMax[n] - i;
            int n2 = j + 1;
            minMax[n2] = minMax[n2] + i;
        }
    }

    public static LoopL<Point2d> toXZLoop(LoopL<Point3d> list) {
        LoopL<Point2d> out = new LoopL<Point2d>();
        for (Loop loop : list) {
            out.add((Point2d)((Object)Loopz.toXZLoop(loop)));
        }
        return out;
    }

    public static Loop<Point2d> toXZLoop(Loop<Point3d> ll) {
        SuperLoop<Point2d> o = ll instanceof SuperLoop ? new SuperLoop(((SuperLoop)ll).properties) : new Loop();
        for (Point3d point3d : ll) {
            o.append((Point2d[])new Point2d[]{new Point2d(point3d.x, point3d.z)});
        }
        for (Loop loop : ll.holes) {
            o.holes.add(Loopz.toXZLoop(loop));
        }
        return o;
    }

    public static LoopL<Point2d> to2dLoop(LoopL<Point3d> in, int axis, Map<Point2d, Point3d> to3d) {
        LoopL<Point2d> out = new LoopL<Point2d>();
        for (Loop loop : in) {
            Loop<Point2d> ol = Loopz.to2dLoop(loop, axis, to3d);
            out.add((Point2d)((Object)ol));
        }
        return out;
    }

    public static Loop<Point2d> to2dLoop(Loop<Point3d> in, int axis, Map<Point2d, Point3d> to3d) {
        Loop<Point2d> out = new Loop<Point2d>();
        for (Point3d p3 : in) {
            Point2d p2;
            Point2d point2d = axis == 0 ? new Point2d(p3.y, p3.z) : (p2 = axis == 1 ? new Point2d(p3.x, p3.z) : new Point2d(p3.y, p3.z));
            if (to3d != null) {
                to3d.put(p2, p3);
            }
            out.append((Point2d[])new Point2d[]{p2});
        }
        return out;
    }

    public static LoopL<Point2d> removeNegativeArea(LoopL<Point2d> gis, double sign) {
        Iterator eit = gis.iterator();
        while (eit.hasNext()) {
            double area = Loopz.area((Loop)eit.next());
            if (!(sign * area > 0.0)) continue;
            eit.remove();
        }
        return gis;
    }

    public static LoopL<Point2d> mergeAdjacentEdges(LoopL<Point2d> in, double areaTol, double angleTol) {
        LoopL<Point2d> out = new LoopL<Point2d>(in);
        Iterator eit = out.iterator();
        while (eit.hasNext()) {
            boolean again;
            Loopable start;
            Loop loop = (Loop)eit.next();
            Loopable current = start = loop.start;
            int size = loop.count();
            do {
                again = false;
                Point2d a = (Point2d)current.getPrev().get();
                Point2d b = (Point2d)current.get();
                Point2d c = (Point2d)current.getNext().get();
                Line ab = new Line(a, b);
                Line bc = new Line(b, c);
                double angle = Anglez.dist(ab.aTan2(), bc.aTan2());
                if (a.distanceSquared(b) < 1.0E-4 || b.distanceSquared(c) < 1.0E-4 || angle < angleTol && Math.abs(Mathz.area(a, b, c)) < 50.0 * areaTol * areaTol) {
                    current.getPrev().setNext(current.getNext());
                    current.getNext().setPrev(current.getPrev());
                    --size;
                    if (start == current) {
                        start = current.getPrev();
                        loop.start = start;
                    }
                    again = true;
                    current = current.getPrev();
                    continue;
                }
                current = current.getNext();
            } while ((again || current != start) && size > 2);
            if (size > 2) continue;
            eit.remove();
        }
        return out;
    }

    public static Loop<Point2d> mergeAdjacentEdges2(Loop<Point2d> in, double angleTol) {
        boolean again;
        Loopable start;
        Loop<Point2d> out = new Loop<Point2d>(in);
        Loopable current = start = out.start;
        int size = out.count();
        do {
            again = false;
            Point2d a = (Point2d)current.getPrev().get();
            Point2d b = (Point2d)current.get();
            Point2d c = (Point2d)current.getNext().get();
            Line ab = new Line(a, b);
            Line bc = new Line(b, c);
            double angle = Anglez.dist(ab.aTan2(), bc.aTan2());
            if (a.distanceSquared(b) < 1.0E-4 || b.distanceSquared(c) < 1.0E-4 || angle < angleTol) {
                current.getPrev().setNext(current.getNext());
                current.getNext().setPrev(current.getPrev());
                --size;
                if (start == current) {
                    start = current.getPrev();
                    out.start = start;
                }
                again = true;
                current = current.getPrev();
                continue;
            }
            current = current.getNext();
        } while ((again || current != start) && size > 2);
        return out;
    }

    public static LoopL<Point3d> to3d(LoopL<? extends Point2d> gis, double h2, int i) {
        LoopL<Point3d> out = new LoopL<Point3d>();
        for (Loop loop : gis) {
            Loop<Point3d> ol = Loopz.to3d(loop, h2, i);
            out.add((Point3d)((Object)ol));
        }
        return out;
    }

    public static Loop<Point3d> to3d(Loop<? extends Point2d> lp, double h2, int i) {
        Loop<Point3d> ol = new Loop<Point3d>();
        for (Point2d point2d : lp) {
            ol.append((Point3d[])new Point3d[]{i == 1 ? new Point3d(point2d.x, h2, point2d.y) : (i == 2 ? new Point3d(point2d.x, point2d.y, h2) : new Point3d(h2, point2d.x, point2d.y))});
        }
        return ol;
    }

    public static List<Point3d> intersect(LoopL<Point3d> gis, LinearForm3D lf) {
        ArrayList<Point3d> out = new ArrayList<Point3d>();
        for (Loop loop : gis) {
            for (Loopable pt : loop.loopableIterator()) {
                Vector3d dir = new Vector3d((Tuple3d)pt.getNext().get());
                dir.sub((Tuple3d)pt.get());
                Point3d res = lf.collide((Tuple3d)pt.get(), dir, dir.length());
                if (res instanceof OOB) continue;
                out.add(res);
            }
        }
        return out;
    }

    public static LoopL<Point2d> from(HalfMesh2 hm) {
        LoopL<Point2d> out = new LoopL<Point2d>();
        for (HalfMesh2.HalfFace hf : hm.faces) {
            out.add((Point2d)((Object)Loopz.from(hf)));
        }
        return out;
    }

    public static Loop<Point2d> from(HalfMesh2.HalfFace hf) {
        Loop<Point2d> loop = new Loop<Point2d>();
        for (HalfMesh2.HalfEdge he : hf.edges()) {
            loop.append((Point2d[])new Point2d[]{he.start});
        }
        return loop;
    }

    public static boolean inside(Point2d pt, LoopL<? extends Point2d> poly) {
        return poly.stream().anyMatch(l -> Loopz.inside(pt, (Loop<? extends Point2d>)l));
    }

    public static boolean inside(Point2d pt, Loop<? extends Point2d> poly) {
        if (poly == null) {
            return false;
        }
        int crossings = 0;
        Vector2d left = new Vector2d(-1.0, 0.0);
        for (Loopable<? extends Point2d> ll : poly.loopableIterator()) {
            Line l = new Line(ll.get(), ll.getNext().get());
            if (!(l.start.y < pt.y && l.end.y > pt.y) && (!(l.start.y > pt.y) || !(l.end.y < pt.y)) || l.intersects(pt, left) == null) continue;
            ++crossings;
        }
        return crossings % 2 == 1;
    }

    public static boolean inside(Line b, Loop<? extends Point2d> poly) {
        if (Loopz.inside(b.start, poly)) {
            return true;
        }
        for (Loopable<? extends Point2d> ll : poly.loopableIterator()) {
            Line a = new Line(ll.get(), ll.getNext().get());
            if (a.intersects(b, true) == null) continue;
            return true;
        }
        return false;
    }

    public static LinearForm3D findPlane(LoopL<Point3d> loopL) {
        Vector3d normal = new Vector3d();
        Point3d cen = new Point3d();
        int count = 0;
        for (Loop loop : loopL) {
            for (Loopable pt : loop.loopableIterator()) {
                Vector3d l = new Vector3d((Tuple3d)pt.get());
                l.sub((Tuple3d)pt.getPrev().get());
                Vector3d n = new Vector3d((Tuple3d)pt.getNext().get());
                n.sub((Tuple3d)pt.get());
                if (l.lengthSquared() > 0.0 && n.lengthSquared() > 0.0) {
                    l.normalize();
                    n.normalize();
                    l.cross(l, n);
                    normal.add(l);
                }
                cen.add((Tuple3d)pt.get());
                ++count;
            }
        }
        cen.scale(1.0 / (double)count);
        return new LinearForm3D(normal, cen);
    }

    public static Loop<Point3d> transform(Loop<? extends Point3d> ll, Matrix4d mat) {
        Loop<Point3d> out = new Loop<Point3d>();
        for (Point3d point3d : ll) {
            Point3d pn = new Point3d(point3d);
            mat.transform(pn);
            out.append((Point3d[])new Point3d[]{pn});
        }
        return out;
    }

    public static LoopL<Point3d> transform(LoopL<? extends Point3d> ll, Matrix4d mat) {
        LoopL<Point3d> out = new LoopL<Point3d>();
        for (Loop loop : ll) {
            out.add((Point3d)((Object)Loopz.transform(loop, mat)));
        }
        return out;
    }

    public static Loop<Point2d>[] cutConvex(Loop<Point2d> loop, LinearForm cut) {
        Loop[] out = new Loop[]{new Loop(), new Loop()};
        Loopable<Point2d> start = null;
        int cuI = -1;
        for (Loopable<Point2d> l : loop.loopableIterator()) {
            boolean b;
            boolean a = cut.isInFront(l.get());
            if (a ^ (b = cut.isInFront(l.getNext().get()))) {
                start = l;
                cuI = a ? 1 : 0;
                break;
            }
            cuI = a ? 1 : 0;
        }
        if (start == null) {
            out[cuI] = loop;
            return out;
        }
        Loopable<Point2d> current = start;
        do {
            boolean a = cut.isInFront((Point2d)current.get());
            boolean b = cut.isInFront((Point2d)current.getNext().get());
            out[cuI].append(current.get());
            if (!(a ^ b)) continue;
            Point2d sec = new LinearForm(current.get(), current.getNext().get()).intersect(cut);
            if (sec == null) {
                sec = current.get();
            }
            out[cuI].append(sec);
            cuI = 1 - cuI;
            out[cuI].append(sec);
        } while ((current = current.next) != start);
        return out;
    }

    public static void dirtySnap(Loop<Point3d> poly, double snapFootprintVert) {
        Loopz.dirtySnap(poly, snapFootprintVert, new ArrayList<Point3d>());
    }

    private static void dirtySnap(Loop<Point3d> poly, double snapFootprintVert, List<Point3d> seen) {
        block0: for (Loopable<Point3d> pt : poly.loopableIterator()) {
            for (Point3d pt2 : seen) {
                if (!(pt.get().distance(pt2) < snapFootprintVert)) continue;
                pt.me = new Point3d(pt2);
                continue block0;
            }
            seen.add(pt.get());
        }
    }

    public static void dirtySnap(LoopL<Point3d> polies, double snapFootprintVert) {
        ArrayList<Point3d> seen = new ArrayList<Point3d>();
        for (Loop loop : polies) {
            Loopz.dirtySnap(loop, snapFootprintVert, seen);
        }
    }

    public static Point2d average(LoopL<Point2d> polies) {
        Point2d out = new Point2d();
        int count = 0;
        for (Loop loop : polies) {
            for (Point2d pt : loop) {
                out.x += pt.x;
                out.y += pt.y;
                ++count;
            }
        }
        out.x /= (double)count;
        out.y /= (double)count;
        return out;
    }

    public static List<Polygon> toPolygon(LoopL<Point2d> toDraw, DRectangle src, DRectangle dest) {
        ArrayList<Polygon> out = new ArrayList<Polygon>();
        for (Loop loop : toDraw) {
            Polygon p = new Polygon();
            out.add(p);
            for (Point2d pt : loop) {
                pt = dest.transform(src.normalize(pt));
                p.addPoint((int)pt.x, (int)pt.y);
            }
        }
        return out;
    }

    public static Loop<Point2d> transform(Loop<Point2d> verticalPts, AffineTransform t) {
        return (Loop)Loopz.transform(verticalPts.singleton(), t).get(0);
    }

    public static LoopL<Point2d> transform(LoopL<Point2d> verticalPts, final AffineTransform t) {
        LoopL<Point2d> loopL = verticalPts;
        Objects.requireNonNull(loopL);
        return new LoopL.Map<Point2d>(loopL){
            double[] tmp;
            {
                super(x0);
                this.tmp = new double[2];
            }

            @Override
            public Point2d map(Loopable<Point2d> input) {
                this.tmp[0] = ((Point2d)input.me).x;
                this.tmp[1] = ((Point2d)input.me).y;
                t.transform(this.tmp, 0, this.tmp, 0, 1);
                return new Point2d(this.tmp[0], this.tmp[1]);
            }
        }.run();
    }

    public static Loop<Point2d> translate(Loop<Point2d> loop, final Vector2d dir) {
        Loop<Point2d> loop2 = loop;
        Objects.requireNonNull(loop2);
        return new Loop.Map<Point2d>(loop2){

            @Override
            public Point2d map(Loopable<Point2d> input) {
                return new Point2d(input.get().x + dir.x, input.get().y + dir.y);
            }
        }.run();
    }

    public static Loop<Point2d> deepCopy(Loop<Point2d> loop) {
        return new Loop.Map<Point2d>(loop){

            @Override
            public Point2d map(Loopable<Point2d> input) {
                return new Point2d(input.get().x, input.get().y);
            }
        }.run();
    }

    public static LoopL<Point2d> findHoles(LoopL<Point2d> findAll) {
        Loop query;
        LoopL<Point2d> out = new LoopL<Point2d>();
        Collections.sort(findAll, (a, b) -> Double.compare(Loopz.area(b), Loopz.area(a)));
        Iterator iterator = findAll.iterator();
        block0: while (iterator.hasNext() && !(Loopz.area(query = (Loop)iterator.next()) < 1.0E-5)) {
            for (Loop loop : out) {
                if (!Loopz.dirtyInside(query, loop)) continue;
                loop.holes.add(query);
                continue block0;
            }
            out.add((Point2d)((Object)query));
        }
        return out;
    }

    public static boolean dirtyInside(Loop<Point2d> maybeHole, Loop<Point2d> perimeter) {
        Iterator<Point2d> iterator = maybeHole.iterator();
        if (iterator.hasNext()) {
            Point2d p = iterator.next();
            return Loopz.inside(p, perimeter);
        }
        return false;
    }
}

