/*
 * Decompiled with CFR 0.152.
 */
package org.twak.utils.collections;

import java.util.Iterator;

public class Loopable<E>
implements Iterable<Loopable<E>> {
    E me;
    public Loopable<E> next;
    public Loopable<E> prev;

    public Loopable(E me) {
        this.me = me;
    }

    public String toString() {
        return "L<" + String.valueOf(this.me) == null ? "null" : String.valueOf(this.me) + ">";
    }

    public E get() {
        return this.me;
    }

    public void set(E e) {
        this.me = e;
    }

    public Loopable<E> getNext() {
        return this.next;
    }

    public Loopable<E> getPrev() {
        return this.prev;
    }

    public void setNext(Loopable<E> s2) {
        this.next = s2;
    }

    public void setPrev(Loopable<E> s2) {
        this.prev = s2;
    }

    @Override
    public Iterator<Loopable<E>> iterator() {
        return new LoopableIterator(this);
    }

    public int count() {
        int count = 0;
        for (Loopable<E> e : this) {
            ++count;
        }
        return count;
    }

    public Loopable<E> move(int dir) {
        Loopable<E> out = this;
        while (dir > 0) {
            --dir;
            out = out.getNext();
        }
        while (dir < 0) {
            ++dir;
            out = out.getPrev();
        }
        return out;
    }

    public class LoopIterator
    implements Iterator<E> {
        public LoopableIterator lit;

        public LoopIterator(Loopable<E> start) {
            this.lit = new LoopableIterator(start);
        }

        @Override
        public boolean hasNext() {
            return this.lit.hasNext();
        }

        @Override
        public E next() {
            return ((Loopable)this.lit.next()).me;
        }

        @Override
        public void remove() {
            this.lit.remove();
        }
    }

    public class LoopableIterator
    implements Iterator<Loopable<E>> {
        Loopable<E> s;
        Loopable<E> n;
        Loopable<E> start;

        public LoopableIterator(Loopable<E> start) {
            this.s = start;
            this.n = null;
        }

        @Override
        public boolean hasNext() {
            if (this.s == null) {
                return false;
            }
            if (this.n == null) {
                return true;
            }
            return this.n != this.s;
        }

        @Override
        public Loopable<E> next() {
            if (this.n == null) {
                this.n = this.s;
            }
            Loopable out = this.n;
            this.n = this.n.getNext();
            return out;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

