/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.spark.internal.Logging;
import org.apache.spark.package$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$ParquetOutputTimestampType$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.SparkToParquetSchemaConverter;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DayTimeIntervalType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampNTZType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.apache.spark.sql.types.YearMonthIntervalType;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t\u0005e\u0001B\u00193\u0001\rCQ!\u0017\u0001\u0005\u0002i+A!\u0018\u0001\u0005=\"I\u0001\u000f\u0001a\u0001\u0002\u0004%I!\u001d\u0005\nq\u0002\u0001\r\u00111A\u0005\neD\u0011\u0002 \u0001A\u0002\u0003\u0005\u000b\u0015\u0002:\t\u0013u\u0004\u0001\u0019!a\u0001\n\u0013q\bbCA\u0005\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0017A!\"a\u0004\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0000\u0011-\t\t\u0002\u0001a\u0001\u0002\u0004%I!a\u0005\t\u0017\u0005\r\u0002\u00011AA\u0002\u0013%\u0011Q\u0005\u0005\f\u0003S\u0001\u0001\u0019!A!B\u0013\t)\u0002C\u0006\u0002,\u0001\u0001\r\u00111A\u0005\n\u00055\u0002bCA\u001b\u0001\u0001\u0007\t\u0019!C\u0005\u0003oA1\"a\u000f\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00020!Y\u0011Q\b\u0001A\u0002\u0003\u0007I\u0011BA \u0011-\tI\u0006\u0001a\u0001\u0002\u0004%I!a\u0017\t\u0017\u0005}\u0003\u00011A\u0001B\u0003&\u0011\u0011\t\u0005\n\u0003C\u0002!\u0019!C\u0005\u0003GB\u0001\"!\u001c\u0001A\u0003%\u0011Q\r\u0005\n\u0003_\u0002!\u0019!C\u0005\u0003GB\u0001\"!\u001d\u0001A\u0003%\u0011Q\r\u0005\n\u0003g\u0002!\u0019!C\u0005\u0003kB\u0001\"a \u0001A\u0003%\u0011q\u000f\u0005\n\u0003\u0003\u0003!\u0019!C\u0005\u0003\u0007C\u0001\"a#\u0001A\u0003%\u0011Q\u0011\u0005\n\u0003\u001b\u0003!\u0019!C\u0005\u0003\u001fC\u0001\"!'\u0001A\u0003%\u0011\u0011\u0013\u0005\n\u00037\u0003!\u0019!C\u0005\u0003kB\u0001\"!(\u0001A\u0003%\u0011q\u000f\u0005\n\u0003?\u0003!\u0019!C\u0005\u0003\u001fC\u0001\"!)\u0001A\u0003%\u0011\u0011\u0013\u0005\b\u0003G\u0003A\u0011IAS\u0011\u001d\t\t\u000f\u0001C!\u0003GDq!a:\u0001\t\u0003\nI\u000fC\u0004\u0002p\u0002!I!!=\t\u000f\u0005m\b\u0001\"\u0003\u0002~\"9!\u0011\u0002\u0001\u0005\n\t-\u0001b\u0002B\u000b\u0001\u0011\u0005!q\u0003\u0005\b\u0005G\u0001A\u0011\u0002B\u0013\u0011\u001d\u0011\t\u0004\u0001C\u0005\u0005gAqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003F\u0001!IAa\u0012\b\u000f\t\u0015$\u0007#\u0001\u0003h\u00191\u0011G\rE\u0001\u0005SBa!\u0017\u0017\u0005\u0002\tE\u0004\"\u0003B:Y\t\u0007I\u0011\u0001B;\u0011!\u00119\b\fQ\u0001\n\tE\u0003b\u0002B=Y\u0011\u0005!1\u0010\u0002\u0014!\u0006\u0014\u0018/^3u/JLG/Z*vaB|'\u000f\u001e\u0006\u0003gQ\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003kY\n!bZ3pa\u0006\u0014\u0018/^3u\u0015\t9\u0004(A\u0006eCR\f7o\\;sG\u0016\u001c(BA\u001d;\u0003%)\u00070Z2vi&|gN\u0003\u0002<y\u0005\u00191/\u001d7\u000b\u0005ur\u0014!B:qCJ\\'BA A\u0003\u0019\t\u0007/Y2iK*\t\u0011)A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\tR\u00032!\u0012'O\u001b\u00051%BA$I\u0003\r\t\u0007/\u001b\u0006\u0003\u0013*\u000ba\u0001[1e_>\u0004(BA&?\u0003\u001d\u0001\u0018M]9vKRL!!\u0014$\u0003\u0019]\u0013\u0018\u000e^3TkB\u0004xN\u001d;\u0011\u0005=\u0013V\"\u0001)\u000b\u0005ES\u0014\u0001C2bi\u0006d\u0017p\u001d;\n\u0005M\u0003&aC%oi\u0016\u0014h.\u00197S_^\u0004\"!V,\u000e\u0003YS!a\r\u001f\n\u0005a3&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0003\"\u0001\u0018\u0001\u000e\u0003I\u00121BV1mk\u0016<&/\u001b;feB)qL\u00193k[6\t\u0001MC\u0001b\u0003\u0015\u00198-\u00197b\u0013\t\u0019\u0007MA\u0005Gk:\u001cG/[8oeA\u0011Q\r[\u0007\u0002M*\u0011q\rU\u0001\fKb\u0004(/Z:tS>t7/\u0003\u0002jM\n\u00112\u000b]3dS\u0006d\u0017N_3e\u000f\u0016$H/\u001a:t!\ty6.\u0003\u0002mA\n\u0019\u0011J\u001c;\u0011\u0005}s\u0017BA8a\u0005\u0011)f.\u001b;\u0002\rM\u001c\u0007.Z7b+\u0005\u0011\bCA:w\u001b\u0005!(BA;;\u0003\u0015!\u0018\u0010]3t\u0013\t9HO\u0001\u0006TiJ,8\r\u001e+za\u0016\f!b]2iK6\fw\fJ3r)\ti'\u0010C\u0004|\t\u0005\u0005\t\u0019\u0001:\u0002\u0007a$\u0013'A\u0004tG\",W.\u0019\u0011\u0002!I|w\u000e\u001e$jK2$wK]5uKJ\u001cX#A@\u0011\u000b}\u000b\t!!\u0002\n\u0007\u0005\r\u0001MA\u0003BeJ\f\u0017\u0010E\u0002\u0002\b\ti\u0011\u0001A\u0001\u0015e>|GOR5fY\u0012<&/\u001b;feN|F%Z9\u0015\u00075\fi\u0001C\u0004|\u000f\u0005\u0005\t\u0019A@\u0002#I|w\u000e\u001e$jK2$wK]5uKJ\u001c\b%\u0001\bsK\u000e|'\u000fZ\"p]N,X.\u001a:\u0016\u0005\u0005U\u0001\u0003BA\f\u0003?i!!!\u0007\u000b\u0007\u001d\u000bYBC\u0002\u0002\u001e)\u000b!![8\n\t\u0005\u0005\u0012\u0011\u0004\u0002\u000f%\u0016\u001cwN\u001d3D_:\u001cX/\\3s\u0003I\u0011XmY8sI\u000e{gn];nKJ|F%Z9\u0015\u00075\f9\u0003\u0003\u0005|\u0015\u0005\u0005\t\u0019AA\u000b\u0003=\u0011XmY8sI\u000e{gn];nKJ\u0004\u0013\u0001G<sSR,G*Z4bGf\u0004\u0016M]9vKR4uN]7biV\u0011\u0011q\u0006\t\u0004?\u0006E\u0012bAA\u001aA\n9!i\\8mK\u0006t\u0017\u0001H<sSR,G*Z4bGf\u0004\u0016M]9vKR4uN]7bi~#S-\u001d\u000b\u0004[\u0006e\u0002\u0002C>\u000e\u0003\u0003\u0005\r!a\f\u00023]\u0014\u0018\u000e^3MK\u001e\f7-\u001f)beF,X\r\u001e$pe6\fG\u000fI\u0001\u0014_V$\b/\u001e;US6,7\u000f^1naRK\b/Z\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002R9!\u0011QIA&\u001d\ra\u0016qI\u0005\u0004\u0003\u0013\u0012\u0014a\u0004)peR\f'\r\\3T#2\u001buN\u001c4\n\t\u00055\u0013qJ\u0001\u001b!\u0006\u0014\u0018/^3u\u001fV$\b/\u001e;US6,7\u000f^1naRK\b/\u001a\u0006\u0004\u0003\u0013\u0012\u0014\u0002BA*\u0003+\u0012QAV1mk\u0016L1!a\u0016a\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002/=,H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3`I\u0015\fHcA7\u0002^!A1\u0010EA\u0001\u0002\u0004\t\t%\u0001\u000bpkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004X\rI\u0001\u0010i&lWm\u001d;b[B\u0014UO\u001a4feV\u0011\u0011Q\r\t\u0006?\u0006\u0005\u0011q\r\t\u0004?\u0006%\u0014bAA6A\n!!)\u001f;f\u0003A!\u0018.\\3ti\u0006l\u0007OQ;gM\u0016\u0014\b%A\u0007eK\u000eLW.\u00197Ck\u001a4WM]\u0001\u000fI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:!\u0003I!\u0017\r^3uS6,'+\u001a2bg\u0016lu\u000eZ3\u0016\u0005\u0005]\u0004\u0003BA=\u0003#r1\u0001XA>\u0013\r\tiHM\u0001\u0015\u0019\u0016<\u0017mY=CK\"\fg/[8s!>d\u0017nY=\u0002'\u0011\fG/\u001a;j[\u0016\u0014VMY1tK6{G-\u001a\u0011\u0002\u001d\u0011\fG/\u001a*fE\u0006\u001cXMR;oGV\u0011\u0011Q\u0011\t\u0006?\u0006\u001d%N[\u0005\u0004\u0003\u0013\u0003'!\u0003$v]\u000e$\u0018n\u001c82\u0003=!\u0017\r^3SK\n\f7/\u001a$v]\u000e\u0004\u0013a\u0005;j[\u0016\u001cH/Y7q%\u0016\u0014\u0017m]3Gk:\u001cWCAAI!\u001dy\u0016qQAJ\u0003'\u00032aXAK\u0013\r\t9\n\u0019\u0002\u0005\u0019>tw-\u0001\u000buS6,7\u000f^1naJ+'-Y:f\rVt7\rI\u0001\u0010S:$\u0018H\u000e*fE\u0006\u001cX-T8eK\u0006\u0001\u0012N\u001c;:mI+'-Y:f\u001b>$W\rI\u0001\u0010S:$\u0018H\u000e*fE\u0006\u001cXMR;oG\u0006\u0001\u0012N\u001c;:mI+'-Y:f\rVt7\rI\u0001\u0005S:LG\u000f\u0006\u0003\u0002(\u0006=\u0007\u0003BAU\u0003\u0013tA!a+\u0002F:!\u0011QVAb\u001d\u0011\ty+!1\u000f\t\u0005E\u0016q\u0018\b\u0005\u0003g\u000biL\u0004\u0003\u00026\u0006mVBAA\\\u0015\r\tILQ\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005K!a\u0010!\n\u0005-s\u0014BA%K\u0013\t9\u0005*C\u0002\u0002H\u001a\u000bAb\u0016:ji\u0016\u001cV\u000f\u001d9peRLA!a3\u0002N\naqK]5uK\u000e{g\u000e^3yi*\u0019\u0011q\u0019$\t\u000f\u0005E\u0007\u00051\u0001\u0002T\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004B!!6\u0002^6\u0011\u0011q\u001b\u0006\u0005\u00033\fY.\u0001\u0003d_:4'BA%?\u0013\u0011\ty.a6\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0001(/\u001a9be\u00164uN],sSR,GcA7\u0002f\"9\u0011\u0011C\u0011A\u0002\u0005U\u0011!B<sSR,GcA7\u0002l\"1\u0011Q\u001e\u0012A\u00029\u000b1A]8x\u0003-9(/\u001b;f\r&,G\u000eZ:\u0015\u000f5\f\u00190!>\u0002x\"1\u0011Q^\u0012A\u00029CQ\u0001]\u0012A\u0002IDa!!?$\u0001\u0004y\u0018\u0001\u00044jK2$wK]5uKJ\u001c\u0018AC7bW\u0016<&/\u001b;feR!\u0011QAA\u0000\u0011\u001d\u0011\t\u0001\na\u0001\u0005\u0007\t\u0001\u0002Z1uCRK\b/\u001a\t\u0004g\n\u0015\u0011b\u0001B\u0004i\nAA)\u0019;b)f\u0004X-A\tnC.,G)Z2j[\u0006dwK]5uKJ$b!!\u0002\u0003\u000e\tE\u0001B\u0002B\bK\u0001\u0007!.A\u0005qe\u0016\u001c\u0017n]5p]\"1!1C\u0013A\u0002)\fQa]2bY\u0016\fq\"\\1lK\u0006\u0013(/Y=Xe&$XM\u001d\u000b\u0005\u0003\u000b\u0011I\u0002C\u0004\u0003\u001c\u0019\u0002\rA!\b\u0002\u0013\u0005\u0014(/Y=UsB,\u0007cA:\u0003 %\u0019!\u0011\u0005;\u0003\u0013\u0005\u0013(/Y=UsB,\u0017!D7bW\u0016l\u0015\r],sSR,'\u000f\u0006\u0003\u0002\u0006\t\u001d\u0002b\u0002B\u0015O\u0001\u0007!1F\u0001\b[\u0006\u0004H+\u001f9f!\r\u0019(QF\u0005\u0004\u0005_!(aB'baRK\b/Z\u0001\u000fG>t7/^7f\u001b\u0016\u001c8/Y4f)\ri'Q\u0007\u0005\t\u0005oAC\u00111\u0001\u0003:\u0005\ta\r\u0005\u0003`\u0005wi\u0017b\u0001B\u001fA\nAAHY=oC6,g(\u0001\u0007d_:\u001cX/\\3He>,\b\u000fF\u0002n\u0005\u0007B\u0001Ba\u000e*\t\u0003\u0007!\u0011H\u0001\rG>t7/^7f\r&,G\u000e\u001a\u000b\u0007\u0005\u0013\u0012iE!\u0019\u0015\u00075\u0014Y\u0005\u0003\u0005\u00038)\"\t\u0019\u0001B\u001d\u0011\u001d\u0011yE\u000ba\u0001\u0005#\nQAZ5fY\u0012\u0004BAa\u0015\u0003\\9!!Q\u000bB,!\r\t)\fY\u0005\u0004\u00053\u0002\u0017A\u0002)sK\u0012,g-\u0003\u0003\u0003^\t}#AB*ue&twMC\u0002\u0003Z\u0001DaAa\u0019+\u0001\u0004Q\u0017!B5oI\u0016D\u0018a\u0005)beF,X\r^,sSR,7+\u001e9q_J$\bC\u0001/-'\ra#1\u000e\t\u0004?\n5\u0014b\u0001B8A\n1\u0011I\\=SK\u001a$\"Aa\u001a\u0002!M\u0003\u0016IU&`%>;vlU\"I\u000b6\u000bUC\u0001B)\u0003E\u0019\u0006+\u0011*L?J{ukX*D\u0011\u0016k\u0015\tI\u0001\ng\u0016$8k\u00195f[\u0006$R!\u001cB?\u0005\u007fBQ\u0001\u001d\u0019A\u0002IDq!!51\u0001\u0004\t\u0019\u000e")
public class ParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void setSchema(StructType schema, Configuration configuration) {
        ParquetWriteSupport$.MODULE$.setSchema(schema, configuration);
    }

    public static String SPARK_ROW_SCHEMA() {
        return ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(PortableSQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(configuration.get(PortableSQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))));
        String key = PortableSQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(PortableSQLConf$ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((IterableOnceOps)((IterableOps)this.schema().map((Function1 & Serializable)x$6 -> x$6.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = (scala.collection.immutable.Map)((MapOps)((MapOps)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)schemaString)}))).$plus$plus((IterableOnce)(!(value != null ? !value.equals(value2) : value2 != null) ? (IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.SPARK_LEGACY_DATETIME_METADATA_KEY()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.SPARK_TIMEZONE_METADATA_KEY()), (Object)PortableSQLConf$.MODULE$.get().sessionLocalTimeZone())})) : Predef$.MODULE$.Map().empty()))).$plus$plus((IterableOnce)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? (IterableOnce)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.SPARK_LEGACY_INT96_METADATA_KEY()), (Object)""), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceUtils$.MODULE$.SPARK_TIMEZONE_METADATA_KEY()), (Object)PortableSQLConf$.MODULE$.get().sessionLocalTimeZone())})) : Predef$.MODULE$.Map().empty()));
        this.logInfo((Function0<String>)(Function0 & Serializable)() -> StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())));
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType2) {
        while (true) {
            DecimalType decimalType;
            Option option;
            DataType dataType3;
            if (BooleanType$.MODULE$.equals(dataType3 = dataType2)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ByteType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (ShortType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DateType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (IntegerType$.MODULE$.equals(dataType3) ? true : dataType3 instanceof YearMonthIntervalType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (LongType$.MODULE$.equals(dataType3) ? true : dataType3 instanceof DayTimeIntervalType) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (FloatType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (DoubleType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (StringType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (TimestampType$.MODULE$.equals(dataType3)) {
                Enumeration.Value value = this.outputTimestampType();
                Enumeration.Value value2 = PortableSQLConf$ParquetOutputTimestampType$.MODULE$.INT96();
                Enumeration.Value value3 = value;
                if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value4 = PortableSQLConf$ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                Enumeration.Value value5 = value;
                if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                Enumeration.Value value6 = PortableSQLConf$ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    return (Function2 & Serializable)(row, ordinal) -> {
                        ParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                }
                throw new MatchError((Object)value);
            }
            if (TimestampNTZType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (BinaryType$.MODULE$.equals(dataType3)) {
                return (Function2 & Serializable)(row, ordinal) -> {
                    ParquetWriteSupport.$anonfun$makeWriter$14(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType3)).isEmpty()) {
                int precision = ((Tuple2)option.get())._1$mcI$sp();
                int scale = ((Tuple2)option.get())._2$mcI$sp();
                return this.makeDecimalWriter(precision, scale);
            }
            if (dataType3 instanceof StructType) {
                StructType structType = (StructType)dataType3;
                Function2[] fieldWriters = (Function2[])((IterableOnceOps)((IterableOps)structType.map((Function1 & Serializable)x$8 -> x$8.dataType())).map((Function1 & Serializable)dataType -> this.makeWriter((DataType)dataType))).toArray(ClassTag$.MODULE$.apply(Function2.class));
                return (Function2 & Serializable)(row, ordinal) -> {
                    this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                    return BoxedUnit.UNIT;
                };
            }
            if (dataType3 instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)dataType3;
                return this.makeArrayWriter(arrayType);
            }
            if (dataType3 instanceof MapType) {
                MapType mapType = (MapType)dataType3;
                return this.makeMapWriter(mapType);
            }
            if (!(dataType3 instanceof UserDefinedType)) break;
            UserDefinedType userDefinedType = (UserDefinedType)dataType3;
            dataType2 = userDefinedType.sqlType();
        }
        throw new IllegalStateException(new StringBuilder(23).append("Unsupported data type ").append(dataType2).append(".").toString());
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable int32Writer = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable int64Writer = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (bl3 && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return binaryWriterUsingUnscaledLong;
        }
        return binaryWriterUsingUnscaledBytes;
    }

    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 != null) {
            boolean bl4 = sp2._1$mcZ$sp();
            boolean bl5 = sp2._2$mcZ$sp();
            if (bl4 && !bl5) {
                return this.twoLevelArrayWriter$1("array", elementWriter);
            }
        }
        throw new MatchError((Object)sp2);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        int julianDay2 = sp2._1$mcI$sp();
        long timeOfDayNanos2 = sp2._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = DateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$14(ParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(ParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(ParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)ArrayOps$.MODULE$.head$extension(Predef$.MODULE$.byteArrayOps(bytes))) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(ParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            if (!array.isNullAt(i$2.elem)) {
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(ParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (array.numElements() > 0) {
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
                return;
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable)(row, ordinal) -> {
            ParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(ParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
            if (map.numElements() > 0) {
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> {
                            $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            if (!map.valueArray().isNullAt(i$3.elem)) {
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                return;
                            }
                        });
                        ++i.elem;
                    }
                });
                return;
            }
        });
    }

    public ParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = LegacyBehaviorPolicy$.MODULE$.withName(PortableSQLConf$.MODULE$.get().getConf(PortableSQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.createDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = LegacyBehaviorPolicy$.MODULE$.withName(PortableSQLConf$.MODULE$.get().getConf(PortableSQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE()));
        this.int96RebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
    }
}

