/*
 * Decompiled with CFR 0.152.
 */
package org.twak.camp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.twak.camp.CoSitedCollision;
import org.twak.camp.CollisionQ;
import org.twak.camp.Corner;
import org.twak.camp.Edge;
import org.twak.camp.EdgeCollision;
import org.twak.camp.HeightCollision;
import org.twak.camp.HeightEvent;
import org.twak.camp.Output;
import org.twak.camp.SkeletonCapUpdate;
import org.twak.camp.Tag;
import org.twak.camp.debug.DebugDevice;
import org.twak.utils.Cache;
import org.twak.utils.collections.CloneConfirmIterator;
import org.twak.utils.collections.DHash;
import org.twak.utils.collections.Loop;
import org.twak.utils.collections.LoopL;
import org.twak.utils.collections.Loopable;
import org.twak.utils.collections.Loopz;
import org.twak.utils.collections.ManyManyMap;
import org.twak.utils.collections.MultiMap;
import org.twak.utils.collections.SetCorrespondence;
import org.twak.utils.geom.LinearForm3D;

public class Skeleton {
    public boolean preserveParallel = false;
    public boolean volumeMaximising = true;
    public Set<Corner> liveCorners = new LinkedHashSet<Corner>();
    public Set<Edge> liveEdges = new LinkedHashSet<Edge>();
    public CollisionQ qu;
    public double height = 0.0;
    public Set<EdgeCollision> seen = new LinkedHashSet<EdgeCollision>();
    public Output output = new Output(this);
    public List<CoSitedCollision> debugCollisionOrder = new ArrayList<CoSitedCollision>();
    public Map<Edge, Set<Tag>> planFeatures = new LinkedHashMap<Edge, Set<Tag>>();
    public String name = "?";
    boolean refindFaceEvents = true;
    private int edgeNearestNeighbors = Integer.MAX_VALUE;
    public DHash<Corner, Corner> cornerMap;
    public ManyManyMap<Corner, Corner> segmentMap;

    public Skeleton() {
    }

    public Skeleton(LoopL<Corner> corners) {
        this.setup(corners);
    }

    public Skeleton(LoopL<Edge> input, boolean javaGenericsAreABigPileOfShite) {
        this.setupForEdges(input);
    }

    public Skeleton(LoopL<Edge> input, int edgeNearestNeighbors) {
        this.edgeNearestNeighbors = edgeNearestNeighbors;
        this.setupForEdges(input);
    }

    public Skeleton(LoopL<Corner> input, double cap, boolean javaGenericsAreABigPileOfShite) {
        this.setup(input);
        this.capAt(cap);
    }

    public Skeleton(LoopL<Edge> input, double cap) {
        this.setupForEdges(input);
        this.capAt(cap);
    }

    public void setupForEdges(LoopL<Edge> input) {
        LoopL<Corner> corners = new LoopL<Corner>();
        for (Loop loop : input) {
            Loop<Corner> lc = new Loop<Corner>();
            corners.add((Corner)((Object)lc));
            for (Edge e : loop) {
                lc.append(e.start);
                e.start.nextL = e;
                e.end.prevL = e;
                e.start.nextC = e.end;
                e.end.prevC = e.start;
            }
        }
        this.setup(corners);
    }

    public void setup(LoopL<Corner> input) {
        this.height = 0.0;
        this.liveCorners.clear();
        this.liveEdges.clear();
        MultiMap<Edge, Corner> allEdges = new MultiMap<Edge, Corner>();
        for (Corner c : input.eIterator()) {
            allEdges.put(c.nextL, c);
        }
        for (Edge e : allEdges.keySet()) {
            e.currentCorners.clear();
            List corners = allEdges.get(e);
            Corner first = (Corner)corners.get(0);
            this.output.newEdge(first.nextL, null, new LinkedHashSet<Tag>());
            for (int i = 1; i < corners.size(); ++i) {
                this.output.merge(first, (Corner)corners.get(i));
            }
            this.liveEdges.add(e);
        }
        for (Corner c : input.eIterator()) {
            if (c.z != 0.0 || c.nextL == null || c.prevL == null) {
                throw new Error("Error in input");
            }
            this.output.newDefiningSegment(c);
            this.liveCorners.add(c);
            c.nextL.currentCorners.add(c);
            c.prevL.currentCorners.add(c);
        }
        this.qu = new CollisionQ(this, this.edgeNearestNeighbors);
        for (Edge e : allEdges.keySet()) {
            e.machine.addEdge(e, this);
        }
        this.refindFaceEventsIfNeeded();
    }

    public void skeleton() {
        HeightEvent he;
        this.validate();
        int i = 0;
        DebugDevice.dump("main " + String.format("%4d", ++i), this);
        while ((he = this.qu.poll()) != null) {
            try {
                if (he.process(this)) {
                    this.height = he.getHeight();
                    DebugDevice.dump("main " + this.height + " " + String.format("%4d", ++i), this);
                    this.validate();
                }
                this.refindFaceEventsIfNeeded();
            }
            catch (Throwable t) {
                t.printStackTrace();
                if (t.getCause() == null) continue;
                System.out.println(" caused by:");
                t.getCause().printStackTrace();
            }
        }
        DebugDevice.dump("after main " + String.format("%4d", ++i), this);
        this.output.calculate(this);
    }

    public LoopL<Corner> capCopy(double height) {
        this.segmentMap = new ManyManyMap();
        this.cornerMap = new DHash();
        LinearForm3D ceiling = new LinearForm3D(0.0, 0.0, 1.0, -height);
        for (Corner c : this.liveCorners) {
            try {
                Tuple3d t;
                if (height == c.z) {
                    t = new Point3d(c);
                } else if (this.preserveParallel && c.prevL.isParallel(c.nextL)) {
                    Vector3d d = c.nextL.direction();
                    d.normalize(d);
                    LinearForm3D parallel = new LinearForm3D(d, c);
                    t = ceiling.collide(c.prevL.linearForm, parallel);
                } else {
                    t = ceiling.collide(c.prevL.linearForm, c.nextL.linearForm);
                }
                this.cornerMap.put(new Corner(t), c);
            }
            catch (RuntimeException e) {
                this.cornerMap.put(new Corner(c.x, c.y, height), c);
            }
        }
        Cache<Corner, Edge> edgeCache = new Cache<Corner, Edge>(){
            Map<Edge, Edge> lowToHighEdge = new HashMap<Edge, Edge>();

            @Override
            public Edge create(Corner i) {
                Edge edge = new Edge(Skeleton.this.cornerMap.teg(i), Skeleton.this.cornerMap.teg(i.nextC));
                this.lowToHighEdge.put(i.nextL, edge);
                edge.setAngle(i.nextL.getAngle());
                edge.machine = i.nextL.machine;
                return edge;
            }
        };
        LoopL<Corner> out = new LoopL<Corner>();
        LinkedHashSet<Corner> workingSet = new LinkedHashSet<Corner>(this.liveCorners);
        while (!workingSet.isEmpty()) {
            Loop<Corner> loop = new Loop<Corner>();
            out.add((Corner)((Object)loop));
            Corner current = (Corner)workingSet.iterator().next();
            do {
                Corner s2 = this.cornerMap.teg(current);
                Corner e = this.cornerMap.teg(current.nextC);
                this.segmentMap.addForwards(current, s2);
                Edge edge = (Edge)edgeCache.get(current);
                loop.append(s2);
                s2.nextC = e;
                e.prevC = s2;
                s2.nextL = edge;
                e.prevL = edge;
                workingSet.remove(current);
            } while (workingSet.contains(current = current.nextC));
        }
        return out;
    }

    public Cache<Corner, Collection<Corner>> getSegmentOriginator() {
        return this.output.getSegmentOriginator();
    }

    public void parent(Output.Face child, Output.Face parent) {
    }

    public void capAt(double cap) {
        this.capAt(cap, null);
    }

    public void capAt(final double cap, final HeresTheArea hta) {
        this.qu.add(new HeightEvent(){

            @Override
            public double getHeight() {
                return cap;
            }

            @Override
            public boolean process(Skeleton skel) {
                SkeletonCapUpdate capUpdate = new SkeletonCapUpdate(skel);
                LoopL<Corner> flatTop = capUpdate.getCap(cap);
                capUpdate.update(new LoopL<Corner>(), new SetCorrespondence<Corner, Corner>(), new DHash<Corner, Corner>());
                LoopL<Point3d> togo = new LoopL.Map<Point3d>(flatTop){

                    @Override
                    public Point3d map(Loopable<Corner> input) {
                        return new Point3d(input.get().x, input.get().y, input.get().z);
                    }
                }.run();
                skel.output.addNonSkeletonOutputFace(togo, new Vector3d(0.0, 0.0, 1.0));
                if (hta != null) {
                    hta.heresTheArea(Loopz.area3(togo));
                }
                DebugDevice.dump("post cap dump", skel);
                skel.qu.clearFaceEvents();
                skel.qu.clearOtherEvents();
                return true;
            }
        });
    }

    public void refindAllFaceEventsLater() {
        this.refindFaceEvents = true;
    }

    private void refindFaceEventsIfNeeded() {
        if (!this.refindFaceEvents) {
            return;
        }
        HeightCollision context = new HeightCollision();
        for (Corner lc : new CloneConfirmIterator<Corner>(this.liveCorners)) {
            this.qu.addCorner(lc, context, true);
        }
        context.processHoriz(this);
        this.refindFaceEvents = false;
    }

    public void validate() {
    }

    public void setPlanTags(Edge edge, Set<Tag> features) {
        this.planFeatures.put(edge, features);
    }

    public Set<Tag> getPlanTags(Edge originator) {
        return this.planFeatures.get(originator);
    }

    public Comparator<Edge> getHorizontalComparator() {
        return new Comparator<Edge>(){

            @Override
            public int compare(Edge o1, Edge o2) {
                if (Skeleton.this.volumeMaximising) {
                    return Double.compare(o1.getAngle(), o2.getAngle());
                }
                return Double.compare(o2.getAngle(), o1.getAngle());
            }
        };
    }

    public LoopL<Corner> findLoopLive() {
        LoopL<Corner> out = new LoopL<Corner>();
        HashSet<Corner> togo = new HashSet<Corner>(this.liveCorners);
        while (!togo.isEmpty()) {
            Corner start;
            Loop<Corner> loop = new Loop<Corner>();
            out.add((Corner)((Object)loop));
            Corner current = start = (Corner)togo.iterator().next();
            int handbrake = 0;
            do {
                togo.remove(current);
                loop.append(current);
            } while ((current = current.nextC) != start && handbrake++ < 1000);
            if (handbrake < 1000) continue;
            System.err.println("broken loops in findLiveLoop");
            Thread.dumpStack();
        }
        return out;
    }

    public static interface HeresTheArea {
        public void heresTheArea(double var1);
    }

    public static class SEC {
        Corner start;
        Corner end;
        Edge nextL;
        Edge edge;
        Edge prevL;

        public SEC(Corner start, Edge edge) {
            this.start = start;
            this.end = start.nextC;
            this.prevL = start.prevL;
            this.nextL = this.end.nextL;
            this.edge = edge;
        }
    }
}

