/*
 * Decompiled with CFR 0.152.
 */
package io.openmessaging.storage.dledger.snapshot;

import java.util.HashMap;
import java.util.Map;

public enum SnapshotStatus {
    UNKNOWN(-1),
    SUCCESS(0),
    FAIL(10001),
    EXPIRED(10002);

    private static Map<Integer, SnapshotStatus> codeMap;
    private int code;

    private SnapshotStatus(int code) {
        this.code = code;
    }

    public static SnapshotStatus valueOf(int code) {
        SnapshotStatus tmp = codeMap.get(code);
        if (tmp != null) {
            return tmp;
        }
        return UNKNOWN;
    }

    public int getCode() {
        return this.code;
    }

    static {
        codeMap = new HashMap<Integer, SnapshotStatus>();
        for (SnapshotStatus status : SnapshotStatus.values()) {
            codeMap.put(status.code, status);
        }
    }
}

