/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store.queue;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.store.DispatchRequest;
import org.apache.rocketmq.store.config.MessageStoreConfig;

public class MultiDispatchUtils {
    public static String lmqQueueKey(String queueName) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(queueName);
        keyBuilder.append('-');
        int queueId = 0;
        keyBuilder.append(queueId);
        return keyBuilder.toString();
    }

    public static boolean isNeedHandleMultiDispatch(MessageStoreConfig messageStoreConfig, String topic) {
        return messageStoreConfig.isEnableMultiDispatch() && !topic.startsWith("%RETRY%") && !topic.startsWith("rmq_sys_") && !topic.equals("SCHEDULE_TOPIC_XXXX");
    }

    public static boolean checkMultiDispatchQueue(MessageStoreConfig messageStoreConfig, DispatchRequest dispatchRequest) {
        if (!MultiDispatchUtils.isNeedHandleMultiDispatch(messageStoreConfig, dispatchRequest.getTopic())) {
            return false;
        }
        Map<String, String> prop = dispatchRequest.getPropertiesMap();
        if (prop == null || prop.isEmpty()) {
            return false;
        }
        String multiDispatchQueue = prop.get("INNER_MULTI_DISPATCH");
        String multiQueueOffset = prop.get("INNER_MULTI_QUEUE_OFFSET");
        return !StringUtils.isBlank((CharSequence)multiDispatchQueue) && !StringUtils.isBlank((CharSequence)multiQueueOffset);
    }
}

