/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.mledger.impl;

import java.util.Optional;
import lombok.Generated;
import org.apache.bookkeeper.mledger.Position;
import org.apache.bookkeeper.mledger.impl.AckSetPositionImpl;
import org.apache.bookkeeper.mledger.impl.AckSetState;

public final class AckSetStateUtil {
    public static Position createPositionWithAckSet(long ledgerId, long entryId, long[] ackSet) {
        return new AckSetPositionImpl(ledgerId, entryId, ackSet);
    }

    public static Optional<AckSetState> maybeGetAckSetState(Position position) {
        return position.getExtension(AckSetState.class);
    }

    public static long[] getAckSetArrayOrNull(Position position) {
        return AckSetStateUtil.maybeGetAckSetState(position).map(AckSetState::getAckSet).orElse(null);
    }

    public static AckSetState getAckSetState(Position position) {
        return AckSetStateUtil.maybeGetAckSetState(position).orElseThrow(() -> new IllegalStateException("Position does not have AckSetState. position=" + String.valueOf(position)));
    }

    public static boolean hasAckSet(Position position) {
        return AckSetStateUtil.maybeGetAckSetState(position).map(AckSetState::hasAckSet).orElse(false);
    }

    @Generated
    private AckSetStateUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

