/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.utils.auth.tokens;

import com.google.common.annotations.VisibleForTesting;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.Encoders;
import io.jsonwebtoken.security.Keys;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyPair;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.crypto.SecretKey;
import org.apache.pulsar.broker.authentication.utils.AuthTokenUtils;
import org.apache.pulsar.cli.converters.picocli.TimeUnitToMillisConverter;
import org.apache.pulsar.docs.tools.CmdGenerateDocs;
import picocli.CommandLine;

@CommandLine.Command(name="tokens", showDefaultValues=true, scope=CommandLine.ScopeType.INHERIT)
public class TokensCliUtils {
    private final CommandLine commander = new CommandLine((Object)this);
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, description={"Show this help message"})
    private boolean help;

    TokensCliUtils() {
        this.commander.addSubcommand("create-secret-key", CommandCreateSecretKey.class);
        this.commander.addSubcommand("create-key-pair", CommandCreateKeyPair.class);
        this.commander.addSubcommand("create", CommandCreateToken.class);
        this.commander.addSubcommand("show", CommandShowToken.class);
        this.commander.addSubcommand("validate", CommandValidateToken.class);
        this.commander.addSubcommand("gen-doc", (Object)new GenDoc(this.commander));
    }

    @VisibleForTesting
    int execute(String[] args) {
        return this.commander.execute(args);
    }

    public static void main(String[] args) throws Exception {
        TokensCliUtils tokensCliUtils = new TokensCliUtils();
        System.exit(tokensCliUtils.execute(args));
    }

    @CommandLine.Command(description={"Create a new secret key"})
    public static class CommandCreateSecretKey
    implements Callable<Integer> {
        @CommandLine.Option(names={"-a", "--signature-algorithm"}, description={"The signature algorithm for the new secret key."})
        SignatureAlgorithm algorithm = SignatureAlgorithm.HS256;
        @CommandLine.Option(names={"-o", "--output"}, description={"Write the secret key to a file instead of stdout"})
        String outputFile;
        @CommandLine.Option(names={"-b", "--base64"}, description={"Encode the key in base64"})
        boolean base64 = false;

        @Override
        public Integer call() throws Exception {
            SecretKey secretKey = AuthTokenUtils.createSecretKey((SignatureAlgorithm)this.algorithm);
            byte[] encoded = secretKey.getEncoded();
            if (this.base64) {
                encoded = ((String)Encoders.BASE64.encode((Object)encoded)).getBytes();
            }
            if (this.outputFile != null) {
                Files.write(Paths.get(this.outputFile, new String[0]), encoded, new OpenOption[0]);
            } else {
                System.out.write(encoded);
            }
            return 0;
        }
    }

    @CommandLine.Command(description={"Create a new or pair of keys public/private"})
    public static class CommandCreateKeyPair
    implements Callable<Integer> {
        @CommandLine.Option(names={"-a", "--signature-algorithm"}, description={"The signature algorithm for the new key pair."})
        SignatureAlgorithm algorithm = SignatureAlgorithm.RS256;
        @CommandLine.Option(names={"--output-private-key"}, description={"File where to write the private key"}, required=true)
        String privateKeyFile;
        @CommandLine.Option(names={"--output-public-key"}, description={"File where to write the public key"}, required=true)
        String publicKeyFile;

        @Override
        public Integer call() throws Exception {
            KeyPair pair = Keys.keyPairFor((SignatureAlgorithm)this.algorithm);
            Files.write(Paths.get(this.publicKeyFile, new String[0]), pair.getPublic().getEncoded(), new OpenOption[0]);
            Files.write(Paths.get(this.privateKeyFile, new String[0]), pair.getPrivate().getEncoded(), new OpenOption[0]);
            return 0;
        }
    }

    @CommandLine.Command(description={"Create a new token"})
    public static class CommandCreateToken
    implements Callable<Integer> {
        @CommandLine.Option(names={"-a", "--signature-algorithm"}, description={"The signature algorithm for the new key pair."})
        SignatureAlgorithm algorithm = SignatureAlgorithm.RS256;
        @CommandLine.Option(names={"-s", "--subject"}, description={"Specify the 'subject' or 'principal' associate with this token"}, required=true)
        private String subject;
        @CommandLine.Option(names={"-e", "--expiry-time"}, description={"Relative expiry time for the token (eg: 1h, 3d, 10y). (m=minutes) Default: no expiration"}, converter={TimeUnitToMillisConverter.class})
        private Long expiryTime = null;
        @CommandLine.Option(names={"-sk", "--secret-key"}, description={"Pass the secret key for signing the token. This can either be: data:, file:, etc.."})
        private String secretKey;
        @CommandLine.Option(names={"-pk", "--private-key"}, description={"Pass the private key for signing the token. This can either be: data:, file:, etc.."})
        private String privateKey;
        @CommandLine.Option(names={"-hs", "--headers"}, description={"Additional headers to token. Format: --headers key1=value1"})
        private Map<String, Object> headers;

        @Override
        public Integer call() throws Exception {
            Key signingKey;
            if (this.secretKey == null && this.privateKey == null) {
                System.err.println("Either --secret-key or --private-key needs to be passed for signing a token");
                return 1;
            }
            if (this.secretKey != null && this.privateKey != null) {
                System.err.println("Only one of --secret-key and --private-key needs to be passed for signing a token");
                return 1;
            }
            if (this.privateKey != null) {
                encodedKey = AuthTokenUtils.readKeyFromUrl((String)this.privateKey);
                signingKey = AuthTokenUtils.decodePrivateKey((byte[])encodedKey, (SignatureAlgorithm)this.algorithm);
            } else {
                encodedKey = AuthTokenUtils.readKeyFromUrl((String)this.secretKey);
                signingKey = AuthTokenUtils.decodeSecretKey((byte[])encodedKey);
            }
            Optional optExpiryTime = this.expiryTime == null ? Optional.empty() : Optional.of(new Date(System.currentTimeMillis() + this.expiryTime));
            String token = AuthTokenUtils.createToken((Key)signingKey, (String)this.subject, optExpiryTime, Optional.ofNullable(this.headers));
            System.out.println(token);
            return 0;
        }
    }

    @CommandLine.Command(description={"Show the content of token"})
    public static class CommandShowToken
    implements Callable<Integer> {
        @CommandLine.Parameters(description={"The token string"}, arity="0..1")
        private String args;
        @CommandLine.Option(names={"-i", "--stdin"}, description={"Read token from standard input"})
        private Boolean stdin = false;
        @CommandLine.Option(names={"-f", "--token-file"}, description={"Read token from a file"})
        private String tokenFile;

        @Override
        public Integer call() throws Exception {
            String token;
            if (this.args != null) {
                token = this.args;
            } else if (this.stdin.booleanValue()) {
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                try {
                    token = r.readLine();
                }
                finally {
                    if (Collections.singletonList(r).get(0) != null) {
                        r.close();
                    }
                }
            } else if (this.tokenFile != null) {
                token = new String(Files.readAllBytes(Paths.get(this.tokenFile, new String[0])), StandardCharsets.UTF_8);
            } else if (System.getenv("TOKEN") != null) {
                token = System.getenv("TOKEN");
            } else {
                System.err.println("Token needs to be either passed as an argument or through `--stdin`, `--token-file` or by the `TOKEN` environment variable");
                return 1;
            }
            String[] parts = token.split("\\.");
            System.out.println(new String((byte[])Decoders.BASE64URL.decode((Object)parts[0])));
            System.out.println("---");
            System.out.println(new String((byte[])Decoders.BASE64URL.decode((Object)parts[1])));
            return 0;
        }
    }

    @CommandLine.Command(description={"Validate a token against a key"})
    public static class CommandValidateToken
    implements Callable<Integer> {
        @CommandLine.Option(names={"-a", "--signature-algorithm"}, description={"The signature algorithm for the key pair if using public key."})
        SignatureAlgorithm algorithm = SignatureAlgorithm.RS256;
        @CommandLine.Parameters(description={"The token string"}, arity="0..1")
        private String args;
        @CommandLine.Option(names={"-i", "--stdin"}, description={"Read token from standard input"})
        private Boolean stdin = false;
        @CommandLine.Option(names={"-f", "--token-file"}, description={"Read token from a file"})
        private String tokenFile;
        @CommandLine.Option(names={"-sk", "--secret-key"}, description={"Pass the secret key for validating the token. This can either be: data:, file:, etc.."})
        private String secretKey;
        @CommandLine.Option(names={"-pk", "--public-key"}, description={"Pass the public key for validating the token. This can either be: data:, file:, etc.."})
        private String publicKey;

        @Override
        public Integer call() throws Exception {
            Key validationKey;
            String token;
            if (this.secretKey == null && this.publicKey == null) {
                System.err.println("Either --secret-key or --public-key needs to be passed for signing a token");
                return 1;
            }
            if (this.secretKey != null && this.publicKey != null) {
                System.err.println("Only one of --secret-key and --public-key needs to be passed for signing a token");
                return 1;
            }
            if (this.args != null) {
                token = this.args;
            } else if (this.stdin.booleanValue()) {
                BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                try {
                    token = r.readLine();
                }
                finally {
                    if (Collections.singletonList(r).get(0) != null) {
                        r.close();
                    }
                }
            } else if (this.tokenFile != null) {
                token = new String(Files.readAllBytes(Paths.get(this.tokenFile, new String[0])), StandardCharsets.UTF_8);
            } else if (System.getenv("TOKEN") != null) {
                token = System.getenv("TOKEN");
            } else {
                System.err.println("Token needs to be either passed as an argument or through `--stdin`, `--token-file` or by the `TOKEN` environment variable");
                return 1;
            }
            if (this.publicKey != null) {
                encodedKey = AuthTokenUtils.readKeyFromUrl((String)this.publicKey);
                validationKey = AuthTokenUtils.decodePublicKey((byte[])encodedKey, (SignatureAlgorithm)this.algorithm);
            } else {
                encodedKey = AuthTokenUtils.readKeyFromUrl((String)this.secretKey);
                validationKey = AuthTokenUtils.decodeSecretKey((byte[])encodedKey);
            }
            Jws jwt = Jwts.parserBuilder().setSigningKey(validationKey).build().parseClaimsJws(token);
            System.out.println(jwt.getBody());
            return 0;
        }
    }

    @CommandLine.Command
    static class GenDoc
    implements Callable<Integer> {
        private final CommandLine rootCmd;

        public GenDoc(CommandLine rootCmd) {
            this.rootCmd = rootCmd;
        }

        @Override
        public Integer call() throws Exception {
            CmdGenerateDocs genDocCmd = new CmdGenerateDocs("pulsar");
            genDocCmd.addCommand("tokens", (Object)this.rootCmd);
            genDocCmd.run(null);
            return 0;
        }
    }
}

