/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import javax.websocket.EncodeException;
import javax.websocket.Encoder;
import javax.websocket.RemoteEndpoint;
import javax.websocket.SendHandler;
import javax.websocket.SendResult;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.common.WebSocketFrame;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.frames.BinaryFrame;
import org.eclipse.jetty.websocket.common.frames.TextFrame;
import org.eclipse.jetty.websocket.common.message.MessageOutputStream;
import org.eclipse.jetty.websocket.common.message.MessageWriter;
import org.eclipse.jetty.websocket.common.util.TextUtil;
import org.eclipse.jetty.websocket.jsr356.AbstractJsrRemote;
import org.eclipse.jetty.websocket.jsr356.JsrSession;
import org.eclipse.jetty.websocket.jsr356.messages.SendHandlerWriteCallback;

public class JsrAsyncRemote
extends AbstractJsrRemote
implements RemoteEndpoint.Async {
    static final Logger LOG = Log.getLogger(JsrAsyncRemote.class);

    protected JsrAsyncRemote(JsrSession session) {
        super(session);
    }

    public long getSendTimeout() {
        return 0L;
    }

    public Future<Void> sendBinary(ByteBuffer data) {
        this.assertMessageNotNull(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data)});
        }
        return this.jettyRemote.sendBytesByFuture(data);
    }

    public void sendBinary(ByteBuffer data, SendHandler handler) {
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendBinary({},{})", new Object[]{BufferUtil.toDetailString((ByteBuffer)data), handler});
        }
        WebSocketFrame frame = new BinaryFrame().setPayload(data).setFin(true);
        this.jettyRemote.uncheckedSendFrame(frame, (WriteCallback)new SendHandlerWriteCallback(handler));
    }

    public Future<Void> sendObject(Object data) {
        return this.sendObjectViaFuture(data);
    }

    public void sendObject(Object data, SendHandler handler) {
        Encoder encoder;
        this.assertMessageNotNull(data);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendObject({},{})", new Object[]{data, handler});
        }
        if ((encoder = this.encoders.getEncoderFor(data.getClass())) == null) {
            throw new IllegalArgumentException("No encoder for type: " + data.getClass());
        }
        if (encoder instanceof Encoder.Text) {
            Encoder.Text etxt = (Encoder.Text)encoder;
            try {
                String msg = etxt.encode(data);
                this.sendText(msg, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult((Throwable)e));
            }
        } else if (encoder instanceof Encoder.TextStream) {
            Encoder.TextStream etxt = (Encoder.TextStream)encoder;
            SendHandlerWriteCallback callback = new SendHandlerWriteCallback(handler);
            try (MessageWriter writer = new MessageWriter((WebSocketSession)this.session);){
                writer.setCallback((WriteCallback)callback);
                etxt.encode(data, (Writer)writer);
                return;
            }
            catch (IOException | EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        } else if (encoder instanceof Encoder.Binary) {
            Encoder.Binary ebin = (Encoder.Binary)encoder;
            try {
                ByteBuffer buf = ebin.encode(data);
                this.sendBinary(buf, handler);
                return;
            }
            catch (EncodeException e) {
                handler.onResult(new SendResult((Throwable)e));
            }
        } else if (encoder instanceof Encoder.BinaryStream) {
            Encoder.BinaryStream ebin = (Encoder.BinaryStream)encoder;
            SendHandlerWriteCallback callback = new SendHandlerWriteCallback(handler);
            try (MessageOutputStream out = new MessageOutputStream((WebSocketSession)this.session);){
                out.setCallback((WriteCallback)callback);
                ebin.encode(data, (OutputStream)out);
                return;
            }
            catch (IOException | EncodeException e) {
                handler.onResult(new SendResult(e));
            }
        }
        throw new IllegalArgumentException("Unknown encoder type: " + encoder);
    }

    public Future<Void> sendText(String text) {
        this.assertMessageNotNull(text);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({})", new Object[]{TextUtil.hint((String)text)});
        }
        return this.jettyRemote.sendStringByFuture(text);
    }

    public void sendText(String text, SendHandler handler) {
        this.assertMessageNotNull(text);
        this.assertSendHandlerNotNull(handler);
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendText({},{})", new Object[]{TextUtil.hint((String)text), handler});
        }
        WebSocketFrame frame = new TextFrame().setPayload(text).setFin(true);
        this.jettyRemote.uncheckedSendFrame(frame, (WriteCallback)new SendHandlerWriteCallback(handler));
    }

    public void setSendTimeout(long timeoutmillis) {
    }
}

