/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.pulsar.broker.service.ServerCnx;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServerCnxThrottleTracker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerCnxThrottleTracker.class);
    private final ServerCnx serverCnx;
    private final int[] states = new int[ThrottleType.values().length];

    private boolean hasThrottled() {
        for (int stat : this.states) {
            if (stat <= 0) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    public int throttledCount() {
        int i = 0;
        for (int stat : this.states) {
            i += stat;
        }
        return i;
    }

    public void markThrottled(ThrottleType type) {
        assert (this.serverCnx.ctx().executor().inEventLoop()) : "This method should be called in serverCnx.ctx().executor()";
        ThrottleRes res = this.doMarkThrottled(type);
        this.recordMetricsAfterThrottling(type, res);
        if (res == ThrottleRes.ConnectionStateChanged && this.isChannelActive()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Setting auto read to false", (Object)this.serverCnx.toString());
            }
            this.serverCnx.ctx().channel().config().setAutoRead(false);
        }
    }

    public void unmarkThrottled(ThrottleType type) {
        assert (this.serverCnx.ctx().executor().inEventLoop()) : "This method should be called in serverCnx.ctx().executor()";
        ThrottleRes res = this.doUnmarkThrottled(type);
        this.recordMetricsAfterUnthrottling(type, res);
        if (res == ThrottleRes.ConnectionStateChanged && this.isChannelActive()) {
            if (log.isDebugEnabled()) {
                log.debug("[{}] Setting auto read to true", (Object)this.serverCnx.toString());
            }
            this.serverCnx.ctx().channel().config().setAutoRead(true);
        }
    }

    private ThrottleRes doMarkThrottled(ThrottleType throttleType) {
        boolean throttled = this.hasThrottled();
        int value = this.states[throttleType.ordinal()];
        if (throttleType.isReentrant()) {
            this.states[throttleType.ordinal()] = value + 1;
        } else {
            this.states[throttleType.ordinal()] = 1;
            if (value != 0) {
                return ThrottleRes.Dropped;
            }
        }
        return throttled ? ThrottleRes.TypeStateChanged : ThrottleRes.ConnectionStateChanged;
    }

    private ThrottleRes doUnmarkThrottled(ThrottleType throttleType) {
        int value = this.states[throttleType.ordinal()];
        if (throttleType.isReentrant()) {
            this.states[throttleType.ordinal()] = value - 1;
        } else {
            if (value != 1) {
                return ThrottleRes.Dropped;
            }
            this.states[throttleType.ordinal()] = 0;
        }
        return this.hasThrottled() ? ThrottleRes.TypeStateChanged : ThrottleRes.ConnectionStateChanged;
    }

    private void recordMetricsAfterThrottling(ThrottleType type, ThrottleRes res) {
        if (type == ThrottleType.ConnectionMaxPendingPublishRequestsExceeded && res != ThrottleRes.Dropped) {
            this.serverCnx.getBrokerService().recordConnectionThrottled();
        }
        if (res == ThrottleRes.ConnectionStateChanged && this.isChannelActive()) {
            this.serverCnx.increasePublishLimitedTimesForTopics();
            this.serverCnx.getBrokerService().recordConnectionPaused();
        }
    }

    private void recordMetricsAfterUnthrottling(ThrottleType type, ThrottleRes res) {
        if (type == ThrottleType.ConnectionMaxPendingPublishRequestsExceeded && res != ThrottleRes.Dropped) {
            this.serverCnx.getBrokerService().recordConnectionUnthrottled();
        }
        if (res == ThrottleRes.ConnectionStateChanged && this.isChannelActive()) {
            this.serverCnx.getBrokerService().recordConnectionResumed();
        }
    }

    public ServerCnxThrottleTracker(ServerCnx serverCnx) {
        this.serverCnx = serverCnx;
    }

    private boolean isChannelActive() {
        return this.serverCnx.isActive() && this.serverCnx.ctx() != null && this.serverCnx.ctx().channel().isActive();
    }

    public static enum ThrottleType {
        ConnectionMaxPendingPublishRequestsExceeded(false),
        IOThreadMaxPendingPublishBytesExceeded(false),
        TopicPublishRate(true),
        ResourceGroupPublishRate(true),
        BrokerPublishRate(false),
        ConnectionOutboundBufferFull(false),
        ConnectionPauseReceivingCooldownRateLimit(false);

        final boolean reentrant;

        private ThrottleType(boolean reentrant) {
            this.reentrant = reentrant;
        }

        @Generated
        public boolean isReentrant() {
            return this.reentrant;
        }
    }

    static enum ThrottleRes {
        ConnectionStateChanged,
        TypeStateChanged,
        Dropped;

    }
}

