/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import io.trino.spi.connector.ColumnHandle;
import java.util.Map;
import java.util.Objects;

public final class JoinApplicationResult<T> {
    private final T tableHandle;
    private final Map<ColumnHandle, ColumnHandle> leftColumnHandles;
    private final Map<ColumnHandle, ColumnHandle> rightColumnHandles;
    private final boolean precalculateStatistics;

    public JoinApplicationResult(T tableHandle, Map<ColumnHandle, ColumnHandle> leftColumnHandles, Map<ColumnHandle, ColumnHandle> rightColumnHandles, boolean precalculateStatistics) {
        this.tableHandle = Objects.requireNonNull(tableHandle, "tableHandle is null");
        this.leftColumnHandles = Map.copyOf(leftColumnHandles);
        this.rightColumnHandles = Map.copyOf(rightColumnHandles);
        this.precalculateStatistics = precalculateStatistics;
    }

    public T getTableHandle() {
        return this.tableHandle;
    }

    public Map<ColumnHandle, ColumnHandle> getLeftColumnHandles() {
        return this.leftColumnHandles;
    }

    public Map<ColumnHandle, ColumnHandle> getRightColumnHandles() {
        return this.rightColumnHandles;
    }

    public boolean isPrecalculateStatistics() {
        return this.precalculateStatistics;
    }
}

