/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SliceInput;
import io.airlift.slice.SliceOutput;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockEncoding;
import io.trino.spi.block.BlockEncodingSerde;
import io.trino.spi.block.SingleRowBlock;

public class SingleRowBlockEncoding
implements BlockEncoding {
    public static final String NAME = "ROW_ELEMENT";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        SingleRowBlock singleRowBlock = (SingleRowBlock)block;
        int numFields = singleRowBlock.getNumFields();
        int rowIndex = singleRowBlock.getRowIndex();
        sliceOutput.appendInt(numFields);
        for (int i = 0; i < numFields; ++i) {
            blockEncodingSerde.writeBlock(sliceOutput, singleRowBlock.getRawFieldBlock(i).getRegion(rowIndex, 1));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int numFields = sliceInput.readInt();
        Block[] fieldBlocks = new Block[numFields];
        for (int i = 0; i < fieldBlocks.length; ++i) {
            fieldBlocks[i] = blockEncodingSerde.readBlock(sliceInput);
        }
        return new SingleRowBlock(0, fieldBlocks);
    }
}

