/*
 * Decompiled with CFR 0.152.
 */
package io.trino.testing.assertions;

import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Location;
import io.trino.spi.TrinoException;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.util.CheckReturnValue;

public final class TrinoExceptionAssert
extends AbstractThrowableAssert<TrinoExceptionAssert, TrinoException> {
    @CheckReturnValue
    public static TrinoExceptionAssert assertTrinoExceptionThrownBy(ThrowableAssert.ThrowingCallable throwingCallable) {
        Throwable throwable = Assertions.catchThrowable((ThrowableAssert.ThrowingCallable)throwingCallable);
        if (throwable == null) {
            Assertions.failBecauseExceptionWasNotThrown(TrinoException.class);
        }
        Assertions.assertThat((Throwable)throwable).isInstanceOf(TrinoException.class);
        return new TrinoExceptionAssert((TrinoException)throwable);
    }

    private TrinoExceptionAssert(TrinoException actual) {
        super((Throwable)actual, TrinoExceptionAssert.class);
    }

    public TrinoExceptionAssert hasErrorCode(ErrorCodeSupplier errorCodeSupplier) {
        try {
            Assertions.assertThat((Object)((TrinoException)((Object)this.actual)).getErrorCode()).isEqualTo((Object)errorCodeSupplier.toErrorCode());
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (TrinoExceptionAssert)this.myself;
    }

    public TrinoExceptionAssert hasLocation(int lineNumber, int columnNumber) {
        try {
            Assertions.assertThat((Optional)((TrinoException)((Object)this.actual)).getLocation()).isPresent();
            Assertions.assertThat((Object)((Location)((TrinoException)((Object)this.actual)).getLocation().get())).matches(location -> location.getColumnNumber() == columnNumber && location.getLineNumber() == lineNumber);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).addSuppressed((Throwable)this.actual);
            throw e;
        }
        return (TrinoExceptionAssert)this.myself;
    }
}

