/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.sql.ExpressionUtils;
import io.trino.sql.planner.DeterminismEvaluator;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.FilterNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.tree.BooleanLiteral;
import io.trino.sql.tree.Cast;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.IfExpression;
import io.trino.sql.tree.IsNullPredicate;
import io.trino.sql.tree.LogicalExpression;
import io.trino.sql.tree.NotExpression;
import io.trino.sql.tree.NullIfExpression;
import io.trino.sql.tree.NullLiteral;
import io.trino.sql.tree.SearchedCaseExpression;
import io.trino.sql.tree.SimpleCaseExpression;
import io.trino.sql.tree.WhenClause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public class SimplifyFilterPredicate
implements Rule<FilterNode> {
    private static final Pattern<FilterNode> PATTERN = Patterns.filter();
    private final Metadata metadata;

    public SimplifyFilterPredicate(Metadata metadata) {
        this.metadata = metadata;
    }

    @Override
    public Pattern<FilterNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(FilterNode node, Captures captures, Rule.Context context) {
        List<Expression> conjuncts = ExpressionUtils.extractConjuncts(node.getPredicate());
        ImmutableList.Builder newConjuncts = ImmutableList.builder();
        boolean simplified = false;
        for (Expression conjunct : conjuncts) {
            Optional<Expression> simplifiedConjunct = this.simplifyFilterExpression(conjunct);
            if (simplifiedConjunct.isPresent()) {
                simplified = true;
                newConjuncts.add((Object)simplifiedConjunct.get());
                continue;
            }
            newConjuncts.add((Object)conjunct);
        }
        if (!simplified) {
            return Rule.Result.empty();
        }
        return Rule.Result.ofPlanNode(new FilterNode(node.getId(), node.getSource(), ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)newConjuncts.build())));
    }

    private Optional<Expression> simplifyFilterExpression(Expression expression) {
        if (expression instanceof IfExpression) {
            IfExpression ifExpression = (IfExpression)expression;
            Expression condition = ifExpression.getCondition();
            Expression trueValue = ifExpression.getTrueValue();
            Optional falseValue = ifExpression.getFalseValue();
            if (trueValue.equals((Object)BooleanLiteral.TRUE_LITERAL) && (falseValue.isEmpty() || SimplifyFilterPredicate.isNotTrue((Expression)falseValue.get()))) {
                return Optional.of(condition);
            }
            if (SimplifyFilterPredicate.isNotTrue(trueValue) && falseValue.isPresent() && ((Expression)falseValue.get()).equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(SimplifyFilterPredicate.isFalseOrNullPredicate(condition));
            }
            if (falseValue.isPresent() && ((Expression)falseValue.get()).equals((Object)trueValue) && DeterminismEvaluator.isDeterministic(trueValue, this.metadata)) {
                return Optional.of(trueValue);
            }
            if (SimplifyFilterPredicate.isNotTrue(trueValue) && (falseValue.isEmpty() || SimplifyFilterPredicate.isNotTrue((Expression)falseValue.get()))) {
                return Optional.of(BooleanLiteral.FALSE_LITERAL);
            }
            if (condition.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(trueValue);
            }
            if (SimplifyFilterPredicate.isNotTrue(condition)) {
                return Optional.of((Expression)falseValue.orElse(BooleanLiteral.FALSE_LITERAL));
            }
            return Optional.empty();
        }
        if (expression instanceof NullIfExpression) {
            NullIfExpression nullIfExpression = (NullIfExpression)expression;
            return Optional.of(LogicalExpression.and((Expression)nullIfExpression.getFirst(), (Expression)SimplifyFilterPredicate.isFalseOrNullPredicate(nullIfExpression.getSecond())));
        }
        if (expression instanceof SearchedCaseExpression) {
            Expression operand2;
            ImmutableList.Builder builder;
            SearchedCaseExpression caseExpression = (SearchedCaseExpression)expression;
            Optional defaultValue = caseExpression.getDefaultValue();
            List operands = (List)caseExpression.getWhenClauses().stream().map(WhenClause::getOperand).collect(ImmutableList.toImmutableList());
            List results = (List)caseExpression.getWhenClauses().stream().map(WhenClause::getResult).collect(ImmutableList.toImmutableList());
            long trueResultsCount = results.stream().filter(result -> result.equals((Object)BooleanLiteral.TRUE_LITERAL)).count();
            long notTrueResultsCount = results.stream().filter(SimplifyFilterPredicate::isNotTrue).count();
            if (trueResultsCount == (long)results.size() && defaultValue.isPresent() && ((Expression)defaultValue.get()).equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(BooleanLiteral.TRUE_LITERAL);
            }
            if (notTrueResultsCount == (long)results.size() && (defaultValue.isEmpty() || SimplifyFilterPredicate.isNotTrue((Expression)defaultValue.get()))) {
                return Optional.of(BooleanLiteral.FALSE_LITERAL);
            }
            if (trueResultsCount == 1L && notTrueResultsCount == (long)(results.size() - 1) && (defaultValue.isEmpty() || SimplifyFilterPredicate.isNotTrue((Expression)defaultValue.get()))) {
                builder = ImmutableList.builder();
                for (WhenClause whenClause : caseExpression.getWhenClauses()) {
                    operand2 = whenClause.getOperand();
                    Expression result2 = whenClause.getResult();
                    if (SimplifyFilterPredicate.isNotTrue(result2)) {
                        builder.add((Object)SimplifyFilterPredicate.isFalseOrNullPredicate(operand2));
                        continue;
                    }
                    builder.add((Object)operand2);
                    return Optional.of(ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)builder.build()));
                }
            }
            if (notTrueResultsCount == (long)results.size() && defaultValue.isPresent() && ((Expression)defaultValue.get()).equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                builder = ImmutableList.builder();
                operands.stream().forEach(operand -> builder.add((Object)SimplifyFilterPredicate.isFalseOrNullPredicate(operand)));
                return Optional.of(ExpressionUtils.combineConjuncts(this.metadata, (Collection<Expression>)builder.build()));
            }
            ArrayList<WhenClause> whenClauses = new ArrayList<WhenClause>();
            for (WhenClause whenClause : caseExpression.getWhenClauses()) {
                operand2 = whenClause.getOperand();
                if (operand2.equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                    if (whenClauses.isEmpty()) {
                        return Optional.of(whenClause.getResult());
                    }
                    return Optional.of(new SearchedCaseExpression(whenClauses, Optional.of(whenClause.getResult())));
                }
                if (SimplifyFilterPredicate.isNotTrue(operand2)) continue;
                whenClauses.add(whenClause);
            }
            if (whenClauses.isEmpty()) {
                return Optional.of((Expression)defaultValue.orElse(BooleanLiteral.FALSE_LITERAL));
            }
            if (whenClauses.size() < caseExpression.getWhenClauses().size()) {
                return Optional.of(new SearchedCaseExpression(whenClauses, defaultValue));
            }
            return Optional.empty();
        }
        if (expression instanceof SimpleCaseExpression) {
            SimpleCaseExpression caseExpression = (SimpleCaseExpression)expression;
            Optional defaultValue = caseExpression.getDefaultValue();
            if (caseExpression.getOperand() instanceof NullLiteral) {
                return Optional.of((Expression)defaultValue.orElse(BooleanLiteral.FALSE_LITERAL));
            }
            List results = (List)caseExpression.getWhenClauses().stream().map(WhenClause::getResult).collect(ImmutableList.toImmutableList());
            if (results.stream().allMatch(result -> result.equals((Object)BooleanLiteral.TRUE_LITERAL)) && defaultValue.isPresent() && ((Expression)defaultValue.get()).equals((Object)BooleanLiteral.TRUE_LITERAL)) {
                return Optional.of(BooleanLiteral.TRUE_LITERAL);
            }
            if (results.stream().allMatch(SimplifyFilterPredicate::isNotTrue) && (defaultValue.isEmpty() || SimplifyFilterPredicate.isNotTrue((Expression)defaultValue.get()))) {
                return Optional.of(BooleanLiteral.FALSE_LITERAL);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean isNotTrue(Expression expression) {
        return expression.equals((Object)BooleanLiteral.FALSE_LITERAL) || expression instanceof NullLiteral || expression instanceof Cast && SimplifyFilterPredicate.isNotTrue(((Cast)expression).getExpression());
    }

    private static Expression isFalseOrNullPredicate(Expression expression) {
        return LogicalExpression.or((Expression)new IsNullPredicate(expression), (Expression)new NotExpression(expression));
    }
}

