/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.Iterables;
import io.trino.matching.Capture;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.metadata.Metadata;
import io.trino.metadata.TableHandle;
import io.trino.sql.planner.Symbol;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.TableDeleteNode;
import io.trino.sql.planner.plan.TableFinishNode;
import io.trino.sql.planner.plan.TableScanNode;
import java.util.Objects;

public class PushDeleteIntoConnector
implements Rule<TableFinishNode> {
    private static final Capture<TableScanNode> TABLE_SCAN = Capture.newCapture();
    private static final Pattern<TableFinishNode> PATTERN = Patterns.tableFinish().with(Patterns.source().matching(Patterns.delete().with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN)))));
    private final Metadata metadata;

    public PushDeleteIntoConnector(Metadata metadata) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<TableFinishNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(TableFinishNode node, Captures captures, Rule.Context context) {
        TableScanNode tableScan = (TableScanNode)captures.get(TABLE_SCAN);
        return this.metadata.applyDelete(context.getSession(), tableScan.getTable()).map(newHandle -> new TableDeleteNode(context.getIdAllocator().getNextId(), (TableHandle)newHandle, (Symbol)Iterables.getOnlyElement(node.getOutputSymbols()))).map(Rule.Result::ofPlanNode).orElseGet(Rule.Result::empty);
    }
}

