/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner.iterative.rule;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.sql.planner.iterative.Rule;
import io.trino.sql.planner.optimizations.QueryCardinalityUtil;
import io.trino.sql.planner.plan.IntersectNode;
import io.trino.sql.planner.plan.Patterns;
import io.trino.sql.planner.plan.ValuesNode;
import io.trino.sql.tree.Expression;
import java.util.List;

public class EvaluateEmptyIntersect
implements Rule<IntersectNode> {
    private static final Pattern<IntersectNode> PATTERN = Patterns.intersect();

    @Override
    public Pattern<IntersectNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(IntersectNode node, Captures captures, Rule.Context context) {
        boolean hasEmptyBranches = node.getSources().stream().anyMatch(source -> QueryCardinalityUtil.isEmpty(source, context.getLookup()));
        if (hasEmptyBranches) {
            return Rule.Result.ofPlanNode(new ValuesNode(node.getId(), node.getOutputSymbols(), (List<Expression>)ImmutableList.of()));
        }
        return Rule.Result.empty();
    }
}

