/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.planner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import io.trino.spi.expression.ConnectorExpression;
import io.trino.spi.expression.Variable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class ConnectorExpressions {
    private ConnectorExpressions() {
    }

    public static List<Variable> extractVariables(ConnectorExpression expression) {
        return (List)ConnectorExpressions.preOrder(expression).filter(Variable.class::isInstance).map(Variable.class::cast).collect(ImmutableList.toImmutableList());
    }

    public static Stream<ConnectorExpression> preOrder(ConnectorExpression expression) {
        return Streams.stream((Iterable)Traverser.forTree(ConnectorExpression::getChildren).depthFirstPreOrder((Object)Objects.requireNonNull(expression, "expression is null")));
    }
}

