/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator.aggregation.state;

import io.trino.operator.aggregation.state.GenericDoubleState;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.function.AccumulatorStateSerializer;
import io.trino.spi.type.Type;
import java.util.Objects;

public class GenericDoubleStateSerializer
implements AccumulatorStateSerializer<GenericDoubleState> {
    private final Type serializedType;

    public GenericDoubleStateSerializer(Type serializedType) {
        this.serializedType = Objects.requireNonNull(serializedType, "serializedType is null");
    }

    public Type getSerializedType() {
        return this.serializedType;
    }

    public void serialize(GenericDoubleState state, BlockBuilder out) {
        if (state.isNull()) {
            out.appendNull();
        } else {
            this.serializedType.writeDouble(out, state.getValue());
        }
    }

    public void deserialize(Block block, int index, GenericDoubleState state) {
        state.setNull(false);
        state.setValue(this.serializedType.getDouble(block, index));
    }
}

