/*
 * Decompiled with CFR 0.152.
 */
package io.trino.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import io.trino.spi.type.TypeSignature;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;

public class TypeVariableConstraint {
    private final String name;
    private final boolean comparableRequired;
    private final boolean orderableRequired;
    private final String variadicBound;
    private final Set<TypeSignature> castableTo;
    private final Set<TypeSignature> castableFrom;

    @JsonCreator
    public TypeVariableConstraint(@JsonProperty(value="name") String name, @JsonProperty(value="comparableRequired") boolean comparableRequired, @JsonProperty(value="orderableRequired") boolean orderableRequired, @JsonProperty(value="variadicBound") @Nullable String variadicBound, @JsonProperty(value="castableTo") Set<TypeSignature> castableTo, @JsonProperty(value="castableFrom") Set<TypeSignature> castableFrom) {
        this.name = name;
        this.comparableRequired = comparableRequired;
        this.orderableRequired = orderableRequired;
        this.variadicBound = variadicBound;
        if (variadicBound != null && !variadicBound.equalsIgnoreCase("row")) {
            throw new IllegalArgumentException("variadicBound must be row but is " + variadicBound);
        }
        this.castableTo = ImmutableSet.copyOf((Collection)Objects.requireNonNull(castableTo, "castableTo is null"));
        this.castableFrom = ImmutableSet.copyOf((Collection)Objects.requireNonNull(castableFrom, "castableFrom is null"));
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public boolean isComparableRequired() {
        return this.comparableRequired;
    }

    @JsonProperty
    public boolean isOrderableRequired() {
        return this.orderableRequired;
    }

    @JsonProperty
    public String getVariadicBound() {
        return this.variadicBound;
    }

    @JsonProperty
    public Set<TypeSignature> getCastableTo() {
        return this.castableTo;
    }

    @JsonProperty
    public Set<TypeSignature> getCastableFrom() {
        return this.castableFrom;
    }

    public String toString() {
        Object value = this.name;
        if (this.comparableRequired) {
            value = (String)value + ":comparable";
        }
        if (this.orderableRequired) {
            value = (String)value + ":orderable";
        }
        if (this.variadicBound != null) {
            value = (String)value + ":" + this.variadicBound + "<*>";
        }
        if (!this.castableTo.isEmpty()) {
            value = (String)value + ":castableTo(" + Joiner.on((String)", ").join(this.castableTo) + ")";
        }
        if (!this.castableFrom.isEmpty()) {
            value = (String)value + ":castableFrom(" + Joiner.on((String)", ").join(this.castableFrom) + ")";
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeVariableConstraint that = (TypeVariableConstraint)o;
        return this.comparableRequired == that.comparableRequired && this.orderableRequired == that.orderableRequired && Objects.equals(this.name, that.name) && Objects.equals(this.variadicBound, that.variadicBound) && Objects.equals(this.castableTo, that.castableTo) && Objects.equals(this.castableFrom, that.castableFrom);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.comparableRequired, this.orderableRequired, this.variadicBound, this.castableTo, this.castableFrom);
    }
}

