/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.log.Logger;
import io.trino.execution.Lifespan;
import io.trino.execution.RemoteTask;
import io.trino.execution.TableExecuteContextManager;
import io.trino.execution.scheduler.BucketNodeMap;
import io.trino.execution.scheduler.NodeSelector;
import io.trino.execution.scheduler.PartitionIdAllocator;
import io.trino.execution.scheduler.ScheduleResult;
import io.trino.execution.scheduler.SourcePartitionedScheduler;
import io.trino.execution.scheduler.SourceScheduler;
import io.trino.execution.scheduler.SplitPlacementPolicy;
import io.trino.execution.scheduler.SplitPlacementResult;
import io.trino.execution.scheduler.StageExecution;
import io.trino.execution.scheduler.StageScheduler;
import io.trino.execution.scheduler.group.DynamicLifespanScheduler;
import io.trino.execution.scheduler.group.FixedLifespanScheduler;
import io.trino.execution.scheduler.group.LifespanScheduler;
import io.trino.metadata.InternalNode;
import io.trino.metadata.Split;
import io.trino.operator.StageExecutionDescriptor;
import io.trino.server.DynamicFilterService;
import io.trino.spi.connector.ConnectorPartitionHandle;
import io.trino.spi.connector.NotPartitionedPartitionHandle;
import io.trino.split.SplitSource;
import io.trino.sql.planner.plan.PlanNodeId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Supplier;

public class FixedSourcePartitionedScheduler
implements StageScheduler {
    private static final Logger log = Logger.get(FixedSourcePartitionedScheduler.class);
    private final StageExecution stageExecution;
    private final List<InternalNode> nodes;
    private final List<SourceScheduler> sourceSchedulers;
    private final List<ConnectorPartitionHandle> partitionHandles;
    private final Optional<LifespanScheduler> groupedLifespanScheduler;
    private final PartitionIdAllocator partitionIdAllocator;
    private final Map<InternalNode, RemoteTask> scheduledTasks;

    public FixedSourcePartitionedScheduler(StageExecution stageExecution, Map<PlanNodeId, SplitSource> splitSources, StageExecutionDescriptor stageExecutionDescriptor, List<PlanNodeId> schedulingOrder, List<InternalNode> nodes, BucketNodeMap bucketNodeMap, int splitBatchSize, OptionalInt concurrentLifespansPerTask, NodeSelector nodeSelector, List<ConnectorPartitionHandle> partitionHandles, DynamicFilterService dynamicFilterService, TableExecuteContextManager tableExecuteContextManager) {
        Objects.requireNonNull(stageExecution, "stageExecution is null");
        Objects.requireNonNull(splitSources, "splitSources is null");
        Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
        Preconditions.checkArgument((!Objects.requireNonNull(nodes, "nodes is null").isEmpty() ? 1 : 0) != 0, (Object)"nodes is empty");
        Objects.requireNonNull(partitionHandles, "partitionHandles is null");
        Objects.requireNonNull(tableExecuteContextManager, "tableExecuteContextManager is null");
        this.stageExecution = stageExecution;
        this.nodes = ImmutableList.copyOf(nodes);
        this.partitionHandles = ImmutableList.copyOf(partitionHandles);
        Preconditions.checkArgument((boolean)splitSources.keySet().equals(ImmutableSet.copyOf(schedulingOrder)));
        BucketedSplitPlacementPolicy splitPlacementPolicy = new BucketedSplitPlacementPolicy(nodeSelector, nodes, bucketNodeMap, stageExecution::getAllTasks);
        ArrayList<SourceScheduler> sourceSchedulers = new ArrayList<SourceScheduler>();
        Preconditions.checkArgument((partitionHandles.equals(ImmutableList.of((Object)NotPartitionedPartitionHandle.NOT_PARTITIONED)) != stageExecutionDescriptor.isStageGroupedExecution() ? 1 : 0) != 0, (Object)"PartitionHandles should be [NOT_PARTITIONED] if and only if all scan nodes use ungrouped execution strategy");
        int nodeCount = nodes.size();
        int concurrentLifespans = concurrentLifespansPerTask.isPresent() && concurrentLifespansPerTask.getAsInt() * nodeCount <= partitionHandles.size() ? concurrentLifespansPerTask.getAsInt() * nodeCount : partitionHandles.size();
        boolean firstPlanNode = true;
        Optional<Object> groupedLifespanScheduler = Optional.empty();
        this.partitionIdAllocator = new PartitionIdAllocator();
        this.scheduledTasks = new HashMap<InternalNode, RemoteTask>();
        for (PlanNodeId planNodeId : schedulingOrder) {
            SplitSource splitSource = splitSources.get(planNodeId);
            boolean groupedExecutionForScanNode = stageExecutionDescriptor.isScanGroupedExecution(planNodeId);
            SourceScheduler sourceScheduler = SourcePartitionedScheduler.newSourcePartitionedSchedulerAsSourceScheduler(stageExecution, planNodeId, splitSource, splitPlacementPolicy, Math.max(splitBatchSize / concurrentLifespans, 1), groupedExecutionForScanNode, dynamicFilterService, tableExecuteContextManager, () -> true, this.partitionIdAllocator, this.scheduledTasks);
            if (stageExecutionDescriptor.isStageGroupedExecution() && !groupedExecutionForScanNode) {
                sourceScheduler = new AsGroupedSourceScheduler(sourceScheduler);
            }
            sourceSchedulers.add(sourceScheduler);
            if (!firstPlanNode) continue;
            firstPlanNode = false;
            if (!stageExecutionDescriptor.isStageGroupedExecution()) {
                sourceScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
                sourceScheduler.noMoreLifespans();
                continue;
            }
            LifespanScheduler lifespanScheduler = bucketNodeMap.isDynamic() ? new DynamicLifespanScheduler(bucketNodeMap, nodes, partitionHandles, concurrentLifespansPerTask) : new FixedLifespanScheduler(bucketNodeMap, partitionHandles, concurrentLifespansPerTask);
            lifespanScheduler.scheduleInitial(sourceScheduler);
            stageExecution.addCompletedDriverGroupsChangedListener(lifespanScheduler::onLifespanFinished);
            groupedLifespanScheduler = Optional.of(lifespanScheduler);
        }
        this.groupedLifespanScheduler = groupedLifespanScheduler;
        this.sourceSchedulers = sourceSchedulers;
    }

    private ConnectorPartitionHandle partitionHandleFor(Lifespan lifespan) {
        if (lifespan.isTaskWide()) {
            return NotPartitionedPartitionHandle.NOT_PARTITIONED;
        }
        return this.partitionHandles.get(lifespan.getId());
    }

    @Override
    public ScheduleResult schedule() {
        ImmutableList newTasks = ImmutableList.of();
        if (this.scheduledTasks.isEmpty()) {
            ImmutableList.Builder newTasksBuilder = ImmutableList.builder();
            for (InternalNode node : this.nodes) {
                Optional<RemoteTask> task = this.stageExecution.scheduleTask(node, this.partitionIdAllocator.getNextId(), (Multimap<PlanNodeId, Split>)ImmutableMultimap.of(), (Multimap<PlanNodeId, Lifespan>)ImmutableMultimap.of());
                if (!task.isPresent()) continue;
                this.scheduledTasks.put(node, task.get());
                newTasksBuilder.add((Object)task.get());
            }
            newTasks = newTasksBuilder.build();
        }
        boolean allBlocked = true;
        ArrayList<Object> blocked = new ArrayList<Object>();
        ScheduleResult.BlockedReason blockedReason = ScheduleResult.BlockedReason.NO_ACTIVE_DRIVER_GROUP;
        if (this.groupedLifespanScheduler.isPresent()) {
            blocked.add(this.groupedLifespanScheduler.get().schedule(this.sourceSchedulers.get(0)));
        }
        int splitsScheduled = 0;
        Iterator<SourceScheduler> schedulerIterator = this.sourceSchedulers.iterator();
        Object driverGroupsToStart = ImmutableList.of();
        boolean shouldInvokeNoMoreDriverGroups = false;
        while (schedulerIterator.hasNext()) {
            SourceScheduler sourceScheduler = schedulerIterator.next();
            for (Lifespan lifespan : driverGroupsToStart) {
                sourceScheduler.startLifespan(lifespan, this.partitionHandleFor(lifespan));
            }
            if (shouldInvokeNoMoreDriverGroups) {
                sourceScheduler.noMoreLifespans();
            }
            ScheduleResult schedule = sourceScheduler.schedule();
            splitsScheduled += schedule.getSplitsScheduled();
            if (schedule.getBlockedReason().isPresent()) {
                blocked.add(schedule.getBlocked());
                blockedReason = blockedReason.combineWith(schedule.getBlockedReason().get());
            } else {
                Verify.verify((boolean)schedule.getBlocked().isDone(), (String)"blockedReason not provided when scheduler is blocked", (Object[])new Object[0]);
                allBlocked = false;
            }
            driverGroupsToStart = sourceScheduler.drainCompletedLifespans();
            if (schedule.isFinished()) {
                this.stageExecution.schedulingComplete(sourceScheduler.getPlanNodeId());
                schedulerIterator.remove();
                sourceScheduler.close();
                shouldInvokeNoMoreDriverGroups = true;
                continue;
            }
            shouldInvokeNoMoreDriverGroups = false;
        }
        if (allBlocked) {
            return new ScheduleResult(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, (ListenableFuture<Void>)MoreFutures.whenAnyComplete(blocked), blockedReason, splitsScheduled);
        }
        return new ScheduleResult(this.sourceSchedulers.isEmpty(), (Iterable<? extends RemoteTask>)newTasks, splitsScheduled);
    }

    @Override
    public void close() {
        for (SourceScheduler sourceScheduler : this.sourceSchedulers) {
            try {
                sourceScheduler.close();
            }
            catch (Throwable t) {
                log.warn(t, "Error closing split source");
            }
        }
        this.sourceSchedulers.clear();
    }

    public static class BucketedSplitPlacementPolicy
    implements SplitPlacementPolicy {
        private final NodeSelector nodeSelector;
        private final List<InternalNode> allNodes;
        private final BucketNodeMap bucketNodeMap;
        private final Supplier<? extends List<RemoteTask>> remoteTasks;

        public BucketedSplitPlacementPolicy(NodeSelector nodeSelector, List<InternalNode> allNodes, BucketNodeMap bucketNodeMap, Supplier<? extends List<RemoteTask>> remoteTasks) {
            this.nodeSelector = Objects.requireNonNull(nodeSelector, "nodeSelector is null");
            this.allNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(allNodes, "allNodes is null"));
            this.bucketNodeMap = Objects.requireNonNull(bucketNodeMap, "bucketNodeMap is null");
            this.remoteTasks = Objects.requireNonNull(remoteTasks, "remoteTasks is null");
        }

        @Override
        public SplitPlacementResult computeAssignments(Set<Split> splits) {
            return this.nodeSelector.computeAssignments(splits, this.remoteTasks.get(), this.bucketNodeMap);
        }

        @Override
        public void lockDownNodes() {
        }

        @Override
        public List<InternalNode> allNodes() {
            return this.allNodes;
        }

        public InternalNode getNodeForBucket(int bucketId) {
            return this.bucketNodeMap.getAssignedNode(bucketId).get();
        }
    }

    private static class AsGroupedSourceScheduler
    implements SourceScheduler {
        private final SourceScheduler sourceScheduler;
        private boolean started;
        private boolean completed;
        private final List<Lifespan> pendingCompleted;

        public AsGroupedSourceScheduler(SourceScheduler sourceScheduler) {
            this.sourceScheduler = Objects.requireNonNull(sourceScheduler, "sourceScheduler is null");
            this.pendingCompleted = new ArrayList<Lifespan>();
        }

        @Override
        public ScheduleResult schedule() {
            return this.sourceScheduler.schedule();
        }

        @Override
        public void close() {
            this.sourceScheduler.close();
        }

        @Override
        public PlanNodeId getPlanNodeId() {
            return this.sourceScheduler.getPlanNodeId();
        }

        @Override
        public void startLifespan(Lifespan lifespan, ConnectorPartitionHandle partitionHandle) {
            this.pendingCompleted.add(lifespan);
            if (this.started) {
                return;
            }
            this.started = true;
            this.sourceScheduler.startLifespan(Lifespan.taskWide(), NotPartitionedPartitionHandle.NOT_PARTITIONED);
            this.sourceScheduler.noMoreLifespans();
        }

        @Override
        public void noMoreLifespans() {
            Preconditions.checkState((boolean)this.started);
        }

        @Override
        public List<Lifespan> drainCompletedLifespans() {
            if (!this.completed) {
                List<Lifespan> lifespans = this.sourceScheduler.drainCompletedLifespans();
                if (lifespans.isEmpty()) {
                    return ImmutableList.of();
                }
                Preconditions.checkState((boolean)ImmutableList.of((Object)Lifespan.taskWide()).equals(lifespans));
                this.completed = true;
            }
            ImmutableList result = ImmutableList.copyOf(this.pendingCompleted);
            this.pendingCompleted.clear();
            return result;
        }
    }
}

