/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.trino.Session;
import io.trino.execution.DataDefinitionTask;
import io.trino.execution.QueryStateMachine;
import io.trino.execution.warnings.WarningCollector;
import io.trino.metadata.Metadata;
import io.trino.metadata.MetadataUtil;
import io.trino.security.AccessControl;
import io.trino.security.SecurityContext;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.security.AccessDeniedException;
import io.trino.spi.security.PrincipalType;
import io.trino.spi.security.RoleGrant;
import io.trino.spi.security.SelectedRole;
import io.trino.spi.security.TrinoPrincipal;
import io.trino.sql.analyzer.SemanticExceptions;
import io.trino.sql.tree.Expression;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.SetRole;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;

public class SetRoleTask
implements DataDefinitionTask<SetRole> {
    private final Metadata metadata;
    private final AccessControl accessControl;

    @Inject
    public SetRoleTask(Metadata metadata, AccessControl accessControl) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
    }

    @Override
    public String getName() {
        return "SET ROLE";
    }

    @Override
    public ListenableFuture<Void> execute(SetRole statement, QueryStateMachine stateMachine, List<Expression> parameters, WarningCollector warningCollector) {
        Session session = stateMachine.getSession();
        Optional<String> catalog = MetadataUtil.processRoleCommandCatalog(this.metadata, session, (Node)statement, statement.getCatalog().map(Identifier::getValue));
        if (statement.getType() == SetRole.Type.ROLE) {
            String role = statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH)).orElseThrow();
            if (!this.metadata.roleExists(session, role, catalog)) {
                throw SemanticExceptions.semanticException((ErrorCodeSupplier)StandardErrorCode.ROLE_NOT_FOUND, (Node)statement, "Role '%s' does not exist", role);
            }
            if (catalog.isPresent()) {
                this.accessControl.checkCanSetCatalogRole(SecurityContext.of(session), role, catalog.get());
            } else {
                Set<RoleGrant> roleGrants = this.metadata.listApplicableRoles(session, new TrinoPrincipal(PrincipalType.USER, session.getUser()), Optional.empty());
                if (roleGrants.stream().map(RoleGrant::getRoleName).noneMatch(role::equals)) {
                    AccessDeniedException.denySetRole((String)role);
                }
            }
        }
        SelectedRole.Type type = SetRoleTask.toSelectedRoleType(statement.getType());
        stateMachine.addSetRole(catalog.orElse("system"), new SelectedRole(type, statement.getRole().map(c -> c.getValue().toLowerCase(Locale.ENGLISH))));
        return Futures.immediateVoidFuture();
    }

    private static SelectedRole.Type toSelectedRoleType(SetRole.Type statementRoleType) {
        switch (statementRoleType) {
            case ROLE: {
                return SelectedRole.Type.ROLE;
            }
            case ALL: {
                return SelectedRole.Type.ALL;
            }
            case NONE: {
                return SelectedRole.Type.NONE;
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + statementRoleType);
    }
}

