/*
 * Decompiled with CFR 0.152.
 */
package io.trino.execution;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import io.trino.client.ErrorLocation;
import io.trino.client.FailureInfo;
import io.trino.execution.Failure;
import io.trino.spi.ErrorCode;
import io.trino.spi.HostAddress;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ExecutionFailureInfo {
    private static final Pattern STACK_TRACE_PATTERN = Pattern.compile("(.*)\\.(.*)\\(([^:]*)(?::(.*))?\\)");
    private final String type;
    private final String message;
    private final ExecutionFailureInfo cause;
    private final List<ExecutionFailureInfo> suppressed;
    private final List<String> stack;
    private final ErrorLocation errorLocation;
    private final ErrorCode errorCode;
    private final HostAddress remoteHost;

    @JsonCreator
    public ExecutionFailureInfo(@JsonProperty(value="type") String type, @JsonProperty(value="message") String message, @JsonProperty(value="cause") ExecutionFailureInfo cause, @JsonProperty(value="suppressed") List<ExecutionFailureInfo> suppressed, @JsonProperty(value="stack") List<String> stack, @JsonProperty(value="errorLocation") @Nullable ErrorLocation errorLocation, @JsonProperty(value="errorCode") @Nullable ErrorCode errorCode, @JsonProperty(value="remoteHost") @Nullable HostAddress remoteHost) {
        Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(suppressed, "suppressed is null");
        Objects.requireNonNull(stack, "stack is null");
        this.type = type;
        this.message = message;
        this.cause = cause;
        this.suppressed = ImmutableList.copyOf(suppressed);
        this.stack = ImmutableList.copyOf(stack);
        this.errorLocation = errorLocation;
        this.errorCode = errorCode;
        this.remoteHost = remoteHost;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Nullable
    @JsonProperty
    public String getMessage() {
        return this.message;
    }

    @Nullable
    @JsonProperty
    public ExecutionFailureInfo getCause() {
        return this.cause;
    }

    @JsonProperty
    public List<ExecutionFailureInfo> getSuppressed() {
        return this.suppressed;
    }

    @JsonProperty
    public List<String> getStack() {
        return this.stack;
    }

    @Nullable
    @JsonProperty
    public ErrorLocation getErrorLocation() {
        return this.errorLocation;
    }

    @Nullable
    @JsonProperty
    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    @Nullable
    @JsonProperty
    public HostAddress getRemoteHost() {
        return this.remoteHost;
    }

    public FailureInfo toFailureInfo() {
        List suppressed = (List)this.suppressed.stream().map(ExecutionFailureInfo::toFailureInfo).collect(ImmutableList.toImmutableList());
        return new FailureInfo(this.type, this.message, this.cause == null ? null : this.cause.toFailureInfo(), suppressed, this.stack, this.errorLocation);
    }

    public RuntimeException toException() {
        return ExecutionFailureInfo.toException(this);
    }

    private static Failure toException(ExecutionFailureInfo executionFailureInfo) {
        if (executionFailureInfo == null) {
            return null;
        }
        Failure failure = new Failure(executionFailureInfo.getType(), executionFailureInfo.getMessage(), executionFailureInfo.getErrorCode(), ExecutionFailureInfo.toException(executionFailureInfo.getCause()));
        for (ExecutionFailureInfo executionFailureInfo2 : executionFailureInfo.getSuppressed()) {
            failure.addSuppressed(ExecutionFailureInfo.toException(executionFailureInfo2));
        }
        ImmutableList.Builder stackTraceBuilder = ImmutableList.builder();
        for (String stack : executionFailureInfo.getStack()) {
            stackTraceBuilder.add((Object)ExecutionFailureInfo.toStackTraceElement(stack));
        }
        ImmutableList immutableList = stackTraceBuilder.build();
        failure.setStackTrace((StackTraceElement[])immutableList.toArray((Object[])new StackTraceElement[immutableList.size()]));
        return failure;
    }

    public static StackTraceElement toStackTraceElement(String stack) {
        Matcher matcher = STACK_TRACE_PATTERN.matcher(stack);
        if (matcher.matches()) {
            String declaringClass = matcher.group(1);
            String methodName = matcher.group(2);
            String fileName = matcher.group(3);
            int number = -1;
            if (fileName.equals("Native Method")) {
                fileName = null;
                number = -2;
            } else if (matcher.group(4) != null) {
                number = Integer.parseInt(matcher.group(4));
            }
            return new StackTraceElement(declaringClass, methodName, fileName, number);
        }
        return new StackTraceElement("Unknown", stack, null, -1);
    }
}

