/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.loadbalance.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.TreeMultimap;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.PulsarService;
import org.apache.pulsar.broker.loadbalance.BrokerHostUsage;
import org.apache.pulsar.broker.loadbalance.LoadManager;
import org.apache.pulsar.broker.loadbalance.PlacementStrategy;
import org.apache.pulsar.broker.loadbalance.ResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.GenericBrokerHostUsageImpl;
import org.apache.pulsar.broker.loadbalance.impl.LinuxBrokerHostUsageImpl;
import org.apache.pulsar.broker.loadbalance.impl.LoadManagerShared;
import org.apache.pulsar.broker.loadbalance.impl.PulsarResourceDescription;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceAllocationPolicies;
import org.apache.pulsar.broker.loadbalance.impl.SimpleResourceUnit;
import org.apache.pulsar.broker.loadbalance.impl.WRRPlacementStrategy;
import org.apache.pulsar.client.util.ExecutorProvider;
import org.apache.pulsar.common.naming.NamespaceName;
import org.apache.pulsar.common.naming.ServiceUnitId;
import org.apache.pulsar.common.policies.data.ResourceQuota;
import org.apache.pulsar.common.stats.Metrics;
import org.apache.pulsar.common.util.FutureUtil;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashMap;
import org.apache.pulsar.common.util.collections.ConcurrentOpenHashSet;
import org.apache.pulsar.metadata.api.MetadataCache;
import org.apache.pulsar.metadata.api.MetadataStoreException;
import org.apache.pulsar.metadata.api.Notification;
import org.apache.pulsar.metadata.api.coordination.LockManager;
import org.apache.pulsar.metadata.api.coordination.ResourceLock;
import org.apache.pulsar.policies.data.loadbalancer.LoadReport;
import org.apache.pulsar.policies.data.loadbalancer.NamespaceBundleStats;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUnitRanking;
import org.apache.pulsar.policies.data.loadbalancer.ResourceUsage;
import org.apache.pulsar.policies.data.loadbalancer.SystemResourceUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoadManagerImpl
implements LoadManager,
Consumer<Notification> {
    private static final Logger log = LoggerFactory.getLogger(SimpleLoadManagerImpl.class);
    private SimpleResourceAllocationPolicies policies;
    private PulsarService pulsar;
    private long avgJvmHeapUsageMBytes = 0L;
    private Map<ResourceUnit, LoadReport> currentLoadReports;
    private Map<ResourceUnit, ResourceUnitRanking> resourceUnitRankings;
    private AtomicReference<Map<Long, Set<ResourceUnit>>> sortedRankings = new AtomicReference();
    private long brokerRotationCursor = 0L;
    private AtomicReference<List<Metrics>> loadBalancingMetrics = new AtomicReference();
    private final Set<String> brokerCandidateCache;
    private final Set<String> availableBrokersCache;
    private final Set<String> bundleGainsCache;
    private final Set<String> bundleLossesCache;
    private final ConcurrentOpenHashMap<String, ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>> brokerToNamespaceToBundleRange;
    private double realtimeCpuLoadFactor = 0.025;
    private double realtimeMemoryLoadFactor = 25.0;
    private ResourceQuota realtimeAvgResourceQuota = null;
    private AtomicReference<Map<String, ResourceQuota>> realtimeResourceQuotas = new AtomicReference();
    private long lastResourceQuotaUpdateTimestamp = -1L;
    public static final long RESOURCE_QUOTA_GO_UP_TIMEWINDOW = TimeUnit.MINUTES.toMillis(30L);
    public static final long RESOURCE_QUOTA_GO_DOWN_TIMEWINDOW = TimeUnit.MINUTES.toMillis(1440L);
    private static final double RESOURCE_QUOTA_MIN_CPU_FACTOR = 0.01;
    private static final double RESOURCE_QUOTA_MAX_CPU_FACTOR = 0.1;
    private static final double RESOURCE_QUOTA_MIN_MEM_FACTOR = 10.0;
    private static final double RESOURCE_QUOTA_MAX_MEM_FACTOR = 50.0;
    private static final long RESOURCE_QUOTA_MIN_MSGRATE_IN = 5L;
    private static final long RESOURCE_QUOTA_MIN_MSGRATE_OUT = 5L;
    private static final long RESOURCE_QUOTA_MIN_BANDWIDTH_IN = 10000L;
    private static final long RESOURCE_QUOTA_MIN_BANDWIDTH_OUT = 10000L;
    private static final long RESOURCE_QUOTA_MIN_MEMORY = 2L;
    private static final long RESOURCE_QUOTA_MAX_MSGRATE_IN = 0L;
    private static final long RESOURCE_QUOTA_MAX_MSGRATE_OUT = 0L;
    private static final long RESOURCE_QUOTA_MAX_BANDWIDTH_IN = 1000000L;
    private static final long RESOURCE_QUOTA_MAX_BANDWIDTH_OUT = 1000000L;
    private static final long RESOURCE_QUOTA_MAX_MEMORY = 200L;
    private final PlacementStrategy placementStrategy;
    private LockManager<LoadReport> loadReports;
    private ResourceLock<LoadReport> brokerLock;
    private MetadataCache<Map<String, String>> dynamicConfigurationCache;
    private BrokerHostUsage brokerHostUsage;
    private LoadingCache<String, Long> unloadedHotNamespaceCache;
    public static final String LOADBALANCER_DYNAMIC_SETTING_STRATEGY_ZPATH = "/loadbalance/settings/strategy";
    private static final String LOADBALANCER_DYNAMIC_SETTING_LOAD_FACTOR_CPU_ZPATH = "/loadbalance/settings/load_factor_cpu";
    private static final String LOADBALANCER_DYNAMIC_SETTING_LOAD_FACTOR_MEM_ZPATH = "/loadbalance/settings/load_factor_mem";
    private static final String LOADBALANCER_DYNAMIC_SETTING_OVERLOAD_THRESHOLD_ZPATH = "/loadbalance/settings/overload_threshold";
    private static final String LOADBALANCER_DYNAMIC_SETTING_COMFORT_LOAD_THRESHOLD_ZPATH = "/loadbalance/settings/comfort_load_threshold";
    private static final String LOADBALANCER_DYNAMIC_SETTING_UNDERLOAD_THRESHOLD_ZPATH = "/loadbalance/settings/underload_threshold";
    private static final String LOADBALANCER_DYNAMIC_SETTING_AUTO_BUNDLE_SPLIT_ENABLED = "/loadbalance/settings/auto_bundle_split_enabled";
    private static final String SETTING_NAME_LOAD_FACTOR_CPU = "loadFactorCPU";
    private static final String SETTING_NAME_LOAD_FACTOR_MEM = "loadFactorMemory";
    public static final String SETTING_NAME_STRATEGY = "loadBalancerStrategy";
    private static final String SETTING_NAME_OVERLOAD_THRESHOLD = "overloadThreshold";
    private static final String SETTING_NAME_UNDERLOAD_THRESHOLD = "underloadThreshold";
    private static final String SETTING_NAME_COMFORTLOAD_THRESHOLD = "comfortLoadThreshold";
    private static final String SETTING_NAME_AUTO_BUNDLE_SPLIT_ENABLED = "autoBundleSplitEnabled";
    public static final String LOADBALANCER_STRATEGY_LLS = "leastLoadedServer";
    public static final String LOADBALANCER_STRATEGY_RAND = "weightedRandomSelection";
    public static final String LOADBALANCER_STRATEGY_LEAST_MSG = "leastMsgPerSecond";
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new ExecutorProvider.ExtendedThreadFactory("pulsar-simple-load-manager"));
    private static final long MBytes = 0x100000L;
    private volatile LoadReport lastLoadReport;
    private long lastResourceUsageTimestamp = -1L;
    private boolean forceLoadReportUpdate = false;
    private final LoadManagerShared.BrokerTopicLoadingPredicate brokerTopicLoadingPredicate;
    private volatile Future<?> updateRankingHandle;
    private Map<String, String> bundleBrokerAffinityMap;

    public SimpleLoadManagerImpl() {
        this.sortedRankings.set(new TreeMap());
        this.currentLoadReports = new HashMap<ResourceUnit, LoadReport>();
        this.resourceUnitRankings = new HashMap<ResourceUnit, ResourceUnitRanking>();
        this.loadBalancingMetrics.set(new ArrayList());
        this.realtimeResourceQuotas.set(new HashMap());
        this.realtimeAvgResourceQuota = new ResourceQuota();
        this.placementStrategy = new WRRPlacementStrategy();
        this.bundleGainsCache = new HashSet<String>();
        this.bundleLossesCache = new HashSet<String>();
        this.brokerCandidateCache = new HashSet<String>();
        this.availableBrokersCache = new HashSet<String>();
        this.brokerToNamespaceToBundleRange = ConcurrentOpenHashMap.newBuilder().build();
        this.brokerTopicLoadingPredicate = new LoadManagerShared.BrokerTopicLoadingPredicate(){

            @Override
            public boolean isEnablePersistentTopics(String brokerId) {
                SimpleResourceUnit ru = new SimpleResourceUnit(brokerId, new PulsarResourceDescription());
                LoadReport loadReport = SimpleLoadManagerImpl.this.currentLoadReports.get(ru);
                return loadReport != null && loadReport.isPersistentTopicsEnabled();
            }

            @Override
            public boolean isEnableNonPersistentTopics(String brokerId) {
                SimpleResourceUnit ru = new SimpleResourceUnit(brokerId, new PulsarResourceDescription());
                LoadReport loadReport = SimpleLoadManagerImpl.this.currentLoadReports.get(ru);
                return loadReport != null && loadReport.isNonPersistentTopicsEnabled();
            }
        };
    }

    @Override
    public void initialize(PulsarService pulsar) {
        this.brokerHostUsage = SystemUtils.IS_OS_LINUX ? new LinuxBrokerHostUsageImpl(pulsar) : new GenericBrokerHostUsageImpl(pulsar);
        this.policies = new SimpleResourceAllocationPolicies(pulsar);
        this.lastLoadReport = new LoadReport(pulsar.getWebServiceAddress(), pulsar.getWebServiceAddressTls(), pulsar.getBrokerServiceUrl(), pulsar.getBrokerServiceUrlTls());
        this.lastLoadReport.setProtocols(pulsar.getProtocolDataToAdvertise());
        this.lastLoadReport.setPersistentTopicsEnabled(pulsar.getConfiguration().isEnablePersistentTopics());
        this.lastLoadReport.setNonPersistentTopicsEnabled(pulsar.getConfiguration().isEnableNonPersistentTopics());
        this.loadReports = pulsar.getCoordinationService().getLockManager(LoadReport.class);
        pulsar.getLocalMetadataStore().registerListener((Consumer)this);
        this.dynamicConfigurationCache = pulsar.getLocalMetadataStore().getMetadataCache((TypeReference)new TypeReference<Map<String, String>>(){});
        int entryExpiryTime = (int)pulsar.getConfiguration().getLoadBalancerSheddingGracePeriodMinutes();
        this.unloadedHotNamespaceCache = CacheBuilder.newBuilder().expireAfterWrite((long)entryExpiryTime, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Long>(){

            public Long load(String key) throws Exception {
                return System.currentTimeMillis();
            }
        });
        this.pulsar = pulsar;
        this.bundleBrokerAffinityMap = new ConcurrentHashMap<String, String>();
    }

    public SimpleLoadManagerImpl(PulsarService pulsar) {
        this();
        this.initialize(pulsar);
    }

    @Override
    public void start() throws PulsarServerException {
        String brokerId = this.pulsar.getBrokerId();
        String brokerLockPath = "/loadbalance/brokers/" + brokerId;
        try {
            LoadReport loadReport = null;
            try {
                loadReport = this.generateLoadReport();
                this.lastResourceUsageTimestamp = loadReport.getTimestamp();
            }
            catch (Exception e) {
                log.warn("Unable to get load report to write it on metadata store", (Throwable)e);
            }
            this.brokerLock = (ResourceLock)this.loadReports.acquireLock(brokerLockPath, (Object)loadReport).join();
            this.updateRanking();
            log.info("Created broker ephemeral node on {}", (Object)brokerLockPath);
            this.realtimeAvgResourceQuota = this.pulsar.getBrokerService().getBundlesQuotas().getDefaultResourceQuota().join();
            this.lastResourceQuotaUpdateTimestamp = System.currentTimeMillis();
            this.realtimeCpuLoadFactor = this.getDynamicConfigurationDouble(LOADBALANCER_DYNAMIC_SETTING_LOAD_FACTOR_CPU_ZPATH, SETTING_NAME_LOAD_FACTOR_CPU, this.realtimeCpuLoadFactor);
            this.realtimeMemoryLoadFactor = this.getDynamicConfigurationDouble(LOADBALANCER_DYNAMIC_SETTING_LOAD_FACTOR_MEM_ZPATH, SETTING_NAME_LOAD_FACTOR_MEM, this.realtimeMemoryLoadFactor);
        }
        catch (Exception e) {
            log.error("Unable to create node - [{}] for load balance on metadata store", (Object)brokerLockPath, (Object)e);
            throw new PulsarServerException((Throwable)e);
        }
    }

    @Override
    public void disableBroker() throws Exception {
        if (this.brokerLock != null) {
            this.brokerLock.release().join();
        }
    }

    @Override
    public Set<String> getAvailableBrokers() throws Exception {
        return new HashSet<String>((Collection)this.loadReports.listLocks("/loadbalance/brokers").join());
    }

    @Override
    public CompletableFuture<Set<String>> getAvailableBrokersAsync() {
        CompletableFuture<Set<String>> getAvailableBrokersAsync = new CompletableFuture<Set<String>>();
        this.loadReports.listLocks("/loadbalance/brokers").whenComplete((listLocks, ex) -> {
            if (ex != null) {
                Throwable realCause = FutureUtil.unwrapCompletionException((Throwable)ex);
                log.warn("Error when trying to get active brokers", realCause);
                getAvailableBrokersAsync.completeExceptionally(realCause);
            } else {
                getAvailableBrokersAsync.complete(Sets.newHashSet((Iterable)listLocks));
            }
        });
        return getAvailableBrokersAsync;
    }

    private void setDynamicConfigurationToStore(String path, Map<String, String> settings) {
        try {
            this.dynamicConfigurationCache.readModifyUpdateOrCreate(path, __ -> settings).join();
        }
        catch (CompletionException e) {
            log.warn("Got exception when writing to metadata store [{}]:", (Object)path, (Object)MetadataStoreException.unwrap((Throwable)e));
        }
    }

    private String getDynamicConfigurationFromStore(String path, String settingName, String defaultValue) {
        try {
            return ((Optional)this.dynamicConfigurationCache.get(path).join()).map(c -> (String)c.get(settingName)).orElse(defaultValue);
        }
        catch (Exception e) {
            log.warn("Got exception when reading path from metadata store [{}]:", (Object)path, (Object)e);
            return defaultValue;
        }
    }

    private double getDynamicConfigurationDouble(String path, String settingName, double defaultValue) {
        try {
            return Double.parseDouble(this.getDynamicConfigurationFromStore(path, settingName, String.valueOf(defaultValue)));
        }
        catch (Exception e) {
            log.warn("Got exception when parsing configuration from path [{}]:", (Object)path, (Object)e);
            return defaultValue;
        }
    }

    private boolean getDynamicConfigurationBoolean(String path, String settingName, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.getDynamicConfigurationFromStore(path, settingName, String.valueOf(defaultValue)));
        }
        catch (Exception e) {
            log.warn("Got exception when parsing configuration from path [{}]:", (Object)path, (Object)e);
            return defaultValue;
        }
    }

    private String getLoadBalancerPlacementStrategy() {
        String strategy = this.getDynamicConfigurationFromStore(LOADBALANCER_DYNAMIC_SETTING_STRATEGY_ZPATH, SETTING_NAME_STRATEGY, this.pulsar.getConfiguration().getLoadBalancerPlacementStrategy());
        if (!(LOADBALANCER_STRATEGY_LLS.equals(strategy) || LOADBALANCER_STRATEGY_RAND.equals(strategy) || LOADBALANCER_STRATEGY_LEAST_MSG.equals(strategy))) {
            strategy = LOADBALANCER_STRATEGY_RAND;
        }
        return strategy;
    }

    @Override
    public boolean isCentralized() {
        String strategy = this.getLoadBalancerPlacementStrategy();
        return strategy.equals(LOADBALANCER_STRATEGY_LLS) || strategy.equals(LOADBALANCER_STRATEGY_LEAST_MSG);
    }

    private long getLoadBalancerBrokerUnderloadedThresholdPercentage() {
        return (long)this.getDynamicConfigurationDouble(LOADBALANCER_DYNAMIC_SETTING_UNDERLOAD_THRESHOLD_ZPATH, SETTING_NAME_UNDERLOAD_THRESHOLD, this.pulsar.getConfiguration().getLoadBalancerBrokerUnderloadedThresholdPercentage());
    }

    private long getLoadBalancerBrokerOverloadedThresholdPercentage() {
        return (long)this.getDynamicConfigurationDouble(LOADBALANCER_DYNAMIC_SETTING_OVERLOAD_THRESHOLD_ZPATH, SETTING_NAME_OVERLOAD_THRESHOLD, this.pulsar.getConfiguration().getLoadBalancerBrokerOverloadedThresholdPercentage());
    }

    private long getLoadBalancerBrokerComfortLoadThresholdPercentage() {
        return (long)this.getDynamicConfigurationDouble(LOADBALANCER_DYNAMIC_SETTING_COMFORT_LOAD_THRESHOLD_ZPATH, SETTING_NAME_COMFORTLOAD_THRESHOLD, this.pulsar.getConfiguration().getLoadBalancerBrokerComfortLoadLevelPercentage());
    }

    private boolean getLoadBalancerAutoBundleSplitEnabled() {
        return this.getDynamicConfigurationBoolean(LOADBALANCER_DYNAMIC_SETTING_AUTO_BUNDLE_SPLIT_ENABLED, SETTING_NAME_AUTO_BUNDLE_SPLIT_ENABLED, this.pulsar.getConfiguration().isLoadBalancerAutoBundleSplitEnabled());
    }

    private PulsarResourceDescription fromLoadReport(LoadReport report) {
        SystemResourceUsage sru = report.getSystemResourceUsage();
        PulsarResourceDescription resourceDescription = new PulsarResourceDescription();
        if (sru == null) {
            return resourceDescription;
        }
        if (sru.bandwidthIn != null) {
            resourceDescription.put("bandwidthIn", sru.bandwidthIn);
        }
        if (sru.bandwidthOut != null) {
            resourceDescription.put("bandwidthOut", sru.bandwidthOut);
        }
        if (sru.memory != null) {
            resourceDescription.put("memory", sru.memory);
        }
        if (sru.cpu != null) {
            resourceDescription.put("cpu", sru.cpu);
        }
        return resourceDescription;
    }

    private ResourceQuota getResourceQuota(String bundle) {
        Map<String, ResourceQuota> quotas = this.realtimeResourceQuotas.get();
        if (!quotas.containsKey(bundle)) {
            ResourceQuota quota = this.pulsar.getBrokerService().getBundlesQuotas().getResourceQuota(bundle).join();
            quotas.put(bundle, quota);
            return quota;
        }
        return quotas.get(bundle);
    }

    private ResourceQuota getTotalAllocatedQuota(Set<String> bundles) {
        ResourceQuota totalQuota = new ResourceQuota();
        for (String bundle : bundles) {
            ResourceQuota quota = this.getResourceQuota(bundle);
            totalQuota.add(quota);
        }
        return totalQuota;
    }

    private double timeSmoothValue(double oldValue, double newSample, double minValue, double maxValue, long timePast) {
        newSample = Math.max(minValue, newSample);
        if (maxValue > 0.0) {
            newSample = Math.min(maxValue, newSample);
        }
        double weight = 0.0;
        if (newSample >= oldValue) {
            weight = Math.min(1.0, Math.max(0.0, (double)timePast / (double)RESOURCE_QUOTA_GO_UP_TIMEWINDOW));
        } else if (newSample < oldValue) {
            weight = Math.min(1.0, Math.max(0.0, (double)timePast / (double)RESOURCE_QUOTA_GO_DOWN_TIMEWINDOW));
        }
        double result = (1.0 - weight) * oldValue + weight * newSample;
        return result;
    }

    private ResourceQuota timeSmoothQuota(ResourceQuota oldQuota, double msgRateIn, double msgRateOut, double bandwidthIn, double bandwidthOut, double memory, long timePast) {
        if (oldQuota.getDynamic()) {
            ResourceQuota newQuota = new ResourceQuota();
            newQuota.setMsgRateIn(this.timeSmoothValue(oldQuota.getMsgRateIn(), msgRateIn, 5.0, 0.0, timePast));
            newQuota.setMsgRateOut(this.timeSmoothValue(oldQuota.getMsgRateOut(), msgRateOut, 5.0, 0.0, timePast));
            newQuota.setBandwidthIn(this.timeSmoothValue(oldQuota.getBandwidthIn(), bandwidthIn, 10000.0, 1000000.0, timePast));
            newQuota.setBandwidthOut(this.timeSmoothValue(oldQuota.getBandwidthOut(), bandwidthOut, 10000.0, 1000000.0, timePast));
            newQuota.setMemory(this.timeSmoothValue(oldQuota.getMemory(), memory, 2.0, 200.0, timePast));
            return newQuota;
        }
        return oldQuota;
    }

    private synchronized void updateRealtimeResourceQuota() {
        long memObjectGroupSize = 500L;
        if (!this.currentLoadReports.isEmpty()) {
            long totalBundles = 0L;
            long totalMemGroups = 0L;
            double totalMsgRateIn = 0.0;
            double totalMsgRateOut = 0.0;
            double totalMsgRate = 0.0;
            double totalCpuUsage = 0.0;
            double totalMemoryUsage = 0.0;
            double totalBandwidthIn = 0.0;
            double totalBandwidthOut = 0.0;
            long loadReportTimestamp = -1L;
            for (Map.Entry<ResourceUnit, LoadReport> entry : this.currentLoadReports.entrySet()) {
                Map bundleStats;
                LoadReport loadReport = entry.getValue();
                if (loadReport.getTimestamp() > loadReportTimestamp) {
                    loadReportTimestamp = loadReport.getTimestamp();
                }
                if ((bundleStats = loadReport.getBundleStats()) == null) continue;
                for (Map.Entry statsEntry : bundleStats.entrySet()) {
                    ++totalBundles;
                    NamespaceBundleStats stats = (NamespaceBundleStats)statsEntry.getValue();
                    totalMemGroups += 1L + (stats.topics + (long)stats.producerCount + (long)stats.consumerCount) / memObjectGroupSize;
                    totalBandwidthIn += stats.msgThroughputIn;
                    totalBandwidthOut += stats.msgThroughputOut;
                }
                SystemResourceUsage resUsage = loadReport.getSystemResourceUsage();
                totalMsgRateIn += loadReport.getMsgRateIn();
                totalMsgRateOut += loadReport.getMsgRateOut();
                totalCpuUsage += resUsage.getCpu().usage;
                totalMemoryUsage += resUsage.getMemory().usage;
            }
            totalMsgRate = totalMsgRateIn + totalMsgRateOut;
            long timePast = loadReportTimestamp - this.lastResourceQuotaUpdateTimestamp;
            this.lastResourceQuotaUpdateTimestamp = loadReportTimestamp;
            if (totalMsgRate > 1000.0 && totalMemGroups > 30L) {
                this.realtimeCpuLoadFactor = this.timeSmoothValue(this.realtimeCpuLoadFactor, totalCpuUsage / totalMsgRate, 0.01, 0.1, timePast);
                this.realtimeMemoryLoadFactor = this.timeSmoothValue(this.realtimeMemoryLoadFactor, totalMemoryUsage / (double)totalMemGroups, 10.0, 50.0, timePast);
            }
            if (totalBundles > 30L && this.realtimeAvgResourceQuota.getDynamic()) {
                ResourceQuota newQuota;
                ResourceQuota oldQuota = this.realtimeAvgResourceQuota;
                this.realtimeAvgResourceQuota = newQuota = this.timeSmoothQuota(oldQuota, totalMsgRateIn / (double)totalBundles, totalMsgRateOut / (double)totalBundles, totalBandwidthIn / (double)totalBundles, totalBandwidthOut / (double)totalBundles, totalMemoryUsage / (double)totalBundles, timePast);
            }
            HashMap<String, ResourceQuota> newQuotas = new HashMap<String, ResourceQuota>();
            for (Map.Entry<ResourceUnit, LoadReport> entry : this.currentLoadReports.entrySet()) {
                LoadReport loadReport = entry.getValue();
                Map bundleStats = loadReport.getBundleStats();
                if (bundleStats == null) continue;
                for (Map.Entry statsEntry : bundleStats.entrySet()) {
                    String bundle = (String)statsEntry.getKey();
                    NamespaceBundleStats stats = (NamespaceBundleStats)statsEntry.getValue();
                    long memGroupCount = 1L + (stats.topics + (long)stats.producerCount + (long)stats.consumerCount) / memObjectGroupSize;
                    double newMemoryQuota = (double)memGroupCount * this.realtimeMemoryLoadFactor;
                    ResourceQuota oldQuota = this.getResourceQuota(bundle);
                    ResourceQuota newQuota = this.timeSmoothQuota(oldQuota, stats.msgRateIn, stats.msgRateOut, stats.msgThroughputIn, stats.msgThroughputOut, newMemoryQuota, timePast);
                    newQuotas.put(bundle, newQuota);
                }
            }
            this.realtimeResourceQuotas.set(newQuotas);
        }
    }

    private void compareAndWriteQuota(String bundle, ResourceQuota oldQuota, ResourceQuota newQuota) throws Exception {
        boolean needUpdate = true;
        if (!oldQuota.getDynamic() || Math.abs(newQuota.getMsgRateIn() - oldQuota.getMsgRateIn()) < 5.0 && Math.abs(newQuota.getMsgRateOut() - oldQuota.getMsgRateOut()) < 5.0 && Math.abs(newQuota.getBandwidthIn() - oldQuota.getBandwidthOut()) < 10000.0 && Math.abs(newQuota.getBandwidthOut() - oldQuota.getBandwidthOut()) < 10000.0 && Math.abs(newQuota.getMemory() - oldQuota.getMemory()) < 2.0) {
            needUpdate = false;
        }
        if (needUpdate) {
            log.info(String.format("Update quota %s - msgRateIn: %.1f, msgRateOut: %.1f, bandwidthIn: %.1f, bandwidthOut: %.1f, memory: %.1f", bundle == null ? "default" : bundle, newQuota.getMsgRateIn(), newQuota.getMsgRateOut(), newQuota.getBandwidthIn(), newQuota.getBandwidthOut(), newQuota.getMemory()));
            if (bundle == null) {
                this.pulsar.getBrokerService().getBundlesQuotas().setDefaultResourceQuota(newQuota).join();
            } else {
                this.pulsar.getBrokerService().getBundlesQuotas().setResourceQuota(bundle, newQuota).join();
            }
        }
    }

    @Override
    public void writeResourceQuotasToZooKeeper() throws Exception {
        log.info("Writing namespace bundle resource quotas to ZooKeeper as leader broker");
        this.setDynamicConfigurationToStore(LOADBALANCER_DYNAMIC_SETTING_LOAD_FACTOR_CPU_ZPATH, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put(SimpleLoadManagerImpl.SETTING_NAME_LOAD_FACTOR_CPU, Double.toString(SimpleLoadManagerImpl.this.realtimeCpuLoadFactor));
            }
        });
        this.setDynamicConfigurationToStore(LOADBALANCER_DYNAMIC_SETTING_LOAD_FACTOR_MEM_ZPATH, (Map<String, String>)new HashMap<String, String>(){
            {
                this.put(SimpleLoadManagerImpl.SETTING_NAME_LOAD_FACTOR_MEM, Double.toString(SimpleLoadManagerImpl.this.realtimeMemoryLoadFactor));
            }
        });
        ResourceQuota defaultQuota = this.pulsar.getBrokerService().getBundlesQuotas().getDefaultResourceQuota().join();
        this.compareAndWriteQuota(null, defaultQuota, this.realtimeAvgResourceQuota);
        Map<String, ResourceQuota> quotas = this.realtimeResourceQuotas.get();
        for (Map.Entry<String, ResourceQuota> entry : quotas.entrySet()) {
            String bundle = entry.getKey();
            ResourceQuota oldQuota = this.pulsar.getBrokerService().getBundlesQuotas().getResourceQuota(bundle).join();
            this.compareAndWriteQuota(bundle, oldQuota, entry.getValue());
        }
    }

    private synchronized void doLoadRanking() {
        ResourceUnitRanking.setCpuUsageByMsgRate((double)this.realtimeCpuLoadFactor);
        String strategy = this.getLoadBalancerPlacementStrategy();
        log.info("doLoadRanking - load balancing strategy: {}", (Object)strategy);
        if (!this.currentLoadReports.isEmpty()) {
            TreeMap<Long, Set> newSortedRankings = new TreeMap<Long, Set>();
            HashMap<ResourceUnit, ResourceUnitRanking> newResourceUnitRankings = new HashMap<ResourceUnit, ResourceUnitRanking>();
            ResourceQuota defaultResourceQuota = this.pulsar.getBrokerService().getBundlesQuotas().getDefaultResourceQuota().join();
            for (Map.Entry<ResourceUnit, LoadReport> entry : this.currentLoadReports.entrySet()) {
                ResourceUnit resourceUnit = entry.getKey();
                LoadReport loadReport = entry.getValue();
                Set loadedBundles = loadReport.getBundles();
                Set<String> preAllocatedBundles = null;
                if (this.resourceUnitRankings.containsKey(resourceUnit)) {
                    preAllocatedBundles = this.resourceUnitRankings.get(resourceUnit).getPreAllocatedBundles();
                    preAllocatedBundles.removeAll(loadedBundles);
                } else {
                    preAllocatedBundles = new HashSet();
                }
                ResourceQuota allocatedQuota = this.getTotalAllocatedQuota(loadedBundles);
                ResourceQuota preAllocatedQuota = this.getTotalAllocatedQuota(preAllocatedBundles);
                ResourceUnitRanking ranking = new ResourceUnitRanking(loadReport.getSystemResourceUsage(), loadedBundles, allocatedQuota, preAllocatedBundles, preAllocatedQuota);
                newResourceUnitRankings.put(resourceUnit, ranking);
                double loadPercentage = ranking.getEstimatedLoadPercentage();
                long maxCapacity = ranking.estimateMaxCapacity(defaultResourceQuota);
                long finalRank = 0L;
                if (strategy.equals(LOADBALANCER_STRATEGY_LLS)) {
                    finalRank = (long)loadPercentage;
                } else if (strategy.equals(LOADBALANCER_STRATEGY_LEAST_MSG)) {
                    finalRank = (long)ranking.getEstimatedMessageRate();
                } else {
                    double idleRatio = (100.0 - loadPercentage) / 100.0;
                    finalRank = (long)((double)maxCapacity * idleRatio * idleRatio);
                }
                newSortedRankings.computeIfAbsent(finalRank, k -> new HashSet()).add(entry.getKey());
                if (log.isDebugEnabled()) {
                    log.debug("Added Resource Unit [{}] with Rank [{}]", (Object)entry.getKey().getResourceId(), (Object)finalRank);
                }
                if (!resourceUnit.getResourceId().equals(this.pulsar.getBrokerId())) continue;
                this.updateLoadBalancingMetrics(this.pulsar.getAdvertisedAddress(), finalRank, ranking);
            }
            this.updateBrokerToNamespaceToBundle();
            this.sortedRankings.set(newSortedRankings);
            this.resourceUnitRankings = newResourceUnitRankings;
        } else {
            log.info("Leader broker[{}] No ResourceUnits to rank this run, Using Old Ranking", (Object)this.pulsar.getBrokerId());
        }
    }

    @Override
    public List<Metrics> getLoadBalancingMetrics() {
        List<Metrics> metrics = this.loadBalancingMetrics.get();
        return metrics;
    }

    private void updateLoadBalancingMetrics(String hostname, long finalRank, ResourceUnitRanking ranking) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        HashMap<String, String> dimensions = new HashMap<String, String>();
        dimensions.put("broker", hostname);
        Metrics m = Metrics.create(dimensions);
        m.put("brk_lb_load_rank", (Object)finalRank);
        m.put("brk_lb_quota_pct_cpu", (Object)ranking.getAllocatedLoadPercentageCPU());
        m.put("brk_lb_quota_pct_memory", (Object)ranking.getAllocatedLoadPercentageMemory());
        m.put("brk_lb_quota_pct_bandwidth_in", (Object)ranking.getAllocatedLoadPercentageBandwidthIn());
        m.put("brk_lb_quota_pct_bandwidth_out", (Object)ranking.getAllocatedLoadPercentageBandwidthOut());
        metrics.add(m);
        this.loadBalancingMetrics.set(metrics);
    }

    private synchronized ResourceUnit findBrokerForPlacement(Multimap<Long, ResourceUnit> candidates, ServiceUnitId serviceUnit) {
        long underloadThreshold = this.getLoadBalancerBrokerUnderloadedThresholdPercentage();
        long overloadThreshold = this.getLoadBalancerBrokerOverloadedThresholdPercentage();
        ResourceQuota defaultQuota = this.pulsar.getBrokerService().getBundlesQuotas().getDefaultResourceQuota().join();
        double minLoadPercentage = 101.0;
        long maxAvailability = -1L;
        ResourceUnit idleRU = null;
        ResourceUnit maxAvailableRU = null;
        ResourceUnit randomRU = null;
        ResourceUnit selectedRU = null;
        ResourceUnitRanking selectedRanking = null;
        String serviceUnitId = serviceUnit.toString();
        boolean unboundedRanks = this.getLoadBalancerPlacementStrategy().equals(LOADBALANCER_STRATEGY_LEAST_MSG);
        long randomBrokerIndex = candidates.size() > 0 ? this.brokerRotationCursor % (long)candidates.size() : 0L;
        for (Map.Entry candidateOwner : candidates.entries()) {
            ResourceUnit candidate = (ResourceUnit)candidateOwner.getValue();
            --randomBrokerIndex;
            if (!this.resourceUnitRankings.containsKey(candidate)) continue;
            ResourceUnitRanking ranking = this.resourceUnitRankings.get(candidate);
            if (ranking.isServiceUnitLoaded(serviceUnitId)) {
                ranking.removeLoadedServiceUnit(serviceUnitId, this.getResourceQuota(serviceUnitId));
            }
            if (randomBrokerIndex < 0L && randomRU == null) {
                randomRU = candidate;
            }
            double loadPercentage = ranking.getEstimatedLoadPercentage();
            double availablePercentage = Math.max(0.0, (100.0 - loadPercentage) / 100.0);
            long availability = (long)((double)ranking.estimateMaxCapacity(defaultQuota) * availablePercentage);
            if (availability > maxAvailability) {
                maxAvailability = availability;
                maxAvailableRU = candidate;
            }
            if (ranking.isIdle()) {
                if (idleRU != null) continue;
                idleRU = candidate;
                continue;
            }
            if (selectedRU == null) {
                selectedRU = candidate;
                selectedRanking = ranking;
                minLoadPercentage = loadPercentage;
                continue;
            }
            if ((unboundedRanks ? ranking.compareMessageRateTo(selectedRanking) : ranking.compareToOtherRanking(selectedRanking)) >= 0) continue;
            minLoadPercentage = loadPercentage;
            selectedRU = candidate;
            selectedRanking = ranking;
        }
        if (minLoadPercentage > (double)underloadThreshold && idleRU != null || selectedRU == null) {
            selectedRU = idleRU;
        } else if (minLoadPercentage >= 100.0 && randomRU != null && !unboundedRanks) {
            selectedRU = randomRU;
        } else if (minLoadPercentage > (double)overloadThreshold && !unboundedRanks) {
            selectedRU = maxAvailableRU;
        }
        if (selectedRU != null) {
            this.brokerRotationCursor = (this.brokerRotationCursor + 1L) % 1000000L;
            ResourceUnitRanking ranking = this.resourceUnitRankings.get(selectedRU);
            String loadPercentageDesc = ranking.getEstimatedLoadPercentageString();
            log.info("Assign {} to {} with ({}).", new Object[]{serviceUnitId, selectedRU.getResourceId(), loadPercentageDesc});
            if (!ranking.isServiceUnitPreAllocated(serviceUnitId)) {
                String namespaceName = LoadManagerShared.getNamespaceNameFromBundleName(serviceUnitId);
                String bundleRange = LoadManagerShared.getBundleRangeFromBundleName(serviceUnitId);
                ResourceQuota quota = this.getResourceQuota(serviceUnitId);
                ((ConcurrentOpenHashSet)((ConcurrentOpenHashMap)this.brokerToNamespaceToBundleRange.computeIfAbsent((Object)selectedRU.getResourceId(), k -> ConcurrentOpenHashMap.newBuilder().build())).computeIfAbsent((Object)namespaceName, k -> ConcurrentOpenHashSet.newBuilder().build())).add((Object)bundleRange);
                ranking.addPreAllocatedServiceUnit(serviceUnitId, quota);
                this.resourceUnitRankings.put(selectedRU, ranking);
            }
        }
        return selectedRU;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Multimap<Long, ResourceUnit> getFinalCandidates(ServiceUnitId serviceUnit, Map<Long, Set<ResourceUnit>> availableBrokers) {
        Set<String> set = this.brokerCandidateCache;
        synchronized (set) {
            TreeMultimap result = TreeMultimap.create();
            this.availableBrokersCache.clear();
            for (Set<ResourceUnit> set2 : availableBrokers.values()) {
                for (ResourceUnit resourceUnit : set2) {
                    this.availableBrokersCache.add(resourceUnit.getResourceId());
                }
            }
            this.brokerCandidateCache.clear();
            try {
                LoadManagerShared.applyNamespacePolicies(serviceUnit, this.policies, this.brokerCandidateCache, this.availableBrokersCache, this.brokerTopicLoadingPredicate);
            }
            catch (Exception e) {
                log.warn("Error when trying to apply policies", (Throwable)e);
                for (Map.Entry<Long, Set<ResourceUnit>> entry : availableBrokers.entrySet()) {
                    result.putAll((Object)entry.getKey(), (Iterable)entry.getValue());
                }
                return result;
            }
            LoadManagerShared.removeMostServicingBrokersForNamespace(serviceUnit.toString(), this.brokerCandidateCache, this.brokerToNamespaceToBundleRange);
            for (Map.Entry entry : availableBrokers.entrySet()) {
                Long l = (Long)entry.getKey();
                Set resourceUnits = (Set)entry.getValue();
                for (ResourceUnit resourceUnit : resourceUnits) {
                    if (!this.brokerCandidateCache.contains(resourceUnit.getResourceId())) continue;
                    result.put((Object)l, (Object)resourceUnit);
                }
            }
            return result;
        }
    }

    @Override
    public Optional<ResourceUnit> getLeastLoaded(ServiceUnitId serviceUnit) throws Exception {
        return Optional.ofNullable(this.getLeastLoadedBroker(serviceUnit, this.getAvailableBrokers(serviceUnit)));
    }

    public Multimap<Long, ResourceUnit> getResourceAvailabilityFor(ServiceUnitId serviceUnitId) throws Exception {
        return this.getFinalCandidates(serviceUnitId, this.getAvailableBrokers(serviceUnitId));
    }

    private Map<Long, Set<ResourceUnit>> getAvailableBrokers(ServiceUnitId serviceUnitId) throws Exception {
        Map<Long, Set<ResourceUnit>> availableBrokers = this.sortedRankings.get();
        if (availableBrokers.isEmpty()) {
            List activeBrokers = (List)this.loadReports.listLocks("/loadbalance/brokers").join();
            Collections.shuffle(activeBrokers);
            availableBrokers = new HashMap<Long, Set<ResourceUnit>>();
            for (String broker : activeBrokers) {
                SimpleResourceUnit resourceUnit = new SimpleResourceUnit(broker, new PulsarResourceDescription());
                availableBrokers.computeIfAbsent(0L, key -> new TreeSet()).add(resourceUnit);
            }
            log.info("Choosing at random from broker list: [{}]", availableBrokers.values());
        }
        return availableBrokers;
    }

    private synchronized ResourceUnit getLeastLoadedBroker(ServiceUnitId serviceUnit, Map<Long, Set<ResourceUnit>> availableBrokers) {
        ResourceUnit selectedBroker = null;
        for (Map.Entry<ResourceUnit, ResourceUnitRanking> entry : this.resourceUnitRankings.entrySet()) {
            ResourceUnit resourceUnit = entry.getKey();
            ResourceUnitRanking ranking = entry.getValue();
            if (!ranking.isServiceUnitPreAllocated(serviceUnit.toString())) continue;
            return resourceUnit;
        }
        Multimap<Long, ResourceUnit> finalCandidates = this.getFinalCandidates(serviceUnit, availableBrokers);
        try {
            Set<String> activeBrokers = this.getAvailableBrokers();
            Iterator candidateIterator = finalCandidates.entries().iterator();
            while (candidateIterator.hasNext()) {
                Map.Entry candidate = (Map.Entry)candidateIterator.next();
                String candidateBrokerName = ((ResourceUnit)candidate.getValue()).getResourceId();
                if (activeBrokers.contains(candidateBrokerName)) continue;
                candidateIterator.remove();
            }
        }
        catch (Exception e) {
            log.warn("Error during attempt to remove inactive brokers while searching for least active broker", (Throwable)e);
        }
        if (finalCandidates.size() > 0) {
            selectedBroker = this.getLoadBalancerPlacementStrategy().equals(LOADBALANCER_STRATEGY_LLS) || this.getLoadBalancerPlacementStrategy().equals(LOADBALANCER_STRATEGY_LEAST_MSG) ? this.findBrokerForPlacement(finalCandidates, serviceUnit) : this.placementStrategy.findBrokerForPlacement(finalCandidates);
            log.info("Selected : [{}] for ServiceUnit : [{}]", (Object)selectedBroker.getResourceId(), (Object)serviceUnit.toString());
            return selectedBroker;
        }
        log.warn("No broker available to acquire service unit: [{}]", (Object)serviceUnit);
        return null;
    }

    @Override
    public void accept(Notification n) {
        if (n.getPath().startsWith("/loadbalance/brokers")) {
            if (log.isDebugEnabled()) {
                log.debug("Received updated load report from broker node - [{}], scheduling re-ranking of brokers.", (Object)n.getPath());
            }
            this.updateRankingHandle = this.scheduler.submit(this::updateRanking);
        }
    }

    @VisibleForTesting
    public Future<?> getUpdateRankingHandle() {
        return this.updateRankingHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRanking() {
        try {
            Map<ResourceUnit, LoadReport> map = this.currentLoadReports;
            synchronized (map) {
                this.currentLoadReports.clear();
                for (String broker : this.getAvailableBrokers()) {
                    try {
                        String key = String.format("%s/%s", "/loadbalance/brokers", broker);
                        LoadReport lr = (LoadReport)((Optional)this.loadReports.readLock(key).join()).get();
                        SimpleResourceUnit ru = new SimpleResourceUnit(lr.getName(), this.fromLoadReport(lr));
                        this.currentLoadReports.put(ru, lr);
                    }
                    catch (Exception e) {
                        log.warn("Error reading load report from Cache for broker - [{}], [{}]", (Object)broker, (Object)e);
                    }
                }
                this.updateRealtimeResourceQuota();
                this.doLoadRanking();
            }
        }
        catch (Exception e) {
            log.warn("Error reading active brokers list from zookeeper while re-ranking load reports", (Throwable)e);
        }
    }

    public static boolean isAboveLoadLevel(SystemResourceUsage usage, float thresholdPercentage) {
        return usage.bandwidthOut.percentUsage() > thresholdPercentage || usage.bandwidthIn.percentUsage() > thresholdPercentage || usage.cpu.percentUsage() > thresholdPercentage || usage.directMemory.percentUsage() > thresholdPercentage;
    }

    public static boolean isBelowLoadLevel(SystemResourceUsage usage, float thresholdPercentage) {
        return usage.bandwidthOut.percentUsage() < thresholdPercentage && usage.bandwidthIn.percentUsage() < thresholdPercentage && usage.cpu.percentUsage() < thresholdPercentage && usage.directMemory.percentUsage() < thresholdPercentage;
    }

    private static long getRealtimeJvmHeapUsageMBytes() {
        long totalHeapMemoryInBytes = Runtime.getRuntime().totalMemory();
        long freeHeapMemoryInBytes = Runtime.getRuntime().freeMemory();
        long memoryUsageInBytes = totalHeapMemoryInBytes - freeHeapMemoryInBytes;
        long memoryUsageInMBytes = 0L;
        if (memoryUsageInBytes > 0L) {
            memoryUsageInMBytes = memoryUsageInBytes / 0x100000L;
        }
        return memoryUsageInMBytes;
    }

    private long getAverageJvmHeapUsageMBytes() {
        if (this.avgJvmHeapUsageMBytes > 0L) {
            return this.avgJvmHeapUsageMBytes;
        }
        return SimpleLoadManagerImpl.getRealtimeJvmHeapUsageMBytes();
    }

    public SystemResourceUsage getSystemResourceUsage() {
        SystemResourceUsage systemResourceUsage = LoadManagerShared.getSystemResourceUsage(this.brokerHostUsage);
        long memoryUsageInMBytes = this.getAverageJvmHeapUsageMBytes();
        systemResourceUsage.setMemory(new ResourceUsage((double)memoryUsageInMBytes, systemResourceUsage.memory.limit));
        return systemResourceUsage;
    }

    public LoadReport generateLoadReport() throws Exception {
        if (!this.isLoadReportGenerationIntervalPassed()) {
            return this.lastLoadReport;
        }
        return this.generateLoadReportForcefully();
    }

    private LoadReport generateLoadReportForcefully() throws Exception {
        Set<String> set = this.bundleGainsCache;
        synchronized (set) {
            try {
                Set<String> preAllocatedBundles;
                LoadReport loadReport = new LoadReport(this.pulsar.getWebServiceAddress(), this.pulsar.getWebServiceAddressTls(), this.pulsar.getBrokerServiceUrl(), this.pulsar.getBrokerServiceUrlTls());
                loadReport.setProtocols(this.pulsar.getProtocolDataToAdvertise());
                loadReport.setNonPersistentTopicsEnabled(this.pulsar.getConfiguration().isEnableNonPersistentTopics());
                loadReport.setPersistentTopicsEnabled(this.pulsar.getConfiguration().isEnablePersistentTopics());
                loadReport.setName(this.pulsar.getBrokerId());
                loadReport.setBrokerVersionString(this.pulsar.getBrokerVersion());
                SystemResourceUsage systemResourceUsage = this.getSystemResourceUsage();
                loadReport.setOverLoaded(SimpleLoadManagerImpl.isAboveLoadLevel(systemResourceUsage, this.getLoadBalancerBrokerOverloadedThresholdPercentage()));
                loadReport.setUnderLoaded(SimpleLoadManagerImpl.isBelowLoadLevel(systemResourceUsage, this.getLoadBalancerBrokerUnderloadedThresholdPercentage()));
                loadReport.setSystemResourceUsage(systemResourceUsage);
                loadReport.setBundleStats(this.pulsar.getBrokerService().getBundleStats());
                loadReport.setTimestamp(System.currentTimeMillis());
                loadReport.setLoadManagerClassName(this.pulsar.getConfig().getLoadManagerClassName());
                loadReport.setStartTimestamp(System.currentTimeMillis());
                Set oldBundles = this.lastLoadReport.getBundles();
                Set newBundles = loadReport.getBundles();
                this.bundleGainsCache.clear();
                this.bundleLossesCache.clear();
                for (String oldBundle : oldBundles) {
                    if (newBundles.contains(oldBundle)) continue;
                    this.bundleLossesCache.add(oldBundle);
                }
                for (String newBundle : newBundles) {
                    if (oldBundles.contains(newBundle)) continue;
                    this.bundleGainsCache.add(newBundle);
                }
                loadReport.setBundleGains(this.bundleGainsCache);
                loadReport.setBundleLosses(this.bundleLossesCache);
                ResourceQuota allocatedQuota = this.getTotalAllocatedQuota(newBundles);
                loadReport.setAllocatedCPU((allocatedQuota.getMsgRateIn() + allocatedQuota.getMsgRateOut()) * this.realtimeCpuLoadFactor);
                loadReport.setAllocatedMemory(allocatedQuota.getMemory());
                loadReport.setAllocatedBandwidthIn(allocatedQuota.getBandwidthIn());
                loadReport.setAllocatedBandwidthOut(allocatedQuota.getBandwidthOut());
                loadReport.setAllocatedMsgRateIn(allocatedQuota.getMsgRateIn());
                loadReport.setAllocatedMsgRateOut(allocatedQuota.getMsgRateOut());
                SimpleResourceUnit resourceUnit = new SimpleResourceUnit(loadReport.getName(), this.fromLoadReport(loadReport));
                if (this.resourceUnitRankings.containsKey(resourceUnit)) {
                    preAllocatedBundles = this.resourceUnitRankings.get(resourceUnit).getPreAllocatedBundles();
                    preAllocatedBundles.removeAll(newBundles);
                } else {
                    preAllocatedBundles = new HashSet<String>();
                }
                ResourceQuota preAllocatedQuota = this.getTotalAllocatedQuota(preAllocatedBundles);
                loadReport.setPreAllocatedCPU((preAllocatedQuota.getMsgRateIn() + preAllocatedQuota.getMsgRateOut()) * this.realtimeCpuLoadFactor);
                loadReport.setPreAllocatedMemory(preAllocatedQuota.getMemory());
                loadReport.setPreAllocatedBandwidthIn(preAllocatedQuota.getBandwidthIn());
                loadReport.setPreAllocatedBandwidthOut(preAllocatedQuota.getBandwidthOut());
                loadReport.setPreAllocatedMsgRateIn(preAllocatedQuota.getMsgRateIn());
                loadReport.setPreAllocatedMsgRateOut(preAllocatedQuota.getMsgRateOut());
                return loadReport;
            }
            catch (Exception e) {
                log.error("[{}] Failed to generate LoadReport for broker, reason [{}]", (Object)e.getMessage(), (Object)e);
                throw e;
            }
        }
    }

    @Override
    public void setLoadReportForceUpdateFlag() {
        this.forceLoadReportUpdate = true;
    }

    @Override
    public void writeLoadReportOnZookeeper() throws Exception {
        long realtimeJvmHeapUsage = SimpleLoadManagerImpl.getRealtimeJvmHeapUsageMBytes();
        int minInterval = this.pulsar.getConfiguration().getLoadBalancerReportUpdateMinIntervalMillis();
        if (this.avgJvmHeapUsageMBytes <= 0L) {
            this.avgJvmHeapUsageMBytes = realtimeJvmHeapUsage;
        } else {
            long weight = Math.max(1L, TimeUnit.SECONDS.toMillis(120L) / (long)minInterval);
            this.avgJvmHeapUsageMBytes = ((weight - 1L) * this.avgJvmHeapUsageMBytes + realtimeJvmHeapUsage) / weight;
        }
        boolean needUpdate = false;
        if (this.lastLoadReport == null || this.forceLoadReportUpdate) {
            needUpdate = true;
            this.forceLoadReportUpdate = false;
        } else {
            int maxUpdateIntervalInMinutes;
            long timestampNow = System.currentTimeMillis();
            long timeElapsedSinceLastReport = timestampNow - this.lastLoadReport.getTimestamp();
            if (timeElapsedSinceLastReport > TimeUnit.MINUTES.toMillis(maxUpdateIntervalInMinutes = this.pulsar.getConfiguration().getLoadBalancerReportUpdateMaxIntervalMinutes())) {
                needUpdate = true;
            } else if (timeElapsedSinceLastReport > (long)minInterval) {
                long oldBundleCount = this.lastLoadReport.getNumBundles();
                long newBundleCount = this.pulsar.getBrokerService().getNumberOfNamespaceBundles();
                long bundleCountChange = Math.abs(oldBundleCount - newBundleCount);
                if (newBundleCount != oldBundleCount) {
                    needUpdate = true;
                }
                if (!needUpdate && timestampNow - this.lastResourceUsageTimestamp > TimeUnit.MINUTES.toMillis(this.pulsar.getConfiguration().getLoadBalancerHostUsageCheckIntervalMinutes())) {
                    SystemResourceUsage oldUsage = this.lastLoadReport.getSystemResourceUsage();
                    SystemResourceUsage newUsage = this.getSystemResourceUsage();
                    this.lastResourceUsageTimestamp = timestampNow;
                    double cpuChange = newUsage.cpu.limit > 0.0 ? (newUsage.cpu.usage - oldUsage.cpu.usage) * 100.0 / newUsage.cpu.limit : 0.0;
                    double memChange = newUsage.memory.limit > 0.0 ? (newUsage.memory.usage - oldUsage.memory.usage) * 100.0 / newUsage.memory.limit : 0.0;
                    double directMemChange = newUsage.directMemory.limit > 0.0 ? (newUsage.directMemory.usage - oldUsage.directMemory.usage) * 100.0 / newUsage.directMemory.limit : 0.0;
                    double bandwidthOutChange = newUsage.bandwidthOut.limit > 0.0 ? (newUsage.bandwidthOut.usage - oldUsage.bandwidthOut.usage) * 100.0 / newUsage.bandwidthOut.limit : 0.0;
                    double bandwidthInChange = newUsage.bandwidthIn.limit > 0.0 ? (newUsage.bandwidthIn.usage - oldUsage.bandwidthIn.usage) * 100.0 / newUsage.bandwidthIn.limit : 0.0;
                    long resourceChange = (long)Math.min(100.0, Math.max(Math.abs(cpuChange), Math.max(Math.abs(directMemChange), Math.max(Math.abs(memChange), Math.max(Math.abs(bandwidthOutChange), Math.abs(bandwidthInChange))))));
                    if (resourceChange > (long)this.pulsar.getConfiguration().getLoadBalancerReportUpdateThresholdPercentage()) {
                        needUpdate = true;
                        log.info("LoadReport update triggered by change on resource usage, detal ({}).", (Object)String.format("cpu: %.1f%%, mem: %.1f%%, directMemory: %.1f%%, bandwidthIn: %.1f%%, bandwidthOut: %.1f%%)", cpuChange, memChange, directMemChange, bandwidthInChange, bandwidthOutChange));
                    }
                }
            }
        }
        if (needUpdate) {
            LoadReport lr = this.generateLoadReportForcefully();
            this.brokerLock.updateValue((Object)lr).join();
            this.lastLoadReport = lr;
            this.lastResourceUsageTimestamp = lr.getTimestamp();
            this.doNamespaceBundleSplit();
        }
    }

    private boolean isLoadReportGenerationIntervalPassed() {
        long timeSinceLastGenMillis = System.currentTimeMillis() - this.lastLoadReport.getTimestamp();
        return timeSinceLastGenMillis > (long)this.pulsar.getConfiguration().getLoadBalancerReportUpdateMinIntervalMillis();
    }

    private boolean isBrokerAvailableForRebalancing(String bundleName, long maxLoadLevel) {
        NamespaceName namespaceName = NamespaceName.get((String)LoadManagerShared.getNamespaceNameFromBundleName(bundleName));
        Map<Long, Set<ResourceUnit>> availableBrokers = this.sortedRankings.get();
        Multimap<Long, ResourceUnit> brokers = this.getFinalCandidates((ServiceUnitId)namespaceName, availableBrokers);
        for (ResourceUnit broker : brokers.values()) {
            LoadReport currentLoadReport = this.currentLoadReports.get(broker);
            if (!SimpleLoadManagerImpl.isBelowLoadLevel(currentLoadReport.getSystemResourceUsage(), maxLoadLevel)) continue;
            return true;
        }
        return false;
    }

    private synchronized void updateBrokerToNamespaceToBundle() {
        this.resourceUnitRankings.forEach((resourceUnit, ranking) -> {
            String broker = resourceUnit.getResourceId();
            Set loadedBundles = ranking.getLoadedBundles();
            Set preallocatedBundles = this.resourceUnitRankings.get(resourceUnit).getPreAllocatedBundles();
            ConcurrentOpenHashMap namespaceToBundleRange = (ConcurrentOpenHashMap)this.brokerToNamespaceToBundleRange.computeIfAbsent((Object)broker, k -> ConcurrentOpenHashMap.newBuilder().build());
            namespaceToBundleRange.clear();
            LoadManagerShared.fillNamespaceToBundlesMap(loadedBundles, (ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>)namespaceToBundleRange);
            LoadManagerShared.fillNamespaceToBundlesMap(preallocatedBundles, (ConcurrentOpenHashMap<String, ConcurrentOpenHashSet<String>>)namespaceToBundleRange);
        });
    }

    private void unloadNamespacesFromOverLoadedBrokers(Map<ResourceUnit, String> namespaceBundlesToUnload) {
        for (Map.Entry<ResourceUnit, String> bundle : namespaceBundlesToUnload.entrySet()) {
            String brokerName = bundle.getKey().getResourceId();
            String bundleName = bundle.getValue();
            try {
                if (this.unloadedHotNamespaceCache.getIfPresent((Object)bundleName) == null) {
                    if (LoadManagerShared.isLoadSheddingEnabled(this.pulsar)) {
                        log.info("Unloading namespace {} from overloaded broker {}", (Object)bundleName, (Object)brokerName);
                        this.pulsar.getAdminClient().namespaces().unloadNamespaceBundle(LoadManagerShared.getNamespaceNameFromBundleName(bundleName), LoadManagerShared.getBundleRangeFromBundleName(bundleName));
                        log.info("Successfully unloaded namespace {} from broker {}", (Object)bundleName, (Object)brokerName);
                    } else {
                        log.info("DRY RUN: Unload in Load Shedding is disabled. Namespace {} would have been unloaded from overloaded broker {} otherwise.", (Object)bundleName, (Object)brokerName);
                    }
                    this.unloadedHotNamespaceCache.put((Object)bundleName, (Object)System.currentTimeMillis());
                    continue;
                }
                log.info("Can't unload Namespace {} because it was unloaded last at {} and unload interval has not exceeded.", (Object)bundleName, (Object)LocalDateTime.now());
            }
            catch (Exception e) {
                log.warn("ERROR failed to unload the bundle {} from overloaded broker {}", new Object[]{bundleName, brokerName, e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doLoadShedding() {
        long overloadThreshold = this.getLoadBalancerBrokerOverloadedThresholdPercentage();
        long comfortLoadLevel = this.getLoadBalancerBrokerComfortLoadThresholdPercentage();
        log.info("Running load shedding task as leader broker, overload threshold {}, comfort loadlevel {}", (Object)overloadThreshold, (Object)comfortLoadLevel);
        HashMap<ResourceUnit, String> namespaceBundlesToBeUnloaded = new HashMap<ResourceUnit, String>();
        Map<ResourceUnit, LoadReport> map = this.currentLoadReports;
        synchronized (map) {
            for (Map.Entry<ResourceUnit, LoadReport> entry : this.currentLoadReports.entrySet()) {
                ResourceUnit overloadedRU = entry.getKey();
                LoadReport lr = entry.getValue();
                if (!SimpleLoadManagerImpl.isAboveLoadLevel(lr.getSystemResourceUsage(), overloadThreshold)) continue;
                SystemResourceUsage.ResourceType bottleneckResourceType = lr.getBottleneckResourceType();
                TreeMap bundleStats = lr.getSortedBundleStats(bottleneckResourceType);
                if (bundleStats == null) {
                    log.warn("Null bundle stats for bundle {}", (Object)lr.getName());
                    continue;
                }
                if (bundleStats.size() == 1) {
                    String bundleName = (String)lr.getBundleStats().keySet().iterator().next();
                    log.warn("HIGH USAGE WARNING : Sole namespace bundle {} is overloading broker {}. No Load Shedding will be done on this broker", (Object)bundleName, (Object)overloadedRU.getResourceId());
                    continue;
                }
                Iterator iterator = bundleStats.entrySet().iterator();
                if (!iterator.hasNext()) continue;
                Map.Entry bundleStat = iterator.next();
                String bundleName = (String)bundleStat.getKey();
                NamespaceBundleStats stats = (NamespaceBundleStats)bundleStat.getValue();
                if (this.isBrokerAvailableForRebalancing((String)bundleStat.getKey(), comfortLoadLevel)) {
                    log.info("Namespace bundle {} will be unloaded from overloaded broker {}, bundle stats (topics: {}, producers {}, consumers {}, bandwidthIn {}, bandwidthOut {})", new Object[]{bundleName, overloadedRU.getResourceId(), stats.topics, stats.producerCount, stats.consumerCount, stats.msgThroughputIn, stats.msgThroughputOut});
                    namespaceBundlesToBeUnloaded.put(overloadedRU, bundleName);
                    continue;
                }
                log.info("Unable to shed load from broker {}, no brokers with enough capacity available for re-balancing {}", (Object)overloadedRU.getResourceId(), (Object)bundleName);
            }
        }
        this.unloadNamespacesFromOverLoadedBrokers(namespaceBundlesToBeUnloaded);
    }

    @Override
    public void doNamespaceBundleSplit() throws Exception {
        int maxBundleCount = this.pulsar.getConfiguration().getLoadBalancerNamespaceMaximumBundles();
        long maxBundleTopics = this.pulsar.getConfiguration().getLoadBalancerNamespaceBundleMaxTopics();
        long maxBundleSessions = this.pulsar.getConfiguration().getLoadBalancerNamespaceBundleMaxSessions();
        long maxBundleMsgRate = this.pulsar.getConfiguration().getLoadBalancerNamespaceBundleMaxMsgRate();
        long maxBundleBandwidth = (long)this.pulsar.getConfiguration().getLoadBalancerNamespaceBundleMaxBandwidthMbytes() * 0x100000L;
        log.info("Running namespace bundle split with thresholds: topics {}, sessions {}, msgRate {}, bandwidth {}, maxBundles {}", new Object[]{maxBundleTopics, maxBundleSessions, maxBundleMsgRate, maxBundleBandwidth, maxBundleCount});
        if (this.lastLoadReport == null || this.lastLoadReport.getBundleStats() == null) {
            return;
        }
        Map bundleStats = this.lastLoadReport.getBundleStats();
        HashSet<String> bundlesToBeSplit = new HashSet<String>();
        for (Map.Entry statsEntry : bundleStats.entrySet()) {
            String bundleName = (String)statsEntry.getKey();
            NamespaceBundleStats stats = (NamespaceBundleStats)statsEntry.getValue();
            long totalSessions = stats.consumerCount + stats.producerCount;
            double totalMsgRate = stats.msgRateIn + stats.msgRateOut;
            double totalBandwidth = stats.msgThroughputIn + stats.msgThroughputOut;
            boolean needSplit = false;
            if (stats.topics > maxBundleTopics || maxBundleSessions > 0L && totalSessions > maxBundleSessions || totalMsgRate > (double)maxBundleMsgRate || totalBandwidth > (double)maxBundleBandwidth) {
                if (stats.topics <= 1L) {
                    log.info("Unable to split hot namespace bundle {} since there is only one topic.", (Object)bundleName);
                } else {
                    NamespaceName namespaceName = NamespaceName.get((String)LoadManagerShared.getNamespaceNameFromBundleName(bundleName));
                    int numBundles = this.pulsar.getNamespaceService().getBundleCount(namespaceName);
                    if (numBundles >= maxBundleCount) {
                        log.info("Unable to split hot namespace bundle {} since the namespace has too many bundles.", (Object)bundleName);
                    } else {
                        needSplit = true;
                    }
                }
            }
            if (!needSplit) continue;
            if (this.getLoadBalancerAutoBundleSplitEnabled()) {
                log.info("Will split hot namespace bundle {}, topics {}, producers+consumers {}, msgRate in+out {}, bandwidth in+out {}", new Object[]{bundleName, stats.topics, totalSessions, totalMsgRate, totalBandwidth});
                bundlesToBeSplit.add(bundleName);
                continue;
            }
            log.info("DRY RUN - split hot namespace bundle {}, topics {}, producers+consumers {}, msgRate in+out {}, bandwidth in+out {}", new Object[]{bundleName, stats.topics, totalSessions, totalMsgRate, totalBandwidth});
        }
        if (bundlesToBeSplit.size() > 0) {
            for (String bundleName : bundlesToBeSplit) {
                try {
                    this.pulsar.getAdminClient().namespaces().splitNamespaceBundle(LoadManagerShared.getNamespaceNameFromBundleName(bundleName), LoadManagerShared.getBundleRangeFromBundleName(bundleName), this.pulsar.getConfiguration().isLoadBalancerAutoUnloadSplitBundlesEnabled(), null);
                    log.info("Successfully split namespace bundle {}", (Object)bundleName);
                }
                catch (Exception e) {
                    log.error("Failed to split namespace bundle {}", (Object)bundleName, (Object)e);
                }
            }
            this.setLoadReportForceUpdateFlag();
        }
    }

    @Override
    public String setNamespaceBundleAffinity(String bundle, String broker) {
        if (StringUtils.isBlank((CharSequence)broker)) {
            return this.bundleBrokerAffinityMap.remove(bundle);
        }
        return this.bundleBrokerAffinityMap.put(bundle, broker);
    }

    @Override
    public void stop() throws PulsarServerException {
        try {
            this.loadReports.close();
            this.scheduler.shutdownNow();
            this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            throw new PulsarServerException((Throwable)e);
        }
    }
}

