/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client;

import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.ConnectException;

public final class ResponseHandlerUtils {
    private ResponseHandlerUtils() {
    }

    public static RuntimeException propagate(Request request, Throwable exception) {
        if (exception instanceof ConnectException) {
            throw new UncheckedIOException("Server refused connection: " + ResponseHandlerUtils.urlFor(request), (ConnectException)exception);
        }
        if (exception instanceof IOException) {
            throw new UncheckedIOException("Failed communicating with server: " + ResponseHandlerUtils.urlFor(request), (IOException)exception);
        }
        Throwables.throwIfUnchecked((Throwable)exception);
        throw new RuntimeException(exception);
    }

    public static byte[] readResponseBytes(Request request, Response response) {
        try {
            return ByteStreams.toByteArray((InputStream)response.getInputStream());
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed reading response from server: " + ResponseHandlerUtils.urlFor(request), e);
        }
    }

    private static String urlFor(Request request) {
        return request.getUri().toASCIIString();
    }
}

