/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.maven.api.cache.BatchRequestException;
import org.apache.maven.api.cache.MavenExecutionException;
import org.apache.maven.api.cache.RequestCache;
import org.apache.maven.api.cache.RequestResult;
import org.apache.maven.api.services.Request;
import org.apache.maven.api.services.Result;
import org.apache.maven.impl.cache.CachingSupplier;

public abstract class AbstractRequestCache
implements RequestCache {
    public <REQ extends Request<?>, REP extends Result<REQ>> REP request(REQ req, Function<REQ, REP> supplier) {
        CachingSupplier<REQ, REP> cs = this.doCache(req, supplier);
        return (REP)((Result)cs.apply(req));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <REQ extends Request<?>, REP extends Result<REQ>> List<REP> requests(List<REQ> reqs, Function<List<REQ>, List<REP>> supplier) {
        HashMap<Request, Object> nonCachedResults = new HashMap<Request, Object>();
        ArrayList<RequestResult> allResults = new ArrayList<RequestResult>(reqs.size());
        Function<Request, Result> individualSupplier = req -> {
            Map map = nonCachedResults;
            synchronized (map) {
                while (!nonCachedResults.containsKey(req)) {
                    try {
                        nonCachedResults.wait();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
                Object val = nonCachedResults.get(req);
                if (val instanceof CachingSupplier.AltRes) {
                    CachingSupplier.AltRes altRes = (CachingSupplier.AltRes)val;
                    AbstractRequestCache.uncheckedThrow(altRes.throwable);
                }
                return (Result)val;
            }
        };
        ArrayList<CachingSupplier<Request, Result>> suppliers = new ArrayList<CachingSupplier<Request, Result>>(reqs.size());
        ArrayList<Request> nonCached = new ArrayList<Request>();
        for (Request req2 : reqs) {
            CachingSupplier<Request, Result> cs = this.doCache(req2, individualSupplier);
            suppliers.add(cs);
            if (cs.getValue() != null) continue;
            nonCached.add(req2);
        }
        if (!nonCached.isEmpty()) {
            HashMap<Request, Object> hashMap = nonCachedResults;
            synchronized (hashMap) {
                try {
                    List<REP> reps = supplier.apply(nonCached);
                    for (int i = 0; i < reps.size(); ++i) {
                        nonCachedResults.put((Request)nonCached.get(i), reps.get(i));
                    }
                }
                catch (MavenExecutionException e) {
                    for (Request req3 : nonCached) {
                        nonCachedResults.put(req3, new CachingSupplier.AltRes(e.getCause()));
                    }
                }
                finally {
                    nonCachedResults.notifyAll();
                }
            }
        }
        boolean hasFailures = false;
        for (int i = 0; i < reqs.size(); ++i) {
            Request req4 = (Request)reqs.get(i);
            CachingSupplier cs = (CachingSupplier)suppliers.get(i);
            try {
                Result value = (Result)cs.apply(req4);
                allResults.add(new RequestResult(req4, value, null));
                continue;
            }
            catch (Throwable t) {
                hasFailures = true;
                allResults.add(new RequestResult(req4, null, t));
            }
        }
        if (hasFailures) {
            BatchRequestException exception = new BatchRequestException("One or more requests failed", allResults);
            for (RequestResult result : allResults) {
                if (result.error() == null) continue;
                exception.addSuppressed(result.error());
            }
            throw exception;
        }
        return allResults.stream().map(RequestResult::result).toList();
    }

    protected abstract <REQ extends Request<?>, REP extends Result<REQ>> CachingSupplier<REQ, REP> doCache(REQ var1, Function<REQ, REP> var2);

    protected static <T extends Throwable> void uncheckedThrow(Throwable t) throws T {
        throw t;
    }
}

