/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.monitor;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.apache.lucene.search.Query;

public class MonitorQuery {
    private final String id;
    private final Query query;
    private final String queryString;
    private final Map<String, String> metadata;

    public MonitorQuery(String id, Query query, String queryString, Map<String, String> metadata) {
        this.id = id;
        this.query = query;
        this.queryString = queryString;
        this.metadata = Collections.unmodifiableMap(new TreeMap<String, String>(metadata));
        MonitorQuery.checkNullEntries(this.metadata);
    }

    public MonitorQuery(String id, Query query) {
        this(id, query, null, Collections.emptyMap());
    }

    private static void checkNullEntries(Map<String, String> metadata) {
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            if (entry.getValue() != null) continue;
            throw new IllegalArgumentException("Null value for key " + entry.getKey() + " in metadata map");
        }
    }

    public String getId() {
        return this.id;
    }

    public Query getQuery() {
        return this.query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MonitorQuery that = (MonitorQuery)o;
        return Objects.equals(this.id, that.id) && Objects.equals(this.query, that.query) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.query, this.metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.id);
        sb.append(": ");
        if (this.queryString == null) {
            sb.append(this.query.toString());
        } else {
            sb.append(this.queryString);
        }
        if (this.metadata.size() != 0) {
            sb.append(" { ");
            int n = this.metadata.size();
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue());
                if (--n <= 0) continue;
                sb.append(", ");
            }
            sb.append(" }");
        }
        return sb.toString();
    }
}

