/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;

public class SubscriptionWrapper<K> {
    static final byte VERSION_0 = 0;
    static final byte VERSION_1 = 1;
    static final byte CURRENT_VERSION = 1;
    private final long[] hash;
    private final Instruction instruction;
    private final byte version;
    private final K primaryKey;
    private final Integer primaryPartition;

    public SubscriptionWrapper(long[] hash, Instruction instruction, K primaryKey, Integer primaryPartition) {
        this(hash, instruction, primaryKey, 1, primaryPartition);
    }

    public SubscriptionWrapper(long[] hash, Instruction instruction, K primaryKey, byte version, Integer primaryPartition) {
        Objects.requireNonNull(instruction, "instruction cannot be null. Required by downstream processor.");
        Objects.requireNonNull(primaryKey, "primaryKey cannot be null. Required by downstream processor.");
        if (version < 0 || version > 1) {
            throw new UnsupportedVersionException("SubscriptionWrapper does not support version " + version);
        }
        this.instruction = instruction;
        this.hash = hash;
        this.primaryKey = primaryKey;
        this.version = version;
        this.primaryPartition = primaryPartition;
    }

    public Instruction instruction() {
        return this.instruction;
    }

    public long[] hash() {
        return this.hash;
    }

    public K primaryKey() {
        return this.primaryKey;
    }

    public byte version() {
        return this.version;
    }

    public Integer primaryPartition() {
        return this.primaryPartition;
    }

    public String toString() {
        return "SubscriptionWrapper{version=" + this.version + ", primaryKey=" + String.valueOf(this.primaryKey) + ", instruction=" + String.valueOf((Object)this.instruction) + ", hash=" + Arrays.toString(this.hash) + ", primaryPartition=" + this.primaryPartition + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionWrapper that = (SubscriptionWrapper)o;
        return this.version == that.version && Arrays.equals(this.hash, that.hash) && this.instruction == that.instruction && Objects.equals(this.primaryKey, that.primaryKey) && Objects.equals(this.primaryPartition, that.primaryPartition);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.instruction, this.version, this.primaryKey, this.primaryPartition});
        result = 31 * result + Arrays.hashCode(this.hash);
        return result;
    }

    public static enum Instruction {
        DELETE_KEY_NO_PROPAGATE(0),
        DELETE_KEY_AND_PROPAGATE(1),
        PROPAGATE_NULL_IF_NO_FK_VAL_AVAILABLE(2),
        PROPAGATE_ONLY_IF_FK_VAL_AVAILABLE(3);

        private final byte value;

        private Instruction(byte value) {
            this.value = value;
        }

        public byte value() {
            return this.value;
        }

        public static Instruction fromValue(byte value) {
            for (Instruction i : Instruction.values()) {
                if (i.value != value) continue;
                return i;
            }
            throw new IllegalArgumentException("Unknown instruction byte value = " + value);
        }
    }
}

