/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.relateng;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.algorithm.BoundaryNodeRule;
import org.locationtech.jts.algorithm.PointLocation;
import org.locationtech.jts.algorithm.locate.IndexedPointInAreaLocator;
import org.locationtech.jts.algorithm.locate.PointOnGeometryLocator;
import org.locationtech.jts.algorithm.locate.SimplePointInAreaLocator;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.relateng.AdjacentEdgeLocator;
import org.locationtech.jts.operation.relateng.DimensionLocation;
import org.locationtech.jts.operation.relateng.LinearBoundary;

class RelatePointLocator {
    private Geometry geom;
    private boolean isPrepared = false;
    private BoundaryNodeRule boundaryRule;
    private AdjacentEdgeLocator adjEdgeLocator;
    private Set<Coordinate> points;
    private List<LineString> lines;
    private List<Geometry> polygons;
    private PointOnGeometryLocator[] polyLocator;
    private LinearBoundary lineBoundary;
    private boolean isEmpty;

    public RelatePointLocator(Geometry geom) {
        this(geom, false, BoundaryNodeRule.OGC_SFS_BOUNDARY_RULE);
    }

    public RelatePointLocator(Geometry geom, boolean isPrepared, BoundaryNodeRule bnRule) {
        this.geom = geom;
        this.isPrepared = isPrepared;
        this.boundaryRule = bnRule;
        this.init(geom);
    }

    private void init(Geometry geom) {
        this.isEmpty = geom.isEmpty();
        this.extractElements(geom);
        if (this.lines != null) {
            this.lineBoundary = new LinearBoundary(this.lines, this.boundaryRule);
        }
        if (this.polygons != null) {
            this.polyLocator = this.isPrepared ? new IndexedPointInAreaLocator[this.polygons.size()] : new SimplePointInAreaLocator[this.polygons.size()];
        }
    }

    public boolean hasBoundary() {
        return this.lineBoundary.hasBoundary();
    }

    private void extractElements(Geometry geom) {
        if (geom.isEmpty()) {
            return;
        }
        if (geom instanceof Point) {
            this.addPoint((Point)geom);
        } else if (geom instanceof LineString) {
            this.addLine((LineString)geom);
        } else if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            this.addPolygonal(geom);
        } else if (geom instanceof GeometryCollection) {
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Geometry g = geom.getGeometryN(i);
                this.extractElements(g);
            }
        }
    }

    private void addPoint(Point pt) {
        if (this.points == null) {
            this.points = new HashSet<Coordinate>();
        }
        this.points.add(pt.getCoordinate());
    }

    private void addLine(LineString line) {
        if (this.lines == null) {
            this.lines = new ArrayList<LineString>();
        }
        this.lines.add(line);
    }

    private void addPolygonal(Geometry polygonal) {
        if (this.polygons == null) {
            this.polygons = new ArrayList<Geometry>();
        }
        this.polygons.add(polygonal);
    }

    public int locate(Coordinate p) {
        return DimensionLocation.location(this.locateWithDim(p));
    }

    public int locateLineEndWithDim(Coordinate p) {
        int locPoly;
        if (this.polygons != null && (locPoly = this.locateOnPolygons(p, false, null)) != 2) {
            return DimensionLocation.locationArea(locPoly);
        }
        return this.lineBoundary.isBoundary(p) ? 111 : 110;
    }

    public int locateNode(Coordinate p, Geometry parentPolygonal) {
        return DimensionLocation.location(this.locateNodeWithDim(p, parentPolygonal));
    }

    public int locateNodeWithDim(Coordinate p, Geometry parentPolygonal) {
        return this.locateWithDim(p, true, parentPolygonal);
    }

    public int locateWithDim(Coordinate p) {
        return this.locateWithDim(p, false, null);
    }

    private int locateWithDim(Coordinate p, boolean isNode, Geometry parentPolygonal) {
        if (this.isEmpty) {
            return 2;
        }
        if (isNode && (this.geom instanceof Polygon || this.geom instanceof MultiPolygon)) {
            return 121;
        }
        int dimLoc = this.computeDimLocation(p, isNode, parentPolygonal);
        return dimLoc;
    }

    private int computeDimLocation(Coordinate p, boolean isNode, Geometry parentPolygonal) {
        int locPt;
        int locLine;
        int locPoly;
        if (this.polygons != null && (locPoly = this.locateOnPolygons(p, isNode, parentPolygonal)) != 2) {
            return DimensionLocation.locationArea(locPoly);
        }
        if (this.lines != null && (locLine = this.locateOnLines(p, isNode)) != 2) {
            return DimensionLocation.locationLine(locLine);
        }
        if (this.points != null && (locPt = this.locateOnPoints(p)) != 2) {
            return DimensionLocation.locationPoint(locPt);
        }
        return 2;
    }

    private int locateOnPoints(Coordinate p) {
        if (this.points.contains(p)) {
            return 0;
        }
        return 2;
    }

    private int locateOnLines(Coordinate p, boolean isNode) {
        if (this.lineBoundary != null && this.lineBoundary.isBoundary(p)) {
            return 1;
        }
        if (isNode) {
            return 0;
        }
        for (LineString line : this.lines) {
            int loc = this.locateOnLine(p, isNode, line);
            if (loc == 2) continue;
            return loc;
        }
        return 2;
    }

    private int locateOnLine(Coordinate p, boolean isNode, LineString l) {
        if (!l.getEnvelopeInternal().intersects(p)) {
            return 2;
        }
        CoordinateSequence seq2 = l.getCoordinateSequence();
        if (PointLocation.isOnLine(p, seq2)) {
            return 0;
        }
        return 2;
    }

    private int locateOnPolygons(Coordinate p, boolean isNode, Geometry parentPolygonal) {
        int numBdy = 0;
        for (int i = 0; i < this.polygons.size(); ++i) {
            int loc = this.locateOnPolygonal(p, isNode, parentPolygonal, i);
            if (loc == 0) {
                return 0;
            }
            if (loc != 1) continue;
            ++numBdy;
        }
        if (numBdy == 1) {
            return 1;
        }
        if (numBdy > 1) {
            if (this.adjEdgeLocator == null) {
                this.adjEdgeLocator = new AdjacentEdgeLocator(this.geom);
            }
            return this.adjEdgeLocator.locate(p);
        }
        return 2;
    }

    private int locateOnPolygonal(Coordinate p, boolean isNode, Geometry parentPolygonal, int index) {
        Geometry polygonal = this.polygons.get(index);
        if (isNode && parentPolygonal == polygonal) {
            return 1;
        }
        PointOnGeometryLocator locator = this.getLocator(index);
        return locator.locate(p);
    }

    private PointOnGeometryLocator getLocator(int index) {
        PointOnGeometryLocator locator = this.polyLocator[index];
        if (locator == null) {
            Geometry polygonal = this.polygons.get(index);
            this.polyLocator[index] = locator = this.isPrepared ? new IndexedPointInAreaLocator(polygonal) : new SimplePointInAreaLocator(polygonal);
        }
        return locator;
    }
}

