/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.SimpleCollector;
import org.apache.lucene.util.ArrayUtil;

public abstract class CachingCollector
extends FilterCollector {
    private static final int INITIAL_ARRAY_SIZE = 128;
    private boolean cached = true;

    public static CachingCollector create(boolean cacheScores, double maxRAMMB) {
        SimpleCollector other = new SimpleCollector(){

            @Override
            public void collect(int doc) {
            }

            @Override
            public ScoreMode scoreMode() {
                return ScoreMode.COMPLETE;
            }
        };
        return CachingCollector.create((Collector)other, cacheScores, maxRAMMB);
    }

    public static CachingCollector create(Collector other, boolean cacheScores, double maxRAMMB) {
        int bytesPerDoc = 4;
        if (cacheScores) {
            bytesPerDoc += 4;
        }
        int maxDocsToCache = (int)(maxRAMMB * 1024.0 * 1024.0 / (double)bytesPerDoc);
        return CachingCollector.create(other, cacheScores, maxDocsToCache);
    }

    public static CachingCollector create(Collector other, boolean cacheScores, int maxDocsToCache) {
        return cacheScores ? new ScoreCachingCollector(other, maxDocsToCache) : new NoScoreCachingCollector(other, maxDocsToCache);
    }

    private CachingCollector(Collector in) {
        super(in);
    }

    public final boolean isCached() {
        return this.cached;
    }

    public abstract void replay(Collector var1) throws IOException;

    private class ScoreCachingLeafCollector
    extends NoScoreCachingLeafCollector {
        Scorable scorer;
        float[] scores;

        ScoreCachingLeafCollector(LeafCollector in, int maxDocsToCache, ScoreCachingCollector collector) {
            super(in, maxDocsToCache, collector);
            this.scores = new float[this.docs.length];
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }

        @Override
        protected void grow(int newLen) {
            super.grow(newLen);
            this.scores = ArrayUtil.growExact(this.scores, newLen);
        }

        @Override
        protected void invalidate() {
            super.invalidate();
            this.scores = null;
        }

        @Override
        protected void buffer(int doc) throws IOException {
            super.buffer(doc);
            this.scores[this.docCount] = this.scorer.score();
        }

        float[] cachedScores() {
            return this.docs == null ? null : ArrayUtil.copyOfSubArray(this.scores, 0, this.docCount);
        }

        @Override
        protected void postCollect() {
            super.postCollect();
            ((ScoreCachingCollector)this.collector).scores.add(this.cachedScores());
        }
    }

    private class NoScoreCachingLeafCollector
    extends FilterLeafCollector {
        final int maxDocsToCache;
        final NoScoreCachingCollector collector;
        int[] docs;
        int docCount;

        NoScoreCachingLeafCollector(LeafCollector in, int maxDocsToCache, NoScoreCachingCollector collector) {
            super(in);
            this.maxDocsToCache = maxDocsToCache;
            this.collector = collector;
            this.docs = new int[Math.min(maxDocsToCache, 128)];
            this.docCount = 0;
        }

        protected void grow(int newLen) {
            this.docs = ArrayUtil.growExact(this.docs, newLen);
        }

        protected void invalidate() {
            this.docs = null;
            this.docCount = -1;
            CachingCollector.this.cached = false;
        }

        protected void buffer(int doc) throws IOException {
            this.docs[this.docCount] = doc;
        }

        @Override
        public void collect(int doc) throws IOException {
            if (this.docs != null) {
                if (this.docCount >= this.docs.length) {
                    if (this.docCount >= this.maxDocsToCache) {
                        this.invalidate();
                    } else {
                        int newLen = Math.min(ArrayUtil.oversize(this.docCount + 1, 4), this.maxDocsToCache);
                        this.grow(newLen);
                    }
                }
                if (this.docs != null) {
                    this.buffer(doc);
                    ++this.docCount;
                }
            }
            super.collect(doc);
        }

        protected void postCollect() {
            int[] docs = this.cachedDocs();
            this.collector.maxDocsToCache -= docs.length;
            this.collector.docs.add(docs);
        }

        @Override
        public void finish() {
            if (!this.hasCache()) {
                this.collector.invalidate();
            } else {
                this.postCollect();
            }
        }

        boolean hasCache() {
            return this.docs != null;
        }

        int[] cachedDocs() {
            return this.docs == null ? null : ArrayUtil.copyOfSubArray(this.docs, 0, this.docCount);
        }
    }

    private static class ScoreCachingCollector
    extends NoScoreCachingCollector {
        List<float[]> scores = new ArrayList<float[]>();

        ScoreCachingCollector(Collector in, int maxDocsToCache) {
            super(in, maxDocsToCache);
        }

        @Override
        protected NoScoreCachingLeafCollector wrap(LeafCollector in, int maxDocsToCache) {
            return (CachingCollector)this.new ScoreCachingLeafCollector(in, maxDocsToCache, this);
        }

        @Override
        public ScoreMode scoreMode() {
            return ScoreMode.COMPLETE;
        }

        @Override
        protected void collect(LeafCollector collector, int i) throws IOException {
            int[] docs = (int[])this.docs.get(i);
            float[] scores = this.scores.get(i);
            assert (docs.length == scores.length);
            CachedScorable scorer = new CachedScorable();
            collector.setScorer(scorer);
            for (int j = 0; j < docs.length; ++j) {
                scorer.doc = docs[j];
                scorer.score = scores[j];
                collector.collect(scorer.doc);
            }
        }
    }

    private static class NoScoreCachingCollector
    extends CachingCollector {
        List<LeafReaderContext> contexts;
        List<int[]> docs;
        int maxDocsToCache;

        NoScoreCachingCollector(Collector in, int maxDocsToCache) {
            super(in);
            this.maxDocsToCache = maxDocsToCache;
            this.contexts = new ArrayList<LeafReaderContext>();
            this.docs = new ArrayList<int[]>();
        }

        protected NoScoreCachingLeafCollector wrap(LeafCollector in, int maxDocsToCache) {
            return new NoScoreCachingLeafCollector(in, maxDocsToCache, this);
        }

        @Override
        public LeafCollector getLeafCollector(LeafReaderContext context2) throws IOException {
            LeafCollector in = this.in.getLeafCollector(context2);
            if (this.maxDocsToCache >= 0) {
                if (this.contexts != null) {
                    this.contexts.add(context2);
                }
                return this.wrap(in, this.maxDocsToCache);
            }
            return in;
        }

        protected void invalidate() {
            this.maxDocsToCache = -1;
            this.contexts = null;
            this.docs = null;
        }

        protected void collect(LeafCollector collector, int i) throws IOException {
            int[] docs;
            for (int doc : docs = this.docs.get(i)) {
                collector.collect(doc);
            }
            collector.finish();
        }

        @Override
        public void replay(Collector other) throws IOException {
            if (!this.isCached()) {
                throw new IllegalStateException("cannot replay: cache was cleared because too much RAM was required");
            }
            assert (this.docs.size() == this.contexts.size());
            for (int i = 0; i < this.contexts.size(); ++i) {
                LeafReaderContext context2 = this.contexts.get(i);
                LeafCollector collector = other.getLeafCollector(context2);
                this.collect(collector, i);
            }
        }
    }

    private static final class CachedScorable
    extends Scorable {
        int doc;
        float score;

        private CachedScorable() {
        }

        @Override
        public final float score() {
            return this.score;
        }

        @Override
        public int docID() {
            return this.doc;
        }
    }
}

