/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.internal.hppc;

import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.internal.hppc.AbstractIterator;
import org.apache.lucene.internal.hppc.BitMixer;
import org.apache.lucene.internal.hppc.BufferAllocationException;
import org.apache.lucene.internal.hppc.FloatCursor;
import org.apache.lucene.internal.hppc.HashContainers;
import org.apache.lucene.internal.hppc.LongCursor;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;

public class LongFloatHashMap
implements Iterable<LongFloatCursor>,
Accountable,
Cloneable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(LongFloatHashMap.class);
    public long[] keys;
    public float[] values;
    protected int assigned;
    protected int mask;
    protected int resizeAt;
    protected boolean hasEmptyKey;
    protected double loadFactor;
    protected int iterationSeed;

    public LongFloatHashMap() {
        this(4);
    }

    public LongFloatHashMap(int expectedElements) {
        this(expectedElements, 0.75);
    }

    public LongFloatHashMap(int expectedElements, double loadFactor) {
        this.loadFactor = this.verifyLoadFactor(loadFactor);
        this.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
        this.ensureCapacity(expectedElements);
    }

    public LongFloatHashMap(LongFloatHashMap map) {
        this(map.size());
        this.putAll(map);
    }

    public float put(long key, float value) {
        long existing;
        assert (this.assigned < this.mask + 1);
        int mask = this.mask;
        if (key == 0L) {
            float previousValue = this.hasEmptyKey ? this.values[mask + 1] : 0.0f;
            this.hasEmptyKey = true;
            this.values[mask + 1] = value;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                float previousValue = this.values[slot];
                this.values[slot] = value;
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        if (this.assigned == this.resizeAt) {
            this.allocateThenInsertThenRehash(slot, key, value);
        } else {
            keys[slot] = key;
            this.values[slot] = value;
        }
        ++this.assigned;
        return 0.0f;
    }

    public int putAll(Iterable<? extends LongFloatCursor> iterable) {
        int count = this.size();
        for (LongFloatCursor longFloatCursor : iterable) {
            this.put(longFloatCursor.key, longFloatCursor.value);
        }
        return this.size() - count;
    }

    public boolean putIfAbsent(long key, float value) {
        int keyIndex = this.indexOf(key);
        if (!this.indexExists(keyIndex)) {
            this.indexInsert(keyIndex, key, value);
            return true;
        }
        return false;
    }

    public float putOrAdd(long key, float putValue, float incrementValue) {
        assert (this.assigned < this.mask + 1);
        int keyIndex = this.indexOf(key);
        if (this.indexExists(keyIndex)) {
            putValue = this.values[keyIndex] + incrementValue;
            this.indexReplace(keyIndex, putValue);
        } else {
            this.indexInsert(keyIndex, key, putValue);
        }
        return putValue;
    }

    public float addTo(long key, float incrementValue) {
        return this.putOrAdd(key, incrementValue, incrementValue);
    }

    public float remove(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            if (!this.hasEmptyKey) {
                return 0.0f;
            }
            this.hasEmptyKey = false;
            float previousValue = this.values[mask + 1];
            this.values[mask + 1] = 0.0f;
            return previousValue;
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                float previousValue = this.values[slot];
                this.shiftConflictingKeys(slot);
                return previousValue;
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    public float get(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : 0.0f;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return 0.0f;
    }

    public float getOrDefault(long key, float defaultValue) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey ? this.values[this.mask + 1] : defaultValue;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return this.values[slot];
            }
            slot = slot + 1 & mask;
        }
        return defaultValue;
    }

    public boolean containsKey(long key) {
        long existing;
        if (key == 0L) {
            return this.hasEmptyKey;
        }
        long[] keys = this.keys;
        int mask = this.mask;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return true;
            }
            slot = slot + 1 & mask;
        }
        return false;
    }

    public int indexOf(long key) {
        long existing;
        int mask = this.mask;
        if (key == 0L) {
            return this.hasEmptyKey ? mask + 1 : ~(mask + 1);
        }
        long[] keys = this.keys;
        int slot = this.hashKey(key) & mask;
        while ((existing = keys[slot]) != 0L) {
            if (existing == key) {
                return slot;
            }
            slot = slot + 1 & mask;
        }
        return ~slot;
    }

    public boolean indexExists(int index) {
        assert (index < 0 || index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return index >= 0;
    }

    public float indexGet(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        return this.values[index];
    }

    public float indexReplace(int index, float newValue) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        float previousValue = this.values[index];
        this.values[index] = newValue;
        return previousValue;
    }

    public void indexInsert(int index, long key, float value) {
        assert (index < 0) : "The index must not point at an existing key.";
        index ^= 0xFFFFFFFF;
        if (key == 0L) {
            assert (index == this.mask + 1);
            this.values[index] = value;
            this.hasEmptyKey = true;
        } else {
            assert (this.keys[index] == 0L);
            if (this.assigned == this.resizeAt) {
                this.allocateThenInsertThenRehash(index, key, value);
            } else {
                this.keys[index] = key;
                this.values[index] = value;
            }
            ++this.assigned;
        }
    }

    public float indexRemove(int index) {
        assert (index >= 0) : "The index must point at an existing key.";
        assert (index <= this.mask || index == this.mask + 1 && this.hasEmptyKey);
        float previousValue = this.values[index];
        if (index > this.mask) {
            assert (index == this.mask + 1);
            this.hasEmptyKey = false;
            this.values[index] = 0.0f;
        } else {
            this.shiftConflictingKeys(index);
        }
        return previousValue;
    }

    public void clear() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        Arrays.fill(this.keys, 0L);
    }

    public void release() {
        this.assigned = 0;
        this.hasEmptyKey = false;
        this.keys = null;
        this.values = null;
        this.ensureCapacity(4);
    }

    public int size() {
        return this.assigned + (this.hasEmptyKey ? 1 : 0);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int hashCode() {
        int h = this.hasEmptyKey ? -559038737 : 0;
        for (LongFloatCursor c : this) {
            h += BitMixer.mix(c.key) + BitMixer.mix(c.value);
        }
        return h;
    }

    public boolean equals(Object obj) {
        return this == obj || obj != null && this.getClass() == obj.getClass() && this.equalElements((LongFloatHashMap)this.getClass().cast(obj));
    }

    protected boolean equalElements(LongFloatHashMap other) {
        if (other.size() != this.size()) {
            return false;
        }
        for (LongFloatCursor c : other) {
            long key = c.key;
            if (this.containsKey(key) && Float.floatToIntBits(c.value) == Float.floatToIntBits(this.get(key))) continue;
            return false;
        }
        return true;
    }

    public void ensureCapacity(int expectedElements) {
        if (expectedElements > this.resizeAt || this.keys == null) {
            long[] prevKeys = this.keys;
            float[] prevValues = this.values;
            this.allocateBuffers(HashContainers.minBufferSize(expectedElements, this.loadFactor));
            if (prevKeys != null && !this.isEmpty()) {
                this.rehash(prevKeys, prevValues);
            }
        }
    }

    protected int nextIterationSeed() {
        this.iterationSeed = BitMixer.mixPhi(this.iterationSeed);
        return this.iterationSeed;
    }

    @Override
    public long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(this.keys) + RamUsageEstimator.sizeOf(this.values);
    }

    @Override
    public Iterator<LongFloatCursor> iterator() {
        return new EntryIterator();
    }

    public KeysContainer keys() {
        return new KeysContainer();
    }

    public ValuesContainer values() {
        return new ValuesContainer();
    }

    public LongFloatHashMap clone() {
        try {
            LongFloatHashMap cloned = (LongFloatHashMap)super.clone();
            cloned.keys = (long[])this.keys.clone();
            cloned.values = (float[])this.values.clone();
            cloned.hasEmptyKey = this.hasEmptyKey;
            cloned.iterationSeed = HashContainers.ITERATION_SEED.incrementAndGet();
            return cloned;
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[");
        boolean first = true;
        for (LongFloatCursor cursor : this) {
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(cursor.key);
            buffer.append("=>");
            buffer.append(cursor.value);
            first = false;
        }
        buffer.append("]");
        return buffer.toString();
    }

    public static LongFloatHashMap from(long[] keys, float[] values) {
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Arrays of keys and values must have an identical length.");
        }
        LongFloatHashMap map = new LongFloatHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            map.put(keys[i], values[i]);
        }
        return map;
    }

    protected int hashKey(long key) {
        assert (key != 0L);
        return BitMixer.mixPhi(key);
    }

    protected double verifyLoadFactor(double loadFactor) {
        HashContainers.checkLoadFactor(loadFactor, 0.01f, 0.99f);
        return loadFactor;
    }

    protected void rehash(long[] fromKeys, float[] fromValues) {
        assert (fromKeys.length == fromValues.length && HashContainers.checkPowerOfTwo(fromKeys.length - 1));
        long[] keys = this.keys;
        float[] values = this.values;
        int mask = this.mask;
        int from = fromKeys.length - 1;
        keys[keys.length - 1] = fromKeys[from];
        values[values.length - 1] = fromValues[from];
        while (--from >= 0) {
            long existing = fromKeys[from];
            if (existing == 0L) continue;
            int slot = this.hashKey(existing) & mask;
            while (keys[slot] != 0L) {
                slot = slot + 1 & mask;
            }
            keys[slot] = existing;
            values[slot] = fromValues[from];
        }
    }

    protected void allocateBuffers(int arraySize) {
        assert (Integer.bitCount(arraySize) == 1);
        long[] prevKeys = this.keys;
        float[] prevValues = this.values;
        try {
            int emptyElementSlot = 1;
            this.keys = new long[arraySize + emptyElementSlot];
            this.values = new float[arraySize + emptyElementSlot];
        }
        catch (OutOfMemoryError e2) {
            this.keys = prevKeys;
            this.values = prevValues;
            throw new BufferAllocationException("Not enough memory to allocate buffers for rehashing: %,d -> %,d", (Throwable)e2, this.mask + 1, arraySize);
        }
        this.resizeAt = HashContainers.expandAtCount(arraySize, this.loadFactor);
        this.mask = arraySize - 1;
    }

    protected void allocateThenInsertThenRehash(int slot, long pendingKey, float pendingValue) {
        assert (this.assigned == this.resizeAt && this.keys[slot] == 0L && pendingKey != 0L);
        long[] prevKeys = this.keys;
        float[] prevValues = this.values;
        this.allocateBuffers(HashContainers.nextBufferSize(this.mask + 1, this.size(), this.loadFactor));
        assert (this.keys.length > prevKeys.length);
        prevKeys[slot] = pendingKey;
        prevValues[slot] = pendingValue;
        this.rehash(prevKeys, prevValues);
    }

    protected void shiftConflictingKeys(int gapSlot) {
        int slot;
        long existing;
        long[] keys = this.keys;
        float[] values = this.values;
        int mask = this.mask;
        int distance = 0;
        while ((existing = keys[slot = gapSlot + ++distance & mask]) != 0L) {
            int idealSlot = this.hashKey(existing);
            int shift = slot - idealSlot & mask;
            if (shift < distance) continue;
            keys[gapSlot] = existing;
            values[gapSlot] = values[slot];
            gapSlot = slot;
            distance = 0;
        }
        keys[gapSlot] = 0L;
        values[gapSlot] = 0.0f;
        --this.assigned;
    }

    public static final class LongFloatCursor {
        public int index;
        public long key;
        public float value;

        public String toString() {
            return "[cursor, index: " + this.index + ", key: " + this.key + ", value: " + this.value + "]";
        }
    }

    private final class ValuesIterator
    extends AbstractIterator<FloatCursor> {
        private final FloatCursor cursor = new FloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public ValuesIterator() {
            int seed = LongFloatHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongFloatHashMap.this.mask;
        }

        @Override
        protected FloatCursor fetch() {
            int mask = LongFloatHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                if (LongFloatHashMap.this.keys[this.slot] == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.value = LongFloatHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.value = LongFloatHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (FloatCursor)this.done();
        }
    }

    public final class ValuesContainer
    implements Iterable<FloatCursor> {
        @Override
        public Iterator<FloatCursor> iterator() {
            return new ValuesIterator();
        }

        public int size() {
            return LongFloatHashMap.this.size();
        }

        public float[] toArray() {
            float[] array = new float[this.size()];
            int i = 0;
            for (FloatCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class KeysIterator
    extends AbstractIterator<LongCursor> {
        private final LongCursor cursor = new LongCursor();
        private final int increment;
        private int index;
        private int slot;

        public KeysIterator() {
            int seed = LongFloatHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongFloatHashMap.this.mask;
        }

        @Override
        protected LongCursor fetch() {
            int mask = LongFloatHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                long existing = LongFloatHashMap.this.keys[this.slot];
                if (existing == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.value = existing;
                return this.cursor;
            }
            if (this.index == mask + 1 && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index++;
                this.cursor.value = 0L;
                return this.cursor;
            }
            return (LongCursor)this.done();
        }
    }

    public final class KeysContainer
    implements Iterable<LongCursor> {
        @Override
        public Iterator<LongCursor> iterator() {
            return new KeysIterator();
        }

        public int size() {
            return LongFloatHashMap.this.size();
        }

        public long[] toArray() {
            long[] array = new long[this.size()];
            int i = 0;
            for (LongCursor cursor : this) {
                array[i++] = cursor.value;
            }
            return array;
        }
    }

    private final class EntryIterator
    extends AbstractIterator<LongFloatCursor> {
        private final LongFloatCursor cursor = new LongFloatCursor();
        private final int increment;
        private int index;
        private int slot;

        public EntryIterator() {
            int seed = LongFloatHashMap.this.nextIterationSeed();
            this.increment = HashContainers.iterationIncrement(seed);
            this.slot = seed & LongFloatHashMap.this.mask;
        }

        @Override
        protected LongFloatCursor fetch() {
            int mask = LongFloatHashMap.this.mask;
            while (this.index <= mask) {
                ++this.index;
                this.slot = this.slot + this.increment & mask;
                long existing = LongFloatHashMap.this.keys[this.slot];
                if (existing == 0L) continue;
                this.cursor.index = this.slot;
                this.cursor.key = existing;
                this.cursor.value = LongFloatHashMap.this.values[this.slot];
                return this.cursor;
            }
            if (this.index == mask + 1 && LongFloatHashMap.this.hasEmptyKey) {
                this.cursor.index = this.index;
                this.cursor.key = 0L;
                this.cursor.value = LongFloatHashMap.this.values[this.index++];
                return this.cursor;
            }
            return (LongFloatCursor)this.done();
        }
    }
}

