/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.packed;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

class LegacyPacked64
extends PackedInts.Reader {
    static final int BLOCK_SIZE = 64;
    static final int BLOCK_BITS = 6;
    static final int MOD_MASK = 63;
    private final long[] blocks;
    private final long maskRight;
    private final int bpvMinusBlockSize;
    protected final int valueCount;
    protected final int bitsPerValue;

    public LegacyPacked64(int packedIntsVersion, DataInput in, int valueCount, int bitsPerValue) throws IOException {
        this.valueCount = valueCount;
        this.bitsPerValue = bitsPerValue;
        PackedInts.Format format = PackedInts.Format.PACKED;
        long byteCount = format.byteCount(packedIntsVersion, valueCount, bitsPerValue);
        int longCount = format.longCount(2, valueCount, bitsPerValue);
        this.blocks = new long[longCount];
        int i = 0;
        while ((long)i < byteCount / 8L) {
            this.blocks[i] = in.readLong();
            ++i;
        }
        int remaining = (int)(byteCount % 8L);
        if (remaining != 0) {
            long lastLong = 0L;
            for (int i2 = 0; i2 < remaining; ++i2) {
                lastLong |= ((long)in.readByte() & 0xFFL) << 56 - i2 * 8;
            }
            this.blocks[this.blocks.length - 1] = lastLong;
        }
        this.maskRight = -1L << 64 - bitsPerValue >>> 64 - bitsPerValue;
        this.bpvMinusBlockSize = bitsPerValue - 64;
    }

    @Override
    public final int size() {
        return this.valueCount;
    }

    @Override
    public long get(int index) {
        long majorBitPos = (long)index * (long)this.bitsPerValue;
        int elementPos = (int)(majorBitPos >>> 6);
        long endBits = (majorBitPos & 0x3FL) + (long)this.bpvMinusBlockSize;
        if (endBits <= 0L) {
            return this.blocks[elementPos] >>> (int)(-endBits) & this.maskRight;
        }
        return (this.blocks[elementPos] << (int)endBits | this.blocks[elementPos + 1] >>> (int)(64L - endBits)) & this.maskRight;
    }

    @Override
    public int get(int index, long[] arr, int off, int len) {
        assert (len > 0) : "len must be > 0 (got " + len + ")";
        assert (index >= 0 && index < this.valueCount);
        len = Math.min(len, this.valueCount - index);
        assert (off + len <= arr.length);
        int originalIndex = index;
        PackedInts.Decoder decoder = PackedInts.getDecoder(PackedInts.Format.PACKED, 2, this.bitsPerValue);
        int offsetInBlocks = index % decoder.longValueCount();
        if (offsetInBlocks != 0) {
            for (int i = offsetInBlocks; i < decoder.longValueCount() && len > 0; --len, ++i) {
                arr[off++] = this.get(index++);
            }
            if (len == 0) {
                return index - originalIndex;
            }
        }
        assert (index % decoder.longValueCount() == 0);
        int blockIndex = (int)((long)index * (long)this.bitsPerValue >>> 6);
        assert (((long)index * (long)this.bitsPerValue & 0x3FL) == 0L);
        int iterations = len / decoder.longValueCount();
        decoder.decode(this.blocks, blockIndex, arr, off, iterations);
        int gotValues = iterations * decoder.longValueCount();
        index += gotValues;
        assert ((len -= gotValues) >= 0);
        if (index > originalIndex) {
            return index - originalIndex;
        }
        assert (index == originalIndex);
        return super.get(index, arr, off, len);
    }

    public String toString() {
        return "LegacyPacked64(bitsPerValue=" + this.bitsPerValue + ",size=" + this.size() + ",blocks=" + this.blocks.length + ")";
    }

    @Override
    public long ramBytesUsed() {
        return RamUsageEstimator.alignObjectSize(RamUsageEstimator.NUM_BYTES_OBJECT_HEADER + 12 + 8 + RamUsageEstimator.NUM_BYTES_OBJECT_REF) + RamUsageEstimator.sizeOf(this.blocks);
    }
}

