/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store;

import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.TransactionHandler;
import org.apache.jena.graph.impl.TransactionHandlerBase;
import org.apache.jena.tdb1.store.DatasetGraphTDB;
import org.apache.jena.tdb1.store.GraphTDB;
import org.apache.jena.tdb1.transaction.DatasetGraphTransaction;

public class GraphNonTxnTDB
extends GraphTDB
implements Closeable,
Sync {
    private final DatasetGraphTDB dataset;

    public GraphNonTxnTDB(DatasetGraphTDB dataset, Node graphName) {
        super(dataset, graphName);
        this.dataset = dataset;
    }

    @Override
    public DatasetGraphTDB getDatasetGraphTDB() {
        return this.dataset;
    }

    @Override
    protected DatasetGraphTDB getBaseDatasetGraphTDB() {
        return this.dataset;
    }

    @Override
    public DatasetGraphTransaction getDatasetGraphTransaction() {
        return null;
    }

    @Override
    public TransactionHandler getTransactionHandler() {
        return new TransactionHandlerTDBNonTXn(this);
    }

    private static class TransactionHandlerTDBNonTXn
    extends TransactionHandlerBase {
        private final GraphTDB graph;

        public TransactionHandlerTDBNonTXn(GraphTDB graph) {
            this.graph = graph;
        }

        @Override
        public void abort() {
            throw new UnsupportedOperationException("TDB: 'abort' of a transaction not supported");
        }

        @Override
        public void begin() {
        }

        @Override
        public void commit() {
            this.graph.getDatasetGraphTDB().sync();
        }

        @Override
        public boolean transactionsSupported() {
            return false;
        }
    }
}

