/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.sse.writers;

import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.sparql.sse.Item;
import org.apache.jena.sparql.sse.ItemLift;
import org.apache.jena.sparql.sse.ItemWriter;
import org.apache.jena.sparql.sse.writers.SSEWriteLib;

public class WriterNode {
    private static final int NL = 1;
    private static final int NoNL = -1;
    private static final int NoSP = -2;

    public static void output(IndentedWriter out, Triple triple, SerializationContext naming) {
        SSEWriteLib.startOneLine(out, "triple");
        WriterNode.outputPlain(out, triple, naming);
        SSEWriteLib.finishOneLine(out, "triple");
    }

    public static void outputNoTag(IndentedWriter out, Triple triple, SerializationContext naming) {
        out.print("(");
        WriterNode.outputPlain(out, triple, naming);
        out.print(")");
    }

    public static void outputPlain(IndentedWriter out, Triple triple, SerializationContext naming) {
        WriterNode.output(out, triple.getSubject(), naming);
        out.print(" ");
        WriterNode.output(out, triple.getPredicate(), naming);
        out.print(" ");
        WriterNode.output(out, triple.getObject(), naming);
    }

    public static void output(IndentedWriter out, Quad quad, SerializationContext naming) {
        SSEWriteLib.startOneLine(out, "quad");
        WriterNode.outputPlain(out, quad, naming);
        SSEWriteLib.finishOneLine(out, "quad");
    }

    public static void outputNoTag(IndentedWriter out, Quad quad, SerializationContext naming) {
        out.print("(");
        WriterNode.outputPlain(out, quad, naming);
        out.print(")");
    }

    public static void outputPlain(IndentedWriter out, Quad quad, SerializationContext naming) {
        WriterNode.output(out, quad.getGraph(), naming);
        out.print(" ");
        WriterNode.output(out, quad.getSubject(), naming);
        out.print(" ");
        WriterNode.output(out, quad.getPredicate(), naming);
        out.print(" ");
        WriterNode.output(out, quad.getObject(), naming);
    }

    public static void output(IndentedWriter out, Node node, SerializationContext sCxt) {
        Item item = ItemLift.lowerCompound(node);
        if (item != null) {
            ItemWriter.write(out, item, sCxt);
        } else {
            ItemWriter.write(out, node, sCxt);
        }
    }

    public static void output(IndentedWriter out, List<Node> nodeList, SerializationContext naming) {
        out.print("(");
        boolean first = true;
        for (Node node : nodeList) {
            if (!first) {
                out.print(" ");
            }
            WriterNode.output(out, node, naming);
            first = false;
        }
        out.print(")");
    }

    public static void outputVars(IndentedWriter out, List<Var> vars, SerializationContext sContext) {
        SSEWriteLib.start(out, "vars", -2);
        for (Var v : vars) {
            out.print(" ?");
            out.print(v.getVarName());
        }
        SSEWriteLib.finish(out, "vars");
    }
}

