/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr;

import java.util.Objects;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprNode;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.serializer.SerializationContext;

public class ExprAggregator
extends ExprNode {
    protected Aggregator aggregator;
    protected Var var;
    protected ExprVar exprVar = null;

    public ExprAggregator(Var v, Aggregator agg) {
        this._setVar(v);
        this.aggregator = agg;
    }

    public Var getVar() {
        return this.var;
    }

    public void setVar(Var v) {
        if (this.var != null) {
            throw new ARQInternalErrorException(Lib.className(this) + ": Attempt to set variable to " + String.valueOf(v) + " when already set as " + String.valueOf(this.var));
        }
        if (v == null) {
            throw new ARQInternalErrorException(Lib.className(this) + ": Attempt to set variable to null");
        }
        this._setVar(v);
    }

    private void _setVar(Var v) {
        this.var = v;
        this.exprVar = new ExprVar(this.var);
    }

    public Aggregator getAggregator() {
        return this.aggregator;
    }

    @Override
    public int hashCode() {
        int x = this.aggregator.hashCode();
        if (this.var != null) {
            x ^= this.var.hashCode();
        }
        return x;
    }

    @Override
    public boolean equals(Expr other, boolean bySyntax) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (!(other instanceof ExprAggregator)) {
            return false;
        }
        ExprAggregator agg = (ExprAggregator)other;
        if (!Objects.equals(this.var, agg.var)) {
            return false;
        }
        return Objects.equals(this.aggregator, agg.aggregator);
    }

    @Override
    public ExprVar getExprVar() {
        throw new ARQInternalErrorException();
    }

    @Override
    public Var asVar() {
        throw new ARQInternalErrorException();
    }

    public ExprVar getAggVar() {
        return this.exprVar;
    }

    public String asSparqlExpr(SerializationContext sCxt) {
        return this.aggregator.asSparqlExpr(sCxt);
    }

    @Override
    public ExprAggregator copySubstitute(Binding binding) {
        Var v = this.var;
        Aggregator agg = this.aggregator;
        return new ExprAggregator(v, agg);
    }

    @Override
    public ExprAggregator applyNodeTransform(NodeTransform transform) {
        Node node = (Node)transform.apply(this.var);
        if (!Var.isVar(node)) {
            Log.warn(this, "Attempt to convert an aggregation variable to a non-variable: ignored");
            node = this.var;
        }
        Var v = (Var)node;
        Aggregator agg = this.aggregator.copyTransform(transform);
        return new ExprAggregator(Var.alloc(node), agg);
    }

    @Override
    public String toString() {
        return "(AGG " + (String)(this.var == null ? "<>" : "?" + this.var.getVarName()) + " " + this.aggregator.toString() + ")";
    }

    public Expr copy(Var v) {
        return new ExprAggregator(v, this.aggregator.copy(this.aggregator.getExprList()));
    }

    @Override
    public NodeValue eval(Binding binding, FunctionEnv env) {
        return ExprVar.eval(this.var, binding, env);
    }

    public Expr apply(ExprTransform transform) {
        return transform.transform(this);
    }

    @Override
    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }
}

