/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.core;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Quad;

public class Match {
    public static boolean match(Quad quad, Node g, Node s, Node p, Node o) {
        return Match.match(quad.getGraph(), g) && Match.match(quad.getSubject(), s) && Match.match(quad.getPredicate(), p) && Match.match(quad.getObject(), o);
    }

    public static boolean match(Triple triple, Node s, Node p, Node o) {
        return Match.match(triple.getSubject(), s) && Match.match(triple.getPredicate(), p) && Match.match(triple.getObject(), o);
    }

    public static boolean match(Node node, Node pattern) {
        return pattern == null || pattern == Node.ANY || pattern.equals(node);
    }

    public static boolean matchValue(Node node, Node pattern) {
        Objects.requireNonNull(node);
        return pattern == null || pattern == Node.ANY || pattern.sameValueAs(node);
    }

    public static Stream<Triple> match(Collection<Triple> triples, Node s, Node p, Node o) {
        return triples.stream().filter(t -> Match.match(t, s, p, o));
    }

    public static Stream<Quad> match(Collection<Quad> quads, Node g, Node s, Node p, Node o) {
        return quads.stream().filter(q -> Match.match(q, g, s, p, o));
    }
}

