/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra.walker;

import java.util.Iterator;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpVisitor;
import org.apache.jena.sparql.algebra.op.Op0;
import org.apache.jena.sparql.algebra.op.Op1;
import org.apache.jena.sparql.algebra.op.Op2;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpExt;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpN;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpUnfold;
import org.apache.jena.sparql.algebra.walker.ExprVisitorFunction;
import org.apache.jena.sparql.algebra.walker.OpVisitorByTypeAndExpr;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprAggregator;
import org.apache.jena.sparql.expr.ExprFunction;
import org.apache.jena.sparql.expr.ExprFunction0;
import org.apache.jena.sparql.expr.ExprFunction1;
import org.apache.jena.sparql.expr.ExprFunction2;
import org.apache.jena.sparql.expr.ExprFunction3;
import org.apache.jena.sparql.expr.ExprFunctionN;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprNone;
import org.apache.jena.sparql.expr.ExprTripleTerm;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.ExprVisitor;
import org.apache.jena.sparql.expr.NodeValue;

public class WalkerVisitor
implements OpVisitorByTypeAndExpr,
ExprVisitorFunction {
    protected final ExprVisitor exprVisitor;
    protected final OpVisitor opVisitor;
    protected int opDepthLimit = Integer.MAX_VALUE;
    protected int exprDepthLimit = Integer.MAX_VALUE;
    protected int opDepth = 0;
    protected int exprDepth = 0;
    private final OpVisitor beforeVisitor;
    private final OpVisitor afterVisitor;

    public WalkerVisitor(OpVisitor opVisitor, ExprVisitor exprVisitor, OpVisitor before, OpVisitor after) {
        this.opVisitor = opVisitor;
        this.exprVisitor = exprVisitor;
        if (this.opDepthLimit < 0) {
            this.opDepthLimit = Integer.MAX_VALUE;
        }
        if (this.exprDepth < 0) {
            this.exprDepthLimit = Integer.MAX_VALUE;
        }
        this.opDepth = 0;
        this.exprDepth = 0;
        this.beforeVisitor = before;
        this.afterVisitor = after;
    }

    protected final void before(Op op) {
        if (this.beforeVisitor != null) {
            op.visit(this.beforeVisitor);
        }
    }

    protected final void after(Op op) {
        if (this.afterVisitor != null) {
            op.visit(this.afterVisitor);
        }
    }

    public void walk(Op op) {
        if (op == null) {
            return;
        }
        if (this.opDepth == this.opDepthLimit) {
            return;
        }
        ++this.opDepth;
        try {
            op.visit(this);
        }
        finally {
            --this.opDepth;
        }
    }

    public void walk(Expr expr) {
        if (expr == null) {
            return;
        }
        if (this.exprDepth == this.exprDepthLimit) {
            return;
        }
        ++this.exprDepth;
        try {
            expr.visit(this);
        }
        finally {
            --this.exprDepth;
        }
    }

    public void walk(ExprList exprList) {
        if (exprList == null) {
            return;
        }
        exprList.forEach(e2 -> this.walk((Expr)e2));
    }

    public void walk(VarExprList varExprList) {
        if (varExprList == null) {
            return;
        }
        varExprList.forEachVarExpr((v, e2) -> {
            Expr expr = e2 != null ? e2 : Expr.NONE;
            this.walk(expr);
        });
    }

    @Override
    public void visitExpr(ExprList exprList) {
        if (this.exprVisitor != null) {
            this.walk(exprList);
        }
    }

    @Override
    public void visitVarExpr(VarExprList varExprList) {
        if (this.exprVisitor != null) {
            this.walk(varExprList);
        }
    }

    public void visitOp(Op op) {
        this.before(op);
        if (this.opVisitor != null) {
            op.visit(this);
        }
        this.after(op);
    }

    @Override
    public void visit0(Op0 op) {
        this.before(op);
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after(op);
    }

    @Override
    public void visit1(Op1 op) {
        this.before(op);
        this.visit1$(op);
        this.after(op);
    }

    private void visit1$(Op1 op) {
        if (op.getSubOp() != null) {
            op.getSubOp().visit(this);
        }
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
    }

    @Override
    public void visit2(Op2 op) {
        this.before(op);
        if (op.getLeft() != null) {
            op.getLeft().visit(this);
        }
        if (op.getRight() != null) {
            op.getRight().visit(this);
        }
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after(op);
    }

    @Override
    public void visitN(OpN op) {
        this.before(op);
        Iterator<Op> iter = op.iterator();
        while (iter.hasNext()) {
            Op sub = iter.next();
            sub.visit(this);
        }
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after(op);
    }

    @Override
    public void visitExt(OpExt op) {
        this.before(op);
        if (this.opVisitor != null) {
            op.visit(this.opVisitor);
        }
        this.after(op);
    }

    @Override
    public void visit(OpOrder opOrder) {
        this.visit1(opOrder);
    }

    @Override
    public void visit(OpAssign opAssign) {
        this.before(opAssign);
        VarExprList varExpr = opAssign.getVarExprList();
        this.visitVarExpr(varExpr);
        this.visit1$(opAssign);
        this.after(opAssign);
    }

    @Override
    public void visit(OpExtend opExtend) {
        this.before(opExtend);
        VarExprList varExpr = opExtend.getVarExprList();
        this.visitVarExpr(varExpr);
        this.visit1$(opExtend);
        this.after(opExtend);
    }

    @Override
    public void visit(OpUnfold opUnfold) {
        this.before(opUnfold);
        ExprList varExpr = new ExprList(opUnfold.getExpr());
        this.visitExpr(varExpr);
        this.visit1$(opUnfold);
        this.after(opUnfold);
    }

    @Override
    public void visit(ExprFunction0 func) {
        this.visitExprFunction(func);
    }

    @Override
    public void visit(ExprFunction1 func) {
        this.visitExprFunction(func);
    }

    @Override
    public void visit(ExprFunction2 func) {
        this.visitExprFunction(func);
    }

    @Override
    public void visit(ExprFunction3 func) {
        this.visitExprFunction(func);
    }

    @Override
    public void visit(ExprFunctionN func) {
        this.visitExprFunction(func);
    }

    @Override
    public void visitExprFunction(ExprFunction func) {
        for (int i = 1; i <= func.numArgs(); ++i) {
            Expr expr = func.getArg(i);
            if (expr == null) {
                Expr.NONE.visit(this);
                continue;
            }
            expr.visit(this);
        }
        if (this.exprVisitor != null) {
            func.visit(this.exprVisitor);
        }
    }

    @Override
    public void visit(ExprFunctionOp funcOp) {
        this.walk(funcOp.getGraphPattern());
        if (this.exprVisitor != null) {
            funcOp.visit(this.exprVisitor);
        }
    }

    @Override
    public void visit(NodeValue nv) {
        if (this.exprVisitor != null) {
            nv.visit(this.exprVisitor);
        }
    }

    @Override
    public void visit(ExprTripleTerm exTripleTerm) {
        if (this.exprVisitor != null) {
            exTripleTerm.visit(this.exprVisitor);
        }
    }

    @Override
    public void visit(ExprVar v) {
        if (this.exprVisitor != null) {
            v.visit(this.exprVisitor);
        }
    }

    @Override
    public void visit(ExprNone none) {
        if (this.exprVisitor != null) {
            none.visit(this.exprVisitor);
        }
    }

    @Override
    public void visit(ExprAggregator eAgg) {
        this.visitAssignVar(eAgg.getAggVar().asVar());
        if (this.exprVisitor != null) {
            eAgg.visit(this.exprVisitor);
        }
    }
}

